/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.renderer.entity;

import com.yahoo.chirpycricket.mythicmounts.client.renderer.entity.LeashRenderer;
import com.yahoo.chirpycricket.mythicmounts.client.renderer.model.AnimatedLivingEntityModel;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import net.minecraft.class_1297;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class MountRenderer
extends GeoEntityRenderer<MountEntity> {
    LeashRenderer leashRender;
    boolean glowing = false;
    float shadRad = 1.0f;
    private final String texturePath = "textures/model/entity/";
    private final String betterStatsScreen = "io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen";

    public MountRenderer(class_5617.class_5618 renderManager, Entities.EntityMapEntry entry) {
        super(renderManager, new AnimatedLivingEntityModel(entry.geo, entry.ani, entry.tex, entry.scaleAdjustment, entry.hasExtraArmor));
        this.field_4673 = entry.shadowRadius;
        this.shadRad = entry.shadowRadius;
        this.glowing = entry.shouldGlow;
        this.addRenderLayer(new ArmorOverlayFeatureRenderer((GeoRenderer<MountEntity>)this, new ArmorOverlayEntityRenderer(renderManager, (GeoModel<MountEntity>)this.getGeoModel())));
    }

    public void render(MountEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        this.field_4673 = entity.method_6109() || entity.getIsMini() ? this.shadRad * entity.childScale : this.shadRad;
        if (this.glowing) {
            light = 255;
        }
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public class_2960 getTexture(MountEntity entity) {
        Object filename = entity.getTextureFile() != null && !entity.getTextureFile().equals("") && !entity.getTextureFile().equals("textures/model/entity/") ? entity.getTextureFile() : entity.getDefaultTexture();
        if (entity.method_19538().equals((Object)class_243.field_1353) && class_310.method_1551().field_1755 != null) {
            filename = "textures/model/entity/" + entity.getDefaultTexture();
        }
        return new class_2960("mythicmounts", (String)filename);
    }

    public int getBlockLight2(MountEntity mobEntity, class_2338 blockPos) {
        return this.method_24087((class_1297)mobEntity, blockPos);
    }

    public class_1921 getRenderType(MountEntity animatable, class_2960 textureLocation, class_4597 bufferSource, float partialTicks) {
        if (class_310.method_1551().field_1755 instanceof GuiBookEntry) {
            return super.getRenderType((GeoAnimatable)animatable, textureLocation, bufferSource, partialTicks);
        }
        return class_1921.method_23580((class_2960)textureLocation);
    }

    public class ArmorOverlayFeatureRenderer
    extends GeoRenderLayer<MountEntity> {
        private final ArmorOverlayEntityRenderer armorOverlayEntityRenderer;
        class_2960 armorTextureLocation;

        public ArmorOverlayFeatureRenderer(GeoRenderer<MountEntity> entityRendererIn, ArmorOverlayEntityRenderer armorOverlayEntityRenderer) {
            super(entityRendererIn);
            this.armorTextureLocation = null;
            this.armorOverlayEntityRenderer = armorOverlayEntityRenderer;
        }

        public void render(class_4587 poseStack, MountEntity mountEntity, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
            String[] overlays = mountEntity.getOverlays();
            if (overlays != null && overlays.length > 0) {
                this.armorOverlayEntityRenderer.useTint = false;
                for (String overlay : overlays) {
                    if (overlay.length() <= 0) continue;
                    this.armorTextureLocation = new class_2960("mythicmounts", overlay);
                    this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)mountEntity, renderType, bufferSource.getBuffer(class_1921.method_23580((class_2960)this.armorTextureLocation)), partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            if (mountEntity.method_6753()) {
                this.armorTextureLocation = new class_2960("mythicmounts", mountEntity.getArmorTextureFile());
                class_1792 equippedArmor = mountEntity.method_6786().method_7909();
                float a = 1.0f;
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (equippedArmor instanceof class_1768) {
                    class_1768 c = (class_1768)equippedArmor;
                    int m = c.method_7800(mountEntity.method_6786());
                    r = (float)(m >> 16 & 0xFF) / 255.0f;
                    g = (float)(m >> 8 & 0xFF) / 255.0f;
                    b = (float)(m & 0xFF) / 255.0f;
                }
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)mountEntity, renderType, bufferSource.getBuffer(class_1921.method_23580((class_2960)this.armorTextureLocation)), partialTick, packedLight, packedOverlay, r, g, b, a);
            }
        }
    }

    public class ArmorOverlayEntityRenderer
    extends GeoEntityRenderer<MountEntity> {
        public boolean useTint;

        protected ArmorOverlayEntityRenderer(class_5617.class_5618 ctx, GeoModel<MountEntity> modelProvider) {
            super(ctx, modelProvider);
            this.useTint = false;
        }

        public Color getRenderColor(MountEntity mountEntity, float partialTick, int packedLight) {
            if (this.useTint && mountEntity.method_6753()) {
                class_2960 armorTextureLocation = new class_2960("mythicmounts", mountEntity.getArmorTextureFile());
                class_1792 equippedArmor = mountEntity.method_6786().method_7909();
                if (equippedArmor instanceof class_1768) {
                    class_1768 c = (class_1768)equippedArmor;
                    int m = c.method_7800(mountEntity.method_6786());
                    return new Color(m);
                }
            }
            return Color.WHITE;
        }
    }
}

