/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockType {
    private final BiMap<String, Object> children = HashBiMap.create();
    public final class_2960 id;

    protected BlockType(class_2960 resourceLocation) {
        this.id = resourceLocation;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.id.method_12832();
    }

    public String getNamespace() {
        return this.id.method_12836();
    }

    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    public String getVariantId(String baseName) {
        String namespace;
        String string = namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) {
            return namespace + String.format(baseName, this.getTypeName());
        }
        return namespace + baseName + "_" + this.getTypeName();
    }

    public String getVariantId(String baseName, boolean prefix) {
        return this.getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    public String getVariantId(String postfix, String prefix) {
        return this.getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @Nullable
    protected <V> V findRelatedEntry(String appendedName, class_2378<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String append, String postPend, class_2378<V> reg) {
        Object post = postPend.isEmpty() ? "" : "_" + postPend;
        class_2960[] targets = new class_2960[]{new class_2960(this.id.method_12836(), "wood/planks/" + this.id.method_12832() + "_" + append), new class_2960(this.id.method_12836(), "wood/" + append + (String)post + "/" + this.id.method_12832()), new class_2960(this.id.method_12836(), this.id.method_12832() + "_" + append + (String)post), new class_2960(this.id.method_12836(), append + "_" + this.id.method_12832() + (String)post), new class_2960(this.id.method_12836(), this.id.method_12832() + "_planks_" + append + (String)post)};
        Object found = null;
        for (class_2960 r : targets) {
            if (!reg.method_10250(r)) continue;
            found = reg.method_10223(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    @Nullable
    public class_1792 getItemOfThis(String key) {
        class_1792 i;
        Object v = this.getChild(key);
        return v instanceof class_1792 ? (i = (class_1792)v) : null;
    }

    @Nullable
    public class_2248 getBlockOfThis(String key) {
        class_2248 b;
        Object v = this.getChild(key);
        return v instanceof class_2248 ? (b = (class_2248)v) : null;
    }

    @Nullable
    public Object getChild(String key) {
        return this.children.get((Object)key);
    }

    public void addChild(String genericName, @Nullable Object itemLike) {
        if (itemLike != null) {
            try {
                this.children.put((Object)genericName, itemLike);
                BlockTypeRegistry<?> v = BlockSetInternal.getRegistry(this.getClass());
                if (v != null) {
                    v.mapBlockToType(itemLike, this);
                }
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to add block type child: value already present. Key {}, Object {}, BlockType {}", (Object)genericName, itemLike, (Object)this);
            }
        }
    }

    protected abstract void initializeChildrenBlocks();

    protected abstract void initializeChildrenItems();

    public abstract class_1935 mainChild();

    @Nullable
    public String getChildKey(Object child) {
        return (String)this.children.inverse().get(child);
    }

    @Nullable
    public static Object changeType(Object current, BlockType originalMat, BlockType destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    @Nullable
    public static class_1792 changeItemType(class_1792 current, BlockType originalMat, BlockType destinationMat) {
        class_2248 il;
        class_1792 i;
        class_1747 bi;
        Object blockChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current instanceof class_1747 && (blockChanged = BlockType.changeType((bi = (class_1747)current).method_7711(), originalMat, destinationMat)) instanceof class_2248 && (i = (il = (class_2248)blockChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_1935) {
            class_1935 il2 = (class_1935)changed;
            if (il2.method_8389() == current) {
                Moonlight.LOGGER.error("Somehow changed an item type into itself. How? Target mat {}, destination map {}, item {}", (Object)destinationMat, (Object)originalMat, (Object)il2);
            }
            return il2.method_8389();
        }
        return null;
    }

    @Nullable
    public static class_2248 changeBlockType(@NotNull class_2248 current, BlockType originalMat, BlockType destinationMat) {
        class_1747 bi;
        class_1792 i;
        Object itemChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current.method_8389() != class_1802.field_8162 && (itemChanged = BlockType.changeType(current.method_8389(), originalMat, destinationMat)) instanceof class_1747 && (i = (bi = (class_1747)itemChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_2248) {
            class_2248 b = (class_2248)changed;
            return b;
        }
        return null;
    }

    public class_2498 getSound() {
        class_1935 class_19352 = this.mainChild();
        if (class_19352 instanceof class_2248) {
            class_2248 b = (class_2248)class_19352;
            return b.method_9573(b.method_9564());
        }
        return class_2498.field_11544;
    }

    @FunctionalInterface
    public static interface SetFinder<T extends BlockType>
    extends Supplier<Optional<T>> {
        @Override
        public Optional<T> get();
    }
}

