/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ConfigValue;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public class IntConfigValue
extends ConfigValue<Integer> {
    private final Integer min;
    private final Integer max;

    public IntConfigValue(String name, Integer defaultValue, Integer min, Integer max) {
        super(name, defaultValue);
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isValid(Integer value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                this.value = element.get(this.name).getAsInt();
                if (this.isValid((Integer)this.value)) {
                    return;
                }
                this.value = this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Moonlight.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            Moonlight.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        object.addProperty(this.name, (Number)this.value);
    }

    public Integer getMax() {
        return this.max;
    }

    public Integer getMin() {
        return this.min;
    }
}

