/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.modernworldcreation.util.rendering.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.modernworldcreation.ModernWorldCreation;
import de.keksuccino.modernworldcreation.util.rendering.screens.ExtendedCreateWorldScreen;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_525;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleModeButton
extends class_4185 {
    protected static final class_2960 INFO_BACKGROUND_TEXTURE = new class_2960("modernworldcreation", "textures/info_back.png");
    @NotNull
    protected final class_525 parent;
    @NotNull
    protected class_2960 texture;
    @NotNull
    protected class_2561 label;
    protected boolean selected = false;
    protected int animationTicker = 1;
    @NotNull
    protected Color labelBackgroundColor = new Color(0, 0, 0, 140);
    protected int addToHeightWhenHovered = 10;
    protected int labelBackgroundHeight = 16;
    protected boolean darkenWhenUnfocused = true;
    protected boolean showInfo = true;
    @NotNull
    protected Color borderColor;
    @Nullable
    protected List<class_2561> infoTooltip = null;
    protected int infoX = 0;
    protected int infoY = 0;
    protected int infoWidth = 10;
    protected int infoHeight = 10;
    protected float infoBorderWidth = 0.4f;
    @NotNull
    protected Color infoBackgroundColor = new Color(0, 0, 0, 255);
    @NotNull
    protected Color infoBorderColor = new Color(224, 224, 224, 255);
    protected boolean infoHovered = false;

    public ToggleModeButton(@NotNull class_525 parent, int x, int y, int width, int height, @NotNull class_2960 texture, @NotNull class_2561 label, @NotNull class_4185.class_4241 clickAction) {
        super(x, y, width, height, label, clickAction, field_40754);
        this.parent = parent;
        this.texture = texture;
        this.label = label;
        this.borderColor = RenderUtils.getColorFromHexString((String)ModernWorldCreation.getOptions().buttonBorderHexColor.getValue());
        if (this.borderColor == null) {
            this.borderColor = new Color(255, 255, 255, 255);
        }
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this._renderWidget(graphics, mouseX, mouseY, partial);
    }

    protected void _renderWidget(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.field_22764) {
            return;
        }
        int w = this.method_25368();
        int h = this.method_25364();
        int x = this.method_46426();
        int y = this.method_46427();
        class_327 font = class_310.method_1551().field_1772;
        if (this.method_25367() || this.selected) {
            if (this.animationTicker < this.addToHeightWhenHovered) {
                ++this.animationTicker;
            }
            h += this.animationTicker;
            y -= this.animationTicker / 2;
        } else if (this.animationTicker > 1) {
            h += this.animationTicker;
            y -= this.animationTicker / 2;
            --this.animationTicker;
        }
        this.infoX = this.method_46426() + this.field_22758 - this.infoWidth - 2;
        this.infoY = this.animationTicker > 1 ? this.method_46427() - this.animationTicker / 2 + 2 : this.method_46427() + 2;
        if (!this.method_25367() && !this.selected && this.darkenWhenUnfocused) {
            RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)this.field_22765);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        }
        graphics.method_25290(this.texture, x, y, 0.0f, 0.0f, w, h, this.method_25368(), this.method_25364() + this.addToHeightWhenHovered);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int backY = y + h - 10 - this.labelBackgroundHeight;
        if (this.animationTicker > 1) {
            backY += this.animationTicker / 2;
        }
        graphics.method_51739(class_1921.method_51784(), x, backY, x + w, backY + this.labelBackgroundHeight, this.labelBackgroundColor.getRGB());
        class_5250 labelComponent = this.label.method_27661().method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        int sWidth = font.method_27525((class_5348)labelComponent);
        Objects.requireNonNull(font);
        int sHeight = 9;
        int sX = x + w / 2 - sWidth / 2;
        int sY = y + h - 10 - this.labelBackgroundHeight / 2 - sHeight / 2;
        if (this.animationTicker > 1) {
            sY += this.animationTicker / 2;
        }
        graphics.method_51439(font, (class_2561)labelComponent, sX, sY, -1, false);
        this.renderBorder(graphics);
        if (this.showInfo) {
            this.renderInfo(graphics, mouseX, mouseY, partial);
        }
    }

    protected void renderInfo(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.infoHovered = ToggleModeButton.isXYInArea(mouseX, mouseY, this.infoX, this.infoY, this.infoWidth, this.infoHeight);
        graphics.method_25294(this.infoX, this.infoY, this.infoX + this.infoWidth, this.infoY + this.infoHeight, this.infoBackgroundColor.getRGB());
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)this.infoX, (float)this.infoY, (float)(this.infoX + this.infoWidth), (float)((float)this.infoY + this.infoBorderWidth), (int)this.infoBorderColor.getRGB(), (float)this.field_22765);
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)this.infoX, (float)((float)(this.infoY + this.infoHeight) - this.infoBorderWidth), (float)(this.infoX + this.infoWidth), (float)(this.infoY + this.infoHeight), (int)this.infoBorderColor.getRGB(), (float)this.field_22765);
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)this.infoX, (float)((float)this.infoY + this.infoBorderWidth), (float)((float)this.infoX + this.infoBorderWidth), (float)((float)(this.infoY + this.infoHeight) - this.infoBorderWidth), (int)this.infoBorderColor.getRGB(), (float)this.field_22765);
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)((float)(this.infoX + this.infoWidth) - this.infoBorderWidth), (float)((float)this.infoY + this.infoBorderWidth), (float)(this.infoX + this.infoWidth), (float)((float)(this.infoY + this.infoHeight) - this.infoBorderWidth), (int)this.infoBorderColor.getRGB(), (float)this.field_22765);
        graphics.method_51452();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        graphics.method_25290(INFO_BACKGROUND_TEXTURE, this.infoX, this.infoY, 0.0f, 0.0f, this.infoWidth, this.infoHeight, this.infoWidth, this.infoHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isInfoHovered() && this.infoTooltip != null) {
            ((ExtendedCreateWorldScreen)this.parent).postPostRenderTask_ModernWorldCreation((graphics1, mouseX1, mouseY1, partial1) -> {
                if (this.infoTooltip.isEmpty()) {
                    return;
                }
                if (this.infoTooltip.size() == 1) {
                    graphics1.method_51447(class_310.method_1551().field_1772, class_7919.method_47406((class_310)class_310.method_1551(), (class_2561)this.infoTooltip.get(0)), mouseX1, mouseY1);
                } else {
                    graphics1.method_51434(class_310.method_1551().field_1772, this.infoTooltip, mouseX1, mouseY1);
                }
            });
        }
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    protected void renderBorder(@NotNull class_332 graphics) {
        float thickness = ModernWorldCreation.getOptions().buttonBorderThickness.getValue().floatValue();
        int bY = this.method_46427();
        int heightOffset = 0;
        if (this.animationTicker > 1) {
            bY -= this.animationTicker / 2;
            heightOffset += this.animationTicker;
        }
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)this.method_46426(), (float)((float)bY - thickness), (float)(this.method_46426() + this.method_25368()), (float)bY, (int)this.borderColor.getRGB(), (float)1.0f);
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)((float)this.method_46426() - thickness), (float)((float)bY - thickness), (float)this.method_46426(), (float)((float)(bY + this.method_25364()) + thickness + (float)heightOffset), (int)this.borderColor.getRGB(), (float)1.0f);
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)this.method_46426(), (float)(bY + this.method_25364() + heightOffset), (float)(this.method_46426() + this.method_25368()), (float)((float)(bY + this.method_25364()) + thickness + (float)heightOffset), (int)this.borderColor.getRGB(), (float)1.0f);
        graphics.method_51452();
        RenderUtils.fill((class_332)graphics, (float)(this.method_46426() + this.method_25368()), (float)((float)bY - thickness), (float)((float)(this.method_46426() + this.method_25368()) + thickness), (float)((float)(bY + this.method_25364()) + thickness + (float)heightOffset), (int)this.borderColor.getRGB(), (float)1.0f);
        graphics.method_51452();
    }

    public void setTexture(@NotNull class_2960 texture) {
        this.texture = texture;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setInfoTooltip(@Nullable List<class_2561> tooltip) {
        this.infoTooltip = tooltip;
    }

    @Nullable
    public List<class_2561> getInfoTooltip() {
        return this.infoTooltip;
    }

    public boolean isInfoHovered() {
        if (!this.showInfo) {
            return false;
        }
        return this.infoHovered;
    }

    public void setShowInfo(boolean showInfo) {
        this.showInfo = showInfo;
    }

    public boolean isShowInfo() {
        return this.showInfo;
    }

    @NotNull
    protected class_5250 method_25360() {
        if (this.infoTooltip == null) {
            return super.method_25360();
        }
        class_5250 c = super.method_25360();
        this.infoTooltip.forEach(component -> {
            c.method_27693(" ");
            c.method_10852((class_2561)component.method_27661());
        });
        return c;
    }
}

