/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.structure;

import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_4284;
import net.minecraft.class_7871;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.util.FileUtil;

public class CachingStructureManager {
    private static ThreadLocal<MessageDigest> digestThreadLocal = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    });
    private static final File STRUCTURE_CACHE_FOLDER = FileUtil.childFile(ModernFixPlatformHooks.INSTANCE.getGameDirectory().resolve("modernfix").resolve("structureCacheV1").toFile());
    private static final Set<String> laggyStructureMods;
    private static final int MAX_HASH_LENGTH = 9;

    public static class_3499 readStructure(class_2960 location, DataFixer datafixer, InputStream stream, class_7871<class_2248> blockGetter) throws IOException {
        class_2487 tag = CachingStructureManager.readStructureTag(location, datafixer, stream);
        class_3499 template = new class_3499();
        template.method_15183(blockGetter, tag);
        return template;
    }

    private static String encodeHex(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static String truncateHash(String hash) {
        return hash.substring(0, 10);
    }

    public static class_2487 readStructureTag(class_2960 location, DataFixer datafixer, InputStream stream) throws IOException {
        int requiredMinimumDataVersion;
        int currentDataVersion;
        byte[] structureBytes = CachingStructureManager.toBytes(stream);
        class_2487 currentTag = class_2507.method_10629((InputStream)new ByteArrayInputStream(structureBytes));
        if (!currentTag.method_10573("DataVersion", 99)) {
            currentTag.method_10569("DataVersion", 500);
        }
        if ((currentDataVersion = currentTag.method_10550("DataVersion")) < (requiredMinimumDataVersion = class_155.method_16673().method_37912().method_38494())) {
            MessageDigest hasher = digestThreadLocal.get();
            hasher.reset();
            String hash = CachingStructureManager.encodeHex(hasher.digest(structureBytes));
            class_2487 cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, CachingStructureManager.truncateHash(hash));
            if (cachedUpgraded == null) {
                cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, hash);
            }
            if (cachedUpgraded != null && cachedUpgraded.method_10550("DataVersion") == requiredMinimumDataVersion) {
                ModernFix.LOGGER.debug("Using cached upgraded version of {}", (Object)location);
                currentTag = cachedUpgraded;
            } else {
                ModernFix.LOGGER.debug("Structure {} is being run through DFU (hash {}), this will cause launch time delays", (Object)location, (Object)hash);
                currentTag = class_4284.field_19217.method_48131(datafixer, currentTag, currentDataVersion, class_155.method_16673().method_37912().method_38494());
                currentTag.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
                CachingStructureManager.saveCachedUpgraded(location, hash, currentTag);
            }
        }
        return currentTag;
    }

    private static File getCachePath(class_2960 location, String hash) {
        String fileName = location.method_12836() + "_" + location.method_12832().replace('/', '_') + "_" + hash + ".nbt";
        return new File(STRUCTURE_CACHE_FOLDER, fileName);
    }

    private static synchronized class_2487 getCachedUpgraded(class_2960 location, String hash) {
        File theFile = CachingStructureManager.getCachePath(location, hash);
        try {
            return class_2507.method_30613((File)theFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static synchronized void saveCachedUpgraded(class_2960 location, String hash, class_2487 tagToSave) {
        File theFile = CachingStructureManager.getCachePath(location, CachingStructureManager.truncateHash(hash));
        try {
            class_2507.method_30614((class_2487)tagToSave, (File)theFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] toBytes(InputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] tmp = new byte[16384];
        while ((n = stream.read(tmp, 0, tmp.length)) != -1) {
            buffer.write(tmp, 0, n);
        }
        return buffer.toByteArray();
    }

    static {
        STRUCTURE_CACHE_FOLDER.mkdirs();
        laggyStructureMods = new ObjectOpenHashSet();
    }
}

