/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3298;
import net.minecraft.class_5250;
import net.minecraft.class_6860;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.structure.CachingStructureManager;

public class ModernFixCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"modernfix").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"upgradeStructures").requires(source -> source.method_9259(3))).executes(context -> {
            class_3218 level = ((class_2168)context.getSource()).method_9225();
            if (level == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Couldn't find server level"));
                return 0;
            }
            class_6860 manager = level.method_8503().field_25318.comp_352();
            Map structures = manager.method_14488("structures", p -> p.method_12832().endsWith(".nbt"));
            int upgradedNum = 0;
            Pattern pathPattern = Pattern.compile("^structures/(.*)\\.nbt$");
            for (Map.Entry entry : structures.entrySet()) {
                ++upgradedNum;
                class_2960 found = (class_2960)entry.getKey();
                Matcher matcher = pathPattern.matcher(found.method_12832());
                if (!matcher.matches()) continue;
                class_2960 structureLocation = new class_2960(found.method_12836(), matcher.group(1));
                try {
                    InputStream resource = ((class_3298)entry.getValue()).method_14482();
                    try {
                        CachingStructureManager.readStructureTag(structureLocation, level.method_8503().method_3855(), resource);
                        class_5250 msg = class_2561.method_43470((String)("checked " + String.valueOf(structureLocation) + " (" + upgradedNum + "/" + structures.size() + ")"));
                        ((class_2168)context.getSource()).method_9226(() -> ModernFixCommands.lambda$register$2((class_2561)msg), false);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Throwable e) {
                    ModernFix.LOGGER.error("Couldn't upgrade structure " + String.valueOf(found), e);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("error reading " + String.valueOf(structureLocation) + " (" + upgradedNum + "/" + structures.size() + ")")));
                }
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"All structures upgraded"), false);
            return 1;
        })));
    }

    private static /* synthetic */ class_2561 lambda$register$2(class_2561 msg) {
        return msg;
    }
}

