/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.utils;

import com.kryeit.MinecraftServerSupplier;
import com.kryeit.client.ClientMissionData;
import com.kryeit.missions.MissionType;
import com.kryeit.missions.MissionTypeRegistry;
import com.kryeit.registry.ModStats;
import com.kryeit.utils.fabric.UtilsImpl;
import com.mojang.brigadier.ParseResults;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;

public class Utils {
    private static final Random RANDOM = new Random();
    private static final class_1799 DEFAULT_SPAWN_EGG = ((class_1792)class_7923.field_41178.method_10223(new class_2960("player_head"))).method_7854();

    public static int getDay() {
        return (int)(System.currentTimeMillis() / 86400000L);
    }

    public static int getDayOfWeek() {
        return (Utils.getDay() + 3) % 7;
    }

    public static class_1799 getItem(class_2960 item) {
        return ((class_1792)class_7923.field_41178.method_10223(item)).method_7854();
    }

    public static class_1799 getItem(class_2960 item, int amount) {
        class_1799 stack = Utils.getItem(item);
        stack.method_7939(amount);
        return stack;
    }

    @Contract(value="_ -> !null")
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return UtilsImpl.isModLoaded(id);
    }

    public static void broadcastMessage(class_2561 message) {
        MinecraftServer server = MinecraftServerSupplier.getServer();
        if (server != null) {
            server.method_3760().method_43514(message, false);
        }
    }

    public static void giveItem(class_1799 stack, class_3222 player) {
        int stackSize = stack.method_7914();
        int l = stack.method_7947();
        while (l > 0) {
            class_1542 itemEntity;
            int m = Math.min(stackSize, l);
            l -= m;
            class_1799 itemStack = stack.method_7972();
            itemStack.method_7939(m);
            boolean added = player.method_31548().method_7394(itemStack);
            if (!added || !itemStack.method_7960()) {
                itemEntity = player.method_7328(itemStack, false);
                if (itemEntity == null) continue;
                itemEntity.method_6975();
                itemEntity.method_48349(player.method_5667());
                continue;
            }
            itemStack.method_7939(1);
            itemEntity = player.method_7328(itemStack, false);
            if (itemEntity != null) {
                itemEntity.method_6987();
            }
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_6051().method_43057() - player.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            player.field_7512.method_7623();
        }
    }

    public static <T, R> List<R> map(List<T> list, Function<T, R> mappingFunction) {
        ArrayList<R> out = new ArrayList<R>();
        for (T t : list) {
            out.add(mappingFunction.apply(t));
        }
        return out;
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<T> predicate) {
        ArrayList<T> out = new ArrayList<T>();
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            out.add(t);
        }
        return out;
    }

    public static <T> T biggestMatching(Collection<T> collection, Predicate<T> predicate, Comparator<T> comparator) {
        Object largest = null;
        for (T t : collection) {
            if (!predicate.test(t) || largest != null && comparator.compare(t, largest) <= 0) continue;
            largest = t;
        }
        return largest;
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<T> predicate) {
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static class_1799 getSpawnEggOfEntity(class_2960 entity) {
        class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entity);
        for (class_1792 registryItem : class_7923.field_41178) {
            class_1826 egg;
            if (!(registryItem instanceof class_1826) || !(egg = (class_1826)registryItem).method_8018(null, entityType)) continue;
            return egg.method_7854();
        }
        return DEFAULT_SPAWN_EGG;
    }

    public static String getEntityOfSpawnEggForTooltip(class_1799 item) {
        String entityName = "";
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof class_1826) {
            class_1826 egg = (class_1826)class_17922;
            class_1299 entityType = egg.method_8015(null);
            entityName = entityType.method_5897().getString();
        }
        return entityName;
    }

    public static String getFluidFromBucketForTooltip(class_1799 item) {
        String itemName = class_7923.field_41178.method_10221((Object)item.method_7909()).toString();
        String liquidName = itemName.replace("_bucket", "");
        return Utils.getFluidName(new class_2960(liquidName));
    }

    public static String getFluidName(class_2960 input) {
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(input);
        return Utils.getTranslationKey(fluid);
    }

    @Environment(value=EnvType.CLIENT)
    public static String getTranslationKey(class_3611 fluid) {
        class_2960 id;
        String key;
        String translated;
        String translationKey = fluid == class_3612.field_15906 ? "" : (fluid == class_3612.field_15910 ? "block.minecraft.water" : (fluid == class_3612.field_15908 ? "block.minecraft.lava" : ((translated = class_1074.method_4662((String)(key = class_156.method_646((String)"block", (class_2960)(id = class_7923.field_41173.method_10221((Object)fluid)))), (Object[])new Object[0])).equals(key) ? class_156.method_646((String)"fluid", (class_2960)id) : key)));
        return translationKey;
    }

    public static double log(int base, int value) {
        return Math.log(value) / Math.log(base);
    }

    public static boolean removeItems(class_1661 inventory, class_1792 item, int amount) {
        if (inventory.method_18861(item) < amount) {
            return false;
        }
        for (class_1799 stack : inventory.field_7547) {
            if (!stack.method_7909().equals(item)) continue;
            int count = stack.method_7947();
            if (count >= amount) {
                stack.method_7939(count - amount);
                break;
            }
            stack.method_7939(0);
            amount -= count;
        }
        return true;
    }

    public static String removeBrackets(String text) {
        return text.replaceAll("[\\[\\]]", "");
    }

    public static String adjustStringToWidth(String input, int maxWidth) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        if (fontRenderer.method_1727(input) <= maxWidth) {
            return input;
        }
        StringBuilder truncatedString = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            String currentCharAsString = String.valueOf(currentChar);
            if (fontRenderer.method_1727(String.valueOf(truncatedString) + currentCharAsString + "...") > maxWidth) break;
            truncatedString.append(currentCharAsString);
        }
        return truncatedString.append("...").toString();
    }

    public static class_2561 getMissionMessage(ClientMissionData.ClientsideActiveMission mission, class_124 color, Object ... args) {
        String[] parts;
        String key = "missions.menu.main.tooltip.task." + mission.missionType();
        String translation = class_1074.method_4662((String)key, (Object[])new Object[0]).replace("Format error: ", "");
        if (translation.equals(key) && Utils.isAddonMission(mission)) {
            translation = mission.missionString().getString();
        }
        if ((parts = translation.split("%s", -1)).length == 0) {
            return class_2561.method_43471((String)key);
        }
        class_5250 result = class_2561.method_43470((String)"");
        for (int i = 0; i < parts.length; ++i) {
            if (i < args.length) {
                result.method_10852((class_2561)class_2561.method_43471((String)parts[i]).method_10862(class_2583.field_24360.method_10977(color)));
                result.method_10852((class_2561)class_2561.method_43471((String)args[i].toString()).method_10862(class_2583.field_24360.method_27706(class_124.field_1078)));
                continue;
            }
            result.method_10852((class_2561)class_2561.method_43471((String)parts[i]).method_10862(class_2583.field_24360.method_10977(color)));
        }
        return result;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isAddonMission(ClientMissionData.ClientsideActiveMission mission) {
        for (MissionType type : MissionTypeRegistry.INSTANCE.getAllTypes()) {
            if (!type.id().equals(mission.missionType())) continue;
            return false;
        }
        return true;
    }

    public static void executeCommandAsServer(String command) {
        MinecraftServer minecraftServer = MinecraftServerSupplier.getServer();
        class_2168 commandSource = minecraftServer.method_3739();
        class_2170 commandManager = minecraftServer.method_3734();
        ParseResults parseResults = commandManager.method_9235().parse(command, (Object)commandSource.method_9217());
        MinecraftServerSupplier.getServer().method_3734().method_9249(parseResults, command);
    }

    public static int getTotalMissions() {
        return Utils.getClientStat(ModStats.EASY_MISSIONS_COMPLETED) + Utils.getClientStat(ModStats.NORMAL_MISSIONS_COMPLETED) + Utils.getClientStat(ModStats.HARD_MISSIONS_COMPLETED);
    }

    public static int getClientStat(class_2960 stat) {
        return class_310.method_1551().field_1724.method_3143().method_15025(class_3468.field_15419.method_14956((Object)stat));
    }

    public static <T> T getRandomEntry(Collection<T> collection) {
        int num = (int)(Math.random() * (double)collection.size());
        for (T t : collection) {
            if (--num >= 0) continue;
            return t;
        }
        throw new AssertionError();
    }

    public static <T> T getRandomEntry(List<T> collection) {
        return collection.get(RANDOM.nextInt(0, collection.size()));
    }

    public static <T> T getRandomEntry(Map<?, T> map) {
        return Utils.getRandomEntry(map.values());
    }
}

