/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.missions.mission_types.create.train;

import com.kryeit.JSONObject;
import com.kryeit.Missions;
import com.kryeit.missions.MissionDifficulty;
import com.kryeit.missions.MissionManager;
import com.kryeit.missions.MissionType;
import com.simibubi.create.AllBlocks;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class TrainDriverPassengerMission
implements MissionType {
    private static final class_2960 IDENTIFIER = Missions.asResource("distance");
    private static final class_2960 PASSENGERS = Missions.asResource("passengers");

    public static void handleDistanceChange(UUID player, int difference) {
        MissionManager.incrementMission(player, TrainDriverPassengerMission.class, IDENTIFIER, difference);
    }

    public static int passengersNeeded() {
        int passengers = 1;
        try {
            File file = Path.of("missions", new String[0]).toFile();
            if (!file.exists()) {
                return passengers;
            }
            String jsonContent = new String(Files.readAllBytes(Paths.get("missions/missions.json", new String[0])));
            JSONObject object = new JSONObject(jsonContent);
            JSONObject thing = object.getObject("train-driver-passenger");
            if (thing != null) {
                passengers = Integer.parseInt(thing.getObject("requirements").getString(PASSENGERS.toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Math.max(passengers, 1);
    }

    @Override
    public String id() {
        return "train-driver-passenger";
    }

    @Override
    public boolean assignOnlyOnce() {
        return true;
    }

    @Override
    public MissionDifficulty difficulty() {
        return MissionDifficulty.HARD;
    }

    @Override
    public class_2561 description() {
        return class_2561.method_30163((String)"Train passenger mission");
    }

    @Override
    public int getProgress(UUID player, class_2960 item) {
        return this.getData(player).method_10550("value");
    }

    @Override
    public void reset(UUID player, class_2960 item) {
        this.getData(player).method_10551("value");
    }

    @Override
    public void increment(int amount, class_2960 item, class_2487 data) {
        data.method_10569("value", data.method_10550("value") + amount);
    }

    @Override
    public class_1799 getItemStack(class_2960 item) {
        return class_1802.field_8162.method_7854();
    }

    @Override
    public class_1799 getPreviewStack(class_2960 item) {
        return AllBlocks.TRACK_STATION.asStack();
    }
}

