/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.missions.mission_types;

import com.kryeit.missions.MissionDifficulty;
import com.kryeit.missions.MissionManager;
import com.kryeit.missions.MissionType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class StatisticMission {
    private static final class_2960 IDENTIFIER = new class_2960("missions", "statistic");
    private static final Map<class_2960, StatisticMissionType> missions = new HashMap<class_2960, StatisticMissionType>();

    public static void handleStatisticChange(UUID player, int difference, class_2960 statistic) {
        StatisticMissionType type = missions.get(statistic);
        if (type == null || difference == 0) {
            return;
        }
        MissionManager.incrementMission(player, type, IDENTIFIER, difference);
    }

    public static MissionType createStatisticMission(String id, MissionDifficulty difficulty, class_2561 description, float divisor, class_1792 item, class_2960 ... statistics) {
        StatisticMissionType type = new StatisticMissionType(id, difficulty, description, divisor, item);
        for (class_2960 statistic : statistics) {
            missions.put(statistic, type);
        }
        return type;
    }

    private record StatisticMissionType(String id, MissionDifficulty difficulty, class_2561 description, float divisor, class_1792 item) implements MissionType
    {
        @Override
        public boolean assignOnlyOnce() {
            return false;
        }

        @Override
        public int getProgress(UUID player, class_2960 item) {
            return (int)((float)this.getData(player).method_10550("value") / this.divisor);
        }

        @Override
        public void reset(UUID player, class_2960 item) {
            this.getData(player).method_10551("value");
        }

        @Override
        public void increment(int amount, class_2960 item, class_2487 data) {
            data.method_10569("value", data.method_10550("value") + amount);
        }

        @Override
        public class_1799 getItemStack(class_2960 item) {
            return class_1802.field_8162.method_7854();
        }

        @Override
        public class_1799 getPreviewStack(class_2960 item) {
            return this.item().method_7854();
        }
    }
}

