/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.missions.config;

import com.kryeit.JSONObject;
import com.kryeit.compat.CompatAddon;
import com.kryeit.missions.MissionType;
import com.kryeit.missions.MissionTypeRegistry;
import com.kryeit.missions.config.Range;
import com.kryeit.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class ConfigReader {
    private final Map<MissionType, MissionTypeConfig> missions;
    private final List<class_1799> exchange;
    public final float exchangerDropRate;
    public final int firstRerollCurrency;
    public final int freeRerolls;
    public final String commandUponMission;
    public final ReassignInterval reassignInterval;

    private ConfigReader(Map<MissionType, MissionTypeConfig> missions, List<class_1799> exchange, float exchangerDropRate, int firstRerollCurrency, int freeRerolls, String commandUponMission, ReassignInterval reassignInterval) {
        this.missions = missions;
        this.exchange = exchange;
        this.exchangerDropRate = exchangerDropRate;
        this.firstRerollCurrency = firstRerollCurrency;
        this.freeRerolls = freeRerolls;
        this.commandUponMission = commandUponMission;
        this.reassignInterval = reassignInterval;
    }

    public static ConfigReader readFile(Path path) throws IOException {
        String content = ConfigReader.readOrCopyFile(path.resolve("missions.json"), "/missions.json");
        JSONObject object = new JSONObject(content);
        int configVersion = object.optInt("config-version").orElse(1);
        HashMap<MissionType, MissionTypeConfig> missionConfig = new HashMap<MissionType, MissionTypeConfig>();
        switch (configVersion) {
            case 1: {
                ConfigReader.parseConfigVersion1(object, missionConfig);
                break;
            }
            case 2: {
                ConfigReader.parseConfigVersion2(object, missionConfig);
            }
        }
        String exchange = CompatAddon.NUMISMATICS.isLoaded() ? ConfigReader.readOrCopyFile(path.resolve("currency.json"), "/numismatics/currency.json") : ConfigReader.readOrCopyFile(path.resolve("currency.json"), "/currency.json");
        JSONObject.JSONArray jsonArray = new JSONObject.JSONArray(exchange);
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject itemObj = jsonArray.getObject(i);
            itemObj.keySet().forEach(key -> {
                int quantity = Integer.parseInt(itemObj.getString((String)key));
                class_2960 location = new class_2960(key);
                class_1799 itemStack = Utils.getItem(location, quantity);
                items.add(itemStack);
            });
        }
        String config = ConfigReader.readOrCopyFile(path.resolve("config.json"), "/config.json");
        JSONObject configObject = new JSONObject(config);
        float exchangerDropRate = Float.parseFloat(configObject.getString("exchanger-drop-rate"));
        int firstRerollCurrency = Integer.parseInt(configObject.getString("first-reroll-currency"));
        int freeRerolls = Integer.parseInt(configObject.getString("free-rerolls"));
        String commandUponMission = configObject.getString("command-upon-mission");
        String reassignmentInterval = configObject.optString("reassignment-interval (DAILY or WEEKLY)").orElse("WEEKLY");
        return new ConfigReader(missionConfig, items, exchangerDropRate, firstRerollCurrency, freeRerolls, commandUponMission, ReassignInterval.valueOf(reassignmentInterval));
    }

    private static void parseConfigVersion2(JSONObject config, Map<MissionType, MissionTypeConfig> missions) {
        for (String key : config.keySet()) {
            JSONObject value;
            float weight;
            if (key.equals("config-version") || (weight = (value = config.getObject(key)).optFloat("weight").orElse(Float.valueOf(1.0f)).floatValue()) == 0.0f) continue;
            MissionType missionType = MissionTypeRegistry.INSTANCE.getType(key);
            HashMap<Map<String, Range>, SubMissionConfig> subMissions = new HashMap<Map<String, Range>, SubMissionConfig>();
            List<SubMissionConfig> subMissionConfigList = value.getArray("missions").asList((array, i) -> {
                JSONObject entry = array.getObject((int)i);
                return new SubMissionConfig(entry.getArray("titles").asList(JSONObject.JSONArray::getString), ConfigReader.getItems(entry.getObject("items")), ConfigReader.getRewards(entry.getArray("rewards")));
            });
            for (SubMissionConfig subMissionConfig : subMissionConfigList) {
                subMissions.put(subMissionConfig.items(), subMissionConfig);
            }
            MissionTypeConfig missionTypeConfig = new MissionTypeConfig(missionType, weight, subMissions);
            missions.put(missionType, missionTypeConfig);
        }
    }

    private static void parseConfigVersion1(JSONObject config, Map<MissionType, MissionTypeConfig> missions) {
        for (String key : config.keySet()) {
            JSONObject value = config.getObject(key);
            JSONObject reward = value.getObject("reward");
            float weight = value.optFloat("weight").orElse(Float.valueOf(1.0f)).floatValue();
            if (weight == 0.0f) continue;
            MissionType missionType = MissionTypeRegistry.INSTANCE.getType(key);
            Map<String, Range> items = ConfigReader.getItems(value.getObject("missions"));
            MissionTypeConfig mtc = new MissionTypeConfig(missionType, weight, Map.of(items, new SubMissionConfig(value.getArray("titles").asList(JSONObject.JSONArray::getString), items, List.of(new Reward(reward.getString("item"), Range.fromString(reward.getString("amount")))))));
            missions.put(missionType, mtc);
        }
    }

    private static List<Reward> getRewards(JSONObject.JSONArray rewards) {
        return rewards.asList((array, i) -> {
            JSONObject entry = rewards.getObject((int)i);
            return new Reward(entry.getString("item"), Range.fromString(entry.getString("amount")));
        });
    }

    public static String readOrCopyFile(Path path, String exampleFile) throws IOException {
        File file = path.toFile();
        if (!file.exists()) {
            InputStream stream = ConfigReader.class.getResourceAsStream(exampleFile);
            if (stream == null) {
                throw new NullPointerException("Cannot load example file");
            }
            file.getParentFile().mkdirs();
            Files.copy(stream, path, new CopyOption[0]);
        }
        return Files.readString(path);
    }

    private static Map<String, Range> getItems(JSONObject items) {
        HashMap<String, Range> itemsMap = new HashMap<String, Range>();
        for (String itemKey : items.keySet()) {
            itemsMap.put(itemKey, Range.fromString(items.getString(itemKey)));
        }
        return itemsMap;
    }

    public Map<MissionType, MissionTypeConfig> getMissions() {
        return this.missions;
    }

    public List<class_1799> exchange() {
        return this.exchange;
    }

    public static enum ReassignInterval {
        DAILY,
        WEEKLY;

    }

    public record SubMissionConfig(List<String> titles, Map<String, Range> items, List<Reward> rewards) {
    }

    public record MissionTypeConfig(MissionType missionType, float weight, Map<Map<String, Range>, SubMissionConfig> subMissions) {
    }

    public record Reward(String item, Range count) {
    }
}

