/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.missions;

import com.kryeit.missions.MissionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MissionTypeRegistry {
    public static final MissionTypeRegistry INSTANCE = new MissionTypeRegistry();
    private final Map<String, MissionType> typesById = new HashMap<String, MissionType>();
    private final Map<Class<? extends MissionType>, MissionType> typesByClass = new HashMap<Class<? extends MissionType>, MissionType>();

    public void register(MissionType type) {
        this.typesById.put(type.id(), type);
        this.typesByClass.put(type.getClass(), type);
    }

    public MissionType getType(String id) {
        return this.typesById.get(id);
    }

    public <T extends MissionType> T getType(Class<T> clazz) {
        return (T)this.typesByClass.get(clazz);
    }

    public List<MissionType> getAllTypes() {
        return List.copyOf(this.typesById.values());
    }
}

