/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.missions;

import com.kryeit.MinecraftServerSupplier;
import com.kryeit.Missions;
import com.kryeit.client.ClientMissionData;
import com.kryeit.client.ClientsideMissionPacketUtils;
import com.kryeit.coins.Coins;
import com.kryeit.compat.CompatAddon;
import com.kryeit.missions.DataStorage;
import com.kryeit.missions.MissionDifficulty;
import com.kryeit.missions.MissionType;
import com.kryeit.missions.MissionTypeRegistry;
import com.kryeit.registry.ModBlocks;
import com.kryeit.registry.ModStats;
import com.kryeit.utils.Utils;
import com.simibubi.create.foundation.utility.Components;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.PermissionNode;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class MissionManager {
    private static final DataStorage STORAGE = new DataStorage();

    public static DataStorage getStorage() {
        return STORAGE;
    }

    public static int checkReward(MissionType type, UUID player, class_2960 item) {
        DataStorage.ActiveMission activeMission = MissionManager.getActiveMission(type.id(), item, player);
        if (activeMission == null) {
            return 0;
        }
        int itemsLeft = activeMission.requiredAmount() - type.getProgress(player, activeMission.item());
        if (itemsLeft <= 0) {
            type.reset(player, item);
            STORAGE.addReward(player, activeMission.rewardItem(), activeMission.rewardAmount());
            STORAGE.setCompleted(player, item, type.id());
            MissionManager.onMissionComplete(player, activeMission, type);
        }
        return itemsLeft;
    }

    public static void incrementMission(UUID player, String missionID, class_2960 key, int amount) {
        MissionType type = MissionTypeRegistry.INSTANCE.getType(missionID);
        MissionManager.incrementMission(player, type, key, amount);
    }

    public static void incrementMission(UUID player, Class<? extends MissionType> clazz, class_2960 key, int amount) {
        MissionType type = MissionTypeRegistry.INSTANCE.getType(clazz);
        MissionManager.incrementMission(player, type, key, amount);
    }

    public static void incrementMission(UUID player, MissionType type, class_2960 key, int amount) {
        if (MissionManager.countItem(type.id(), player, key)) {
            class_2487 data = type.getData(player);
            type.increment(amount, key, data);
            int itemsLeft = MissionManager.checkReward(type, player, key);
            if (itemsLeft < 0) {
                MissionManager.incrementMission(player, type, key, -itemsLeft);
            }
        }
    }

    public static void giveReward(class_3222 player) {
        UUID uuid = player.method_5667();
        Map<String, Integer> rewards = STORAGE.getUnclaimedRewards(uuid);
        for (Map.Entry<String, Integer> entry : rewards.entrySet()) {
            class_1799 itemStack = Utils.getItem(new class_2960(entry.getKey()));
            itemStack.method_7939(entry.getValue().intValue());
            MinecraftServerSupplier.getServer().execute(() -> Utils.giveItem(itemStack, player));
            player.method_43496((class_2561)Components.translatable((String)"missions.menu.main.reward", (Object[])new Object[]{itemStack.method_7947(), Utils.removeBrackets(itemStack.method_7954().getString())}).method_27692(class_124.field_1060));
        }
        STORAGE.claimRewards(uuid);
        if (!rewards.isEmpty()) {
            player.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)class_3417.field_14709), class_3419.field_15250, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, 1.0f, 1.0f, 1L));
        }
    }

    public static boolean reassignMissionsIfNecessary(UUID player) {
        boolean reassign;
        int lastAssignedDay = STORAGE.getLastAssignedDay(player);
        switch (Missions.getConfig().reassignInterval) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DAILY: {
                boolean bl;
                if (lastAssignedDay != Utils.getDay()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WEEKLY: {
                boolean bl = reassign = lastAssignedDay < Utils.getDay() - Utils.getDayOfWeek();
            }
        }
        if (reassign) {
            MissionManager.reassignMissions(player);
        }
        return reassign;
    }

    public static void reassignMissions(UUID player) {
        for (DataStorage.ActiveMission mission : MissionManager.getActiveMissions(player)) {
            MissionTypeRegistry.INSTANCE.getType(mission.missionID()).reset(player, mission.item());
        }
        STORAGE.reassignActiveMissions(Missions.getConfig().getMissions(), player);
        STORAGE.setLastAssignedDay(player);
        STORAGE.resetReassignments(player);
    }

    public static ReassignmentPrice calculatePrice(UUID player) {
        int rerolls;
        int freeRerolls = MissionManager.getTotalFreeRerolls(player);
        if (freeRerolls > (rerolls = STORAGE.getReassignmentsSinceLastReset(player))) {
            return new ReassignmentPrice(Coins.getCoin(0).method_7909(), 1);
        }
        int price = 2 << rerolls - freeRerolls;
        int coinIndex = (int)Utils.log(64, price - 1);
        int coinAmount = (int)((double)price / Math.pow(64.0, coinIndex));
        return new ReassignmentPrice(Coins.getCoin(coinIndex + Missions.getConfig().firstRerollCurrency).method_7909(), coinAmount);
    }

    public static void tryReassignMission(class_3222 serverPlayer, int index) {
        UUID player = serverPlayer.method_5667();
        DataStorage.ActiveMission activeMission = MissionManager.getActiveMissions(player).get(index);
        if (activeMission.isCompleted()) {
            return;
        }
        ReassignmentPrice price = MissionManager.calculatePrice(player);
        if (price.amount == 1 || Utils.removeItems(serverPlayer.method_31548(), price.item, price.amount)) {
            STORAGE.reassignActiveMission(Missions.getConfig().getMissions(), player, index);
            if (!Utils.contains(MissionManager.getActiveMissions(player), m -> m.missionID().equals(activeMission.missionID()) && m.item().equals((Object)activeMission.item()))) {
                MissionTypeRegistry.INSTANCE.getType(activeMission.missionID()).reset(player, activeMission.item());
            }
            STORAGE.incrementReassignmentsSinceLastReset(player);
            serverPlayer.method_7281(ModStats.MISSIONS_REROLLED);
        }
    }

    public static List<DataStorage.ActiveMission> getActiveMissions(UUID playerId) {
        return STORAGE.getActiveMissions(playerId);
    }

    public static boolean countItem(String missionTypeID, UUID player, class_2960 item) {
        DataStorage.ActiveMission activeMission = MissionManager.getActiveMission(missionTypeID, item, player);
        return activeMission != null;
    }

    public static DataStorage.ActiveMission getActiveMission(String id, class_2960 item, UUID player) {
        List<DataStorage.ActiveMission> missions = STORAGE.getActiveMissions(player);
        for (DataStorage.ActiveMission mission : missions) {
            if (!mission.missionID().equals(id) || !mission.item().equals((Object)item) || mission.isCompleted()) continue;
            return mission;
        }
        return null;
    }

    public static void onMissionComplete(UUID player, DataStorage.ActiveMission mission, MissionType type) {
        class_3324 playerList = MinecraftServerSupplier.getServer().method_3760();
        class_3222 serverPlayer = playerList.method_14602(player);
        MissionDifficulty difficulty = MissionTypeRegistry.INSTANCE.getType(mission.missionID()).difficulty();
        if (serverPlayer == null) {
            return;
        }
        serverPlayer.method_7281(difficulty.stat());
        Utils.executeCommandAsServer(Missions.getConfig().commandUponMission.replace("%player%", serverPlayer.method_5477().getString()));
        MissionManager.showToast(serverPlayer, mission.toClientMission(player));
        if (type.difficulty() == MissionDifficulty.HARD) {
            class_5250 message = Components.translatable((String)"missions.message.hard_mission_completed", (Object[])new Object[]{serverPlayer.method_5477()}).method_27692(class_124.field_1065);
            playerList.method_43514((class_2561)message, false);
            if (Math.random() <= (double)Missions.getConfig().exchangerDropRate) {
                MinecraftServerSupplier.getServer().execute(() -> Utils.giveItem(ModBlocks.MECHANICAL_EXCHANGER.asStack(), serverPlayer));
            }
        }
    }

    private static void showToast(class_3222 player, ClientMissionData.ClientsideActiveMission mission) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        mission.toBuffer(buffer);
        class_2658 packet = new class_2658(ClientsideMissionPacketUtils.SHOW_TOAST, buffer);
        player.field_13987.method_14364((class_2596)packet);
    }

    public static void sendMissions(class_3222 player) {
        UUID playerUUID = player.method_5667();
        boolean hasUnclaimedRewards = !STORAGE.getUnclaimedRewards(playerUUID).isEmpty();
        List<ClientMissionData.ClientsideActiveMission> clientMissions = Utils.map(MissionManager.getActiveMissions(playerUUID), mission -> mission.toClientMission(playerUUID));
        ReassignmentPrice price = MissionManager.calculatePrice(playerUUID);
        boolean canReroll = player.method_31548().method_18861(price.item()) >= price.amount();
        int rerolls = STORAGE.getReassignmentsSinceLastReset(playerUUID);
        int freeRerollsLeft = Math.max(0, MissionManager.getTotalFreeRerolls(playerUUID) - rerolls);
        ClientMissionData data = new ClientMissionData(hasUnclaimedRewards, clientMissions, price.asStack(), freeRerollsLeft, freeRerollsLeft > 0 || canReroll);
        class_2658 packet = new class_2658(ClientsideMissionPacketUtils.IDENTIFIER, ClientsideMissionPacketUtils.serialize(data));
        player.field_13987.method_14364((class_2596)packet);
    }

    private static int getTotalFreeRerolls(UUID player) {
        int defaultValue = Missions.getConfig().freeRerolls;
        if (!CompatAddon.LUCKPERMS.isLoaded()) {
            return defaultValue;
        }
        LuckPerms luckPerms = LuckPermsProvider.get();
        User user = luckPerms.getUserManager().getUser(player);
        if (user == null) {
            return defaultValue;
        }
        QueryOptions queryOptions = luckPerms.getContextManager().getQueryOptions(user).orElse(null);
        if (queryOptions == null) {
            return defaultValue;
        }
        String contextKey = "amount";
        for (PermissionNode node : user.resolveInheritedNodes(NodeType.PERMISSION, queryOptions)) {
            Integer amount;
            if (!node.getKey().equals("missions.freerolls") || (amount = (Integer)node.getContexts().getAnyValue(contextKey).map(Integer::valueOf).orElse(null)) == null) continue;
            return amount;
        }
        return defaultValue;
    }

    public record ReassignmentPrice(class_1792 item, int amount) {
        public class_1799 asStack() {
            class_1799 stack = this.item.method_7854();
            stack.method_7939(this.amount);
            return stack;
        }
    }
}

