/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.content.exchanger.fabric;

import com.kryeit.content.exchanger.MechanicalExchangerBlockEntity;
import com.kryeit.content.exchanger.fabric.MechanicalExchangerContainerSlotView;
import io.github.fabricators_of_create.porting_lib.transfer.StorageViewArrayIterator;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class MechanicalExchangerContainerInterface
extends SnapshotParticipant<ContainerSnapshot>
implements Storage<ItemVariant> {
    private final MechanicalExchangerBlockEntity be;
    private final MechanicalExchangerContainerSlotView[] views;

    public MechanicalExchangerContainerInterface(MechanicalExchangerBlockEntity be) {
        this.be = be;
        this.views = new MechanicalExchangerContainerSlotView[2];
        this.views[0] = new MechanicalExchangerContainerSlotView(this, 1);
        this.views[1] = new MechanicalExchangerContainerSlotView(this, 0);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int add;
        long total = 0L;
        this.updateSnapshots(transaction);
        int maxInsert = this.be.method_5438(0).method_7914() - this.be.method_5438(0).method_7947();
        if (maxInsert > 0 && (add = Math.min((int)maxAmount, maxInsert)) > 0 && this.be.canInsertItemIntoSlot(0, resource.toStack())) {
            this.be.method_5447(0, ItemHandlerHelper.copyStackWithSize((class_1799)resource.toStack(), (int)(this.be.method_5438(0).method_7947() + add)));
            total += (long)add;
        }
        return total;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int remove;
        this.updateSnapshots(transaction);
        int maxExtract = this.be.method_5438(1).method_7947();
        if (maxExtract > 0 && (remove = Math.min((int)maxAmount, maxExtract)) > 0) {
            this.be.method_5438(1).method_7971(remove);
            return remove;
        }
        return 0L;
    }

    @Nonnull
    public class_1799 getStack(int slot) {
        return this.be.method_5438(slot);
    }

    protected void onFinalCommit() {
        super.onFinalCommit();
        this.be.notifyUpdate();
    }

    public int getCapacityForSlot(int slot) {
        return this.be.method_5438(slot).method_7914() - this.be.method_5438(slot).method_7947();
    }

    public void restoreViewSnapshot(int slot, class_1799 snapshot) {
        this.be.method_5447(slot, snapshot);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return new StorageViewArrayIterator((StorageView[])this.views);
    }

    protected ContainerSnapshot createSnapshot() {
        return new ContainerSnapshot(this);
    }

    protected void readSnapshot(ContainerSnapshot snapshot) {
        snapshot.apply(this);
    }

    public static class ContainerSnapshot {
        private final class_2371<class_1799> inventory;

        public ContainerSnapshot(MechanicalExchangerContainerInterface inventory) {
            this.inventory = inventory.be.inventory.stream().map(class_1799::method_7972).collect(Collectors.toCollection(class_2371::method_10211));
        }

        public void apply(MechanicalExchangerContainerInterface inventory) {
            inventory.be.inventory = this.inventory;
        }
    }
}

