/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.content.exchanger;

import com.kryeit.coins.Coins;
import com.kryeit.content.exchanger.MechanicalExchangerBlock;
import com.kryeit.content.exchanger.MechanicalExchangerMenu;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class MechanicalExchangerBlockEntity
extends KineticBlockEntity
implements class_3908,
class_1278 {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public class_2371<class_1799> inventory;
    public final class_3913 data;
    private int progress = 0;
    private int maxProgress = 64;
    Mode mode = Mode.OFF;

    public MechanicalExchangerBlockEntity(class_2591<?> blockEntityType, class_2338 worldPosition, class_2680 blockState) {
        super(blockEntityType, worldPosition, blockState);
        this.inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> MechanicalExchangerBlockEntity.this.progress;
                    case 1 -> MechanicalExchangerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        MechanicalExchangerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        MechanicalExchangerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public int[] method_5494(class_2350 direction) {
        return new int[]{0, 1};
    }

    public boolean method_5492(int i, class_1799 itemStack, class_2350 direction) {
        return i == 0;
    }

    public boolean method_5493(int i, class_1799 itemStack, class_2350 direction) {
        return i == 1;
    }

    public int method_5439() {
        return 2;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int i) {
        return (class_1799)this.inventory.get(i);
    }

    public class_1799 method_5434(int i, int j) {
        class_1799 itemStack = class_1262.method_5430(this.inventory, (int)i, (int)j);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 method_5441(int i) {
        class_1799 itemStack = (class_1799)this.inventory.get(i);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.inventory.set(i, (Object)class_1799.field_8037);
        return itemStack;
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (!itemStack.method_7960() && itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
    }

    @Nonnull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.missions.mechanical_exchanger");
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return MechanicalExchangerMenu.create(i, inventory, this, this.data);
    }

    public void invalidate() {
        super.invalidate();
    }

    public void write(class_2487 tag, boolean clientPacket) {
        class_1262.method_5426((class_2487)tag, this.inventory);
        if (!clientPacket) {
            tag.method_10569("mechanical_exchanger.progress", this.progress);
        }
        super.write(tag, clientPacket);
    }

    public void read(class_2487 tag, boolean clientPacket) {
        class_1262.method_5429((class_2487)tag, this.inventory);
        if (!clientPacket) {
            this.progress = tag.method_10550("mechanical_exchanger.progress");
        }
        super.read(tag, clientPacket);
    }

    public void drops() {
        assert (this.field_11863 != null);
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1263)this);
    }

    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        this.updateMode();
        if (this.hasRecipe()) {
            ++this.progress;
            this.method_5431();
            if (this.progress > this.maxProgress) {
                this.craftItem();
            }
        } else {
            this.resetProgress();
            this.method_5431();
        }
    }

    private boolean hasRecipe() {
        if (this.method_5438(0).method_7960() || !Coins.isCoin(this.method_5438(0))) {
            return false;
        }
        if (this.mode == Mode.TO_BIGGER) {
            if (Coins.indexOf(this.method_5438(0)) == Coins.getCoins().size() - 1) {
                return false;
            }
            class_1799 result = Coins.getExchange(this.method_5438(0), true);
            return result != null && this.canInsertAmountIntoSlot(1, 1) && this.canInsertItemIntoSlot(1, result) && this.method_5438(0).method_7947() >= Coins.getCoin(this.method_5438(0)).method_7947();
        }
        if (this.mode == Mode.TO_SMALLER) {
            if (Coins.indexOf(this.method_5438(0)) == 0) {
                return false;
            }
            class_1799 result = Coins.getExchange(this.method_5438(0), false);
            int requiredCount = Coins.getCoin(Coins.indexOf(this.method_5438(0)) - 1).method_7947();
            return result != null && this.canInsertAmountIntoSlot(1, requiredCount) && this.canInsertItemIntoSlot(1, result) && this.method_5438(0).method_7947() >= 1;
        }
        return false;
    }

    private void craftItem() {
        class_1799 result;
        if (this.mode == Mode.TO_BIGGER) {
            class_1799 result2 = Coins.getExchange(this.method_5438(0), true);
            if (result2 != null) {
                this.method_5434(0, Coins.getCoin(this.method_5438(0)).method_7947());
                this.method_5447(1, new class_1799((class_1935)result2.method_7909(), this.method_5438(1).method_7947() + 1));
                this.resetProgress();
            }
        } else if (this.mode == Mode.TO_SMALLER && (result = Coins.getExchange(this.method_5438(0), false)) != null) {
            int requiredCount = Coins.getCoin(Coins.indexOf(this.method_5438(0)) - 1).method_7947();
            this.method_5434(0, 1);
            this.method_5447(1, new class_1799((class_1935)result.method_7909(), this.method_5438(1).method_7947() + requiredCount));
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public boolean canInsertItemIntoSlot(int slot, class_1799 output) {
        return this.method_5438(slot).method_7909() == output.method_7909() || this.method_5438(slot).method_7960();
    }

    public boolean canInsertAmountIntoSlot(int slot, int amount) {
        return this.method_5438(slot).method_7914() > this.method_5438(slot).method_7947() + (amount - 1);
    }

    private void updateMode() {
        double speed = this.getSpeed();
        this.mode = speed >= 100.0 ? Mode.TO_BIGGER : (speed <= -100.0 ? Mode.TO_SMALLER : Mode.OFF);
        this.updateState();
    }

    public void updateState() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657(MechanicalExchangerBlock.MODE, (Comparable)((Object)this.mode)), 3);
        }
    }

    public static enum Mode implements class_3542
    {
        TO_SMALLER,
        TO_BIGGER,
        OFF;


        public String method_15434() {
            return this.name().toLowerCase();
        }
    }
}

