/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit.client;

import com.kryeit.Missions;
import com.kryeit.client.ClientMissionData;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ClientsideMissionPacketUtils {
    public static final class_2960 IDENTIFIER = Missions.asResource("active_missions");
    public static final class_2960 PAYOUT_IDENTIFIER = Missions.asResource("payout");
    public static final class_2960 REROLL_IDENTIFIER = Missions.asResource("reroll");
    public static final class_2960 REQUEST_MISSIONS = Missions.asResource("request_missions");
    public static final class_2960 SHOW_TOAST = Missions.asResource("show_toast");
    private static Consumer<ClientMissionData> updateHandler;

    public static void handlePacket(class_2540 buf) {
        boolean rewardsAvailable = buf.readBoolean();
        class_1799 rerollPrice = buf.method_10819();
        int freeRerollsLeft = buf.readInt();
        boolean canReroll = buf.readBoolean();
        List missions = buf.method_34066(ClientMissionData.ClientsideActiveMission::fromBuffer);
        updateHandler.accept(new ClientMissionData(rewardsAvailable, missions, rerollPrice, freeRerollsLeft, canReroll));
    }

    public static class_2540 serialize(ClientMissionData data) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(data.hasUnclaimedRewards());
        buf.method_10793(data.rerollPrice());
        buf.writeInt(data.freeRerollsLeft());
        buf.writeBoolean(data.canReroll());
        buf.method_34062(data.activeMissions(), (b, mission) -> mission.toBuffer((class_2540)b));
        return buf;
    }

    public static void requestPayout() {
        class_2817 packet = new class_2817(PAYOUT_IDENTIFIER, new class_2540(Unpooled.buffer((int)0)));
        ClientsideMissionPacketUtils.sendPacket(packet);
    }

    public static void requestReroll(int index) {
        class_2540 buf = new class_2540(Unpooled.buffer((int)4));
        buf.writeInt(index);
        class_2817 packet = new class_2817(REROLL_IDENTIFIER, buf);
        ClientsideMissionPacketUtils.sendPacket(packet);
    }

    public static void requestMissions() {
        class_2817 packet = new class_2817(REQUEST_MISSIONS, new class_2540(Unpooled.buffer((int)0)));
        ClientsideMissionPacketUtils.sendPacket(packet);
    }

    public static void setMissionUpdateHandler(Consumer<ClientMissionData> handler) {
        updateHandler = handler;
    }

    private static void sendPacket(class_2817 packet) {
        class_634 connection = class_310.method_1551().method_1562();
        Objects.requireNonNull(connection, "Connection may not be null").method_2883((class_2596)packet);
    }
}

