/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit;

import com.kryeit.fabric.MissionsImpl;
import com.kryeit.missions.MissionDifficulty;
import com.kryeit.missions.MissionManager;
import com.kryeit.missions.MissionType;
import com.kryeit.missions.MissionTypeRegistry;
import com.kryeit.missions.config.ConfigReader;
import com.kryeit.missions.mission_types.StatisticMission;
import com.kryeit.missions.mission_types.create.CrushMission;
import com.kryeit.missions.mission_types.create.CutMission;
import com.kryeit.missions.mission_types.create.MillMission;
import com.kryeit.missions.mission_types.create.PressMission;
import com.kryeit.missions.mission_types.create.basin.CompactMission;
import com.kryeit.missions.mission_types.create.basin.MixMission;
import com.kryeit.missions.mission_types.create.belt.BeltWalkMission;
import com.kryeit.missions.mission_types.create.contraption.DrillMission;
import com.kryeit.missions.mission_types.create.contraption.HarvestMission;
import com.kryeit.missions.mission_types.create.contraption.SawMission;
import com.kryeit.missions.mission_types.create.diving.DivingMission;
import com.kryeit.missions.mission_types.create.train.TrainDriverMission;
import com.kryeit.missions.mission_types.create.train.TrainDriverPassengerMission;
import com.kryeit.missions.mission_types.create.train.TrainPassengerMission;
import com.kryeit.missions.mission_types.create.train.TrainRelocateMission;
import com.kryeit.missions.mission_types.vanilla.BreakMission;
import com.kryeit.missions.mission_types.vanilla.CraftMission;
import com.kryeit.missions.mission_types.vanilla.EatMission;
import com.kryeit.missions.mission_types.vanilla.FeedMission;
import com.kryeit.missions.mission_types.vanilla.FishMission;
import com.kryeit.missions.mission_types.vanilla.KillMission;
import com.kryeit.missions.mission_types.vanilla.PlaceMission;
import com.kryeit.registry.ModBlockEntities;
import com.kryeit.registry.ModBlocks;
import com.kryeit.registry.ModCreativeTabs;
import com.kryeit.registry.ModEntityTypes;
import com.kryeit.registry.ModMenuTypes;
import com.kryeit.registry.ModSounds;
import com.kryeit.utils.Utils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Missions {
    public static final String MOD_ID = "missions";
    public static final String NAME = "Create: Missions";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Missions");
    private static ConfigReader configReader;
    public static HashMap<UUID, class_243> cachedTrainPlayerPositions;
    public static HashMap<UUID, class_243> cachedBeltPlayerPositions;
    public static CreateRegistrate REGISTRATE;

    public static void init() {
        Missions.registerMissions();
        ModBlocks.register();
        ModMenuTypes.register();
        ModBlockEntities.register();
        ModCreativeTabs.register();
        ModSounds.register();
        ModEntityTypes.register();
        ModCreativeTabs.useBaseTab();
        Missions.finalizeRegistrate();
    }

    public static class_2960 asResource(String key) {
        return new class_2960(MOD_ID, key);
    }

    public static void handlePlayerLogin(class_1657 player) {
        boolean reassigned = MissionManager.reassignMissionsIfNecessary(player.method_5667());
        if (reassigned) {
            class_5250 message = class_2561.method_43471((String)"missions.reassign").method_27692(class_124.field_1060);
            player.method_43496((class_2561)message);
        }
    }

    public static ConfigReader getConfig() {
        return configReader;
    }

    private static void registerMissions() {
        MissionTypeRegistry.INSTANCE.register(new BreakMission());
        MissionTypeRegistry.INSTANCE.register(new CraftMission());
        MissionTypeRegistry.INSTANCE.register(new CrushMission());
        MissionTypeRegistry.INSTANCE.register(new CutMission());
        MissionTypeRegistry.INSTANCE.register(new EatMission());
        MissionTypeRegistry.INSTANCE.register(new FishMission());
        MissionTypeRegistry.INSTANCE.register(new KillMission());
        MissionTypeRegistry.INSTANCE.register(new MillMission());
        MissionTypeRegistry.INSTANCE.register(new PlaceMission());
        MissionTypeRegistry.INSTANCE.register(new FeedMission());
        MissionTypeRegistry.INSTANCE.register(new PressMission());
        MissionTypeRegistry.INSTANCE.register(new BeltWalkMission());
        MissionTypeRegistry.INSTANCE.register(new CompactMission());
        MissionTypeRegistry.INSTANCE.register(new MixMission());
        MissionTypeRegistry.INSTANCE.register(new TrainDriverMission());
        MissionTypeRegistry.INSTANCE.register(new TrainPassengerMission());
        MissionTypeRegistry.INSTANCE.register(new TrainDriverPassengerMission());
        MissionTypeRegistry.INSTANCE.register(new TrainRelocateMission());
        MissionTypeRegistry.INSTANCE.register(new DivingMission());
        MissionTypeRegistry.INSTANCE.register(new DrillMission());
        MissionTypeRegistry.INSTANCE.register(new SawMission());
        MissionTypeRegistry.INSTANCE.register(new HarvestMission());
        List.of(StatisticMission.createStatisticMission("walk", MissionDifficulty.EASY, class_2561.method_30163((String)"Walking mission"), 100.0f, class_1802.field_8370, class_3468.field_15377, class_3468.field_15364, class_3468.field_15376), StatisticMission.createStatisticMission("swim", MissionDifficulty.HARD, class_2561.method_30163((String)"Swimming mission"), 100.0f, class_1802.field_8090, class_3468.field_15423), StatisticMission.createStatisticMission("minecart", MissionDifficulty.NORMAL, class_2561.method_30163((String)"Minecart mission"), 100.0f, class_1802.field_8045, class_3468.field_15409), StatisticMission.createStatisticMission("ride", MissionDifficulty.HARD, class_2561.method_30163((String)"Riding mission"), 100.0f, class_1802.field_8175, class_3468.field_15396, class_3468.field_15387, class_3468.field_24458), StatisticMission.createStatisticMission("fly", MissionDifficulty.EASY, class_2561.method_30163((String)"Flying mission"), 100.0f, class_1802.field_8833, class_3468.field_15374), StatisticMission.createStatisticMission("sail", MissionDifficulty.NORMAL, class_2561.method_30163((String)"Sailing mission"), 100.0f, class_1802.field_8533, class_3468.field_15415)).forEach(MissionTypeRegistry.INSTANCE::register);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void finalizeRegistrate() {
        MissionsImpl.finalizeRegistrate();
    }

    public static void readConfig() {
        block4: {
            try {
                LOGGER.info("Reading config file...");
                configReader = ConfigReader.readFile(Path.of("config/missions", new String[0]));
                ArrayList<MissionType> unusedTypes = new ArrayList<MissionType>(MissionTypeRegistry.INSTANCE.getAllTypes());
                unusedTypes.removeAll(configReader.getMissions().keySet());
                if (!unusedTypes.isEmpty()) {
                    LOGGER.warn("The following mission types are available but ignored due to having a weight of 0 or being absent in the config file: {}", Utils.map(unusedTypes, MissionType::id));
                }
                if (configReader.getMissions().size() >= 10) break block4;
                if (Utils.filter(configReader.getMissions().keySet(), MissionType::assignOnlyOnce).size() < configReader.getMissions().size()) {
                    LOGGER.warn("Mission types will be assigned more than once per player since less than 10 missions are active");
                    break block4;
                }
                throw new RuntimeException("10 missions can not be selected per player since less than 10 mission types that can be assigned at most once are enabled and no multiple assignable type is enabled.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        cachedTrainPlayerPositions = new HashMap();
        cachedBeltPlayerPositions = new HashMap();
        REGISTRATE = CreateRegistrate.create((String)MOD_ID);
    }
}

