/*
 * Decompiled with CFR 0.152.
 */
package com.kryeit;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

public class JSONObject {
    private final Map<String, Object> data;
    public static final Null NULL = new Null();

    public JSONObject(String input) {
        this.data = new Parser((char[])input.toCharArray()).parseJSONObject().data;
    }

    public JSONObject(Map<String, Object> data) {
        this.data = data;
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public boolean has(String key) {
        return this.data.containsKey(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.data.get(key);
    }

    public String getString(String key) {
        return (String)this.data.get(key);
    }

    public long getLong(String key) {
        return (Long)this.data.get(key);
    }

    public JSONArray getArray(String key) {
        return (JSONArray)this.data.get(key);
    }

    public JSONObject getObject(String key) {
        return (JSONObject)this.data.get(key);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.data.entrySet();
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public float getFloat(String key) {
        return ((Float)this.data.get(key)).floatValue();
    }

    public int getInt(String key) {
        return (Integer)this.data.get(key);
    }

    public Optional<Integer> optInt(String key) {
        Object value = this.data.get(key);
        if (value instanceof Number) {
            return Optional.of(((Number)value).intValue());
        }
        return Optional.empty();
    }

    public Optional<String> optString(String key) {
        Object value = this.data.get(key);
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public Optional<Float> optFloat(String key) {
        Object value = this.data.get(key);
        if (value instanceof Number) {
            return Optional.of(Float.valueOf(((Number)value).floatValue()));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.data.toString();
    }

    public static void main(String[] args) {
        JSONObject obj = new JSONObject("          { \"object\":   {\"a\"  :59}, \"a\": [42 ,  \"deine mudda\"],\n          \"key\": 42.69, \"key2\": null, \"key3\":  false, \"key4\":true}\n");
        System.out.println(obj);
    }

    private static class Parser {
        private final char[] data;
        private int pos = 0;

        private Parser(char[] data) {
            this.data = data;
        }

        private char currentChar() {
            return this.data[this.pos];
        }

        private void incrementPosition() {
            ++this.pos;
        }

        private void skipWhiteSpaces() {
            while (Character.isWhitespace(this.currentChar())) {
                this.incrementPosition();
            }
        }

        private String parseString() {
            if (this.currentChar() == '\'') {
                throw this.exception("JSON standard does not allow single quoted strings");
            }
            if (this.currentChar() != '\"') {
                throw this.exception("JSON standard allows only one top-level value");
            }
            StringBuilder string = new StringBuilder();
            boolean escapeNextChar = false;
            while (true) {
                this.incrementPosition();
                if (escapeNextChar) {
                    escapeNextChar = false;
                    if (this.currentChar() == '\\') {
                        string.append('\\');
                        continue;
                    }
                    if (this.currentChar() == '\"') {
                        string.append('\"');
                        continue;
                    }
                    throw this.exception("Invalid escape sequence \\" + this.currentChar());
                }
                if (this.currentChar() == '\"') {
                    return string.toString();
                }
                if (this.currentChar() == '\\') {
                    escapeNextChar = true;
                    continue;
                }
                string.append(this.currentChar());
            }
        }

        private Object parseValue() {
            if (this.currentChar() == '\"') {
                return this.parseString();
            }
            if (Character.isDigit(this.currentChar())) {
                return this.parseNumber();
            }
            if (this.currentChar() == 'f' || this.currentChar() == 't' || this.currentChar() == 'n') {
                return this.parseConstant();
            }
            if (this.currentChar() == '{') {
                return this.parseJSONObject();
            }
            if (this.currentChar() == '[') {
                return this.parseJSONArray();
            }
            throw this.exception("JSON standard does not allow such tokens");
        }

        private Object parseConstant() {
            String wordString;
            StringBuilder word = new StringBuilder();
            while (Character.isLetter(this.currentChar())) {
                word.append(this.currentChar());
                this.incrementPosition();
            }
            --this.pos;
            return switch (wordString = word.toString()) {
                case "true" -> true;
                case "false" -> false;
                case "null" -> NULL;
                default -> throw this.exception("JSON standard does not allow such tokens");
            };
        }

        private Number parseNumber() {
            StringBuilder number = new StringBuilder();
            while (this.currentChar() == '.' || Character.isDigit(this.currentChar())) {
                number.append(this.currentChar());
                this.incrementPosition();
            }
            --this.pos;
            if (number.toString().contains(".")) {
                return Double.parseDouble(number.toString());
            }
            return Long.parseLong(number.toString());
        }

        private Map<String, Object> parseKeyValue() {
            String key = this.parseString();
            this.incrementPosition();
            this.skipWhiteSpaces();
            if (this.currentChar() != ':') {
                throw this.exception("Expected ':', got '" + this.currentChar() + "'");
            }
            this.incrementPosition();
            this.skipWhiteSpaces();
            return Map.of(key, this.parseValue());
        }

        private JSONObject parseJSONObject() {
            this.incrementPosition();
            this.skipWhiteSpaces();
            HashMap<String, Object> out = new HashMap<String, Object>(this.parseKeyValue());
            this.incrementPosition();
            this.skipWhiteSpaces();
            while (this.currentChar() != '}') {
                if (this.currentChar() != ',') {
                    throw this.exception("',' or '}' expected");
                }
                this.incrementPosition();
                this.skipWhiteSpaces();
                out.putAll(this.parseKeyValue());
                this.incrementPosition();
                this.skipWhiteSpaces();
            }
            return new JSONObject(out);
        }

        private JSONArray parseJSONArray() {
            this.incrementPosition();
            this.skipWhiteSpaces();
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.parseValue());
            this.incrementPosition();
            this.skipWhiteSpaces();
            while (this.currentChar() != ']') {
                if (this.currentChar() != ',') {
                    throw this.exception("',' or ']' expected");
                }
                this.incrementPosition();
                this.skipWhiteSpaces();
                list.add(this.parseValue());
                this.incrementPosition();
                this.skipWhiteSpaces();
            }
            return new JSONArray(list);
        }

        private RuntimeException exception(String message) {
            return new RuntimeException(new ParseException(message, this.pos));
        }
    }

    public static class JSONArray
    implements Iterable<Object> {
        private final List<Object> data;

        public JSONArray(List<Object> data) {
            this.data = data;
        }

        public JSONArray(String input) {
            Parser parser = new Parser(input.toCharArray());
            this.data = parser.parseJSONArray().data;
        }

        public boolean getBoolean(int i) {
            return (Boolean)this.data.get(i);
        }

        public String getString(int i) {
            return (String)this.data.get(i);
        }

        public long getLong(int i) {
            return (Long)this.data.get(i);
        }

        public JSONArray getArray(int i) {
            return (JSONArray)this.data.get(i);
        }

        public JSONObject getObject(int i) {
            return (JSONObject)this.data.get(i);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.data.iterator();
        }

        public int size() {
            return this.data.size();
        }

        public <T> List<T> asList(BiFunction<JSONArray, Integer, T> mapper) {
            ArrayList<T> out = new ArrayList<T>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                out.add(mapper.apply(this, i));
            }
            return out;
        }
    }

    public static final class Null {
        public String toString() {
            return "null";
        }
    }
}

