/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.network;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.platform.ClientPlatform;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class C2SPlayCardPacket {
    public static final class_2960 ID = Mino.id("play_card");

    public static void handleC2S(MinecraftServer server, class_3222 player, class_2540 packet) {
        class_2338 gamePos = packet.method_10811();
        class_3218 level = player.method_51469();
        UUID playerUuid = packet.method_10790();
        int actionType = packet.readInt();
        switch (actionType) {
            case 0: {
                Card card = new Card(Objects.requireNonNull(packet.method_10798()));
                int wildSelectionOrdinal = packet.readInt();
                boolean shout = packet.readBoolean();
                server.execute(() -> {
                    class_2586 patt0$temp = level.method_8321(gamePos);
                    if (!(patt0$temp instanceof BlockEntityMinoTable)) {
                        return;
                    }
                    BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                    if (tableEntity.game == null) {
                        return;
                    }
                    CardPlayer cardPlayer = tableEntity.game.deAmputate(playerUuid);
                    if (cardPlayer == null) {
                        return;
                    }
                    Card.Suit wildSelection = wildSelectionOrdinal == -1 ? null : Card.Suit.values()[wildSelectionOrdinal];
                    ActionReport result = tableEntity.game.playCard(cardPlayer, card, wildSelection, shout);
                    tableEntity.handleActionResult(result, cardPlayer, player);
                });
                break;
            }
            case 1: {
                server.execute(() -> {
                    class_2586 patt0$temp = level.method_8321(gamePos);
                    if (!(patt0$temp instanceof BlockEntityMinoTable)) {
                        return;
                    }
                    BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                    if (tableEntity.game == null) {
                        return;
                    }
                    CardPlayer cardPlayer = tableEntity.game.deAmputate(playerUuid);
                    if (cardPlayer == null) {
                        return;
                    }
                    ActionReport result = tableEntity.game.playNoCard(cardPlayer);
                    tableEntity.handleActionResult(result, cardPlayer, player);
                });
                break;
            }
            case 2: {
                UUID targetPlayerUuid = packet.method_10790();
                server.execute(() -> {
                    class_2586 patt0$temp = level.method_8321(gamePos);
                    if (!(patt0$temp instanceof BlockEntityMinoTable)) {
                        return;
                    }
                    BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                    if (tableEntity.game == null) {
                        return;
                    }
                    CardPlayer cardPlayer = tableEntity.game.deAmputate(playerUuid);
                    if (cardPlayer == null) {
                        return;
                    }
                    ActionReport result = tableEntity.game.doubtMino(cardPlayer, targetPlayerUuid);
                    tableEntity.handleActionResult(result, cardPlayer, player);
                });
            }
        }
    }

    public static class Client {
        public static void sendPlayCardC2S(class_2338 gamePos, CardPlayer player, Card card, Card.Suit wildSelection, boolean shout) {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.method_10807(gamePos);
            packet.method_10797(player.uuid);
            packet.writeInt(0);
            packet.method_10794(card.toTag());
            packet.writeInt(wildSelection == null ? -1 : wildSelection.ordinal());
            packet.writeBoolean(shout);
            ClientPlatform.sendPacketToServer(ID, packet);
        }

        public static void sendPlayNoCardC2S(class_2338 gamePos, CardPlayer player) {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.method_10807(gamePos);
            packet.method_10797(player.uuid);
            packet.writeInt(1);
            ClientPlatform.sendPacketToServer(ID, packet);
        }

        public static void sendDoubtMinoC2S(class_2338 gamePos, CardPlayer player, UUID targetPlayer) {
            class_2540 packet = new class_2540(Unpooled.buffer());
            packet.method_10807(gamePos);
            packet.method_10797(player.uuid);
            packet.writeInt(2);
            packet.method_10797(targetPlayer);
            ClientPlatform.sendPacketToServer(ID, packet);
        }
    }
}

