/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.item;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.platform.GroupedItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class ItemHandCards
extends GroupedItem {
    private static final String NBT_TABLE_POS = "TablePos";
    private static final String NBT_BEARER_ID = "BearerId";
    private static final String NBT_CLIENT_HAND_INDEX = "ClientHandIndex";

    public ItemHandCards() {
        super(() -> null, p -> p.method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_2586 class_25862;
        if (usedHand != class_1268.field_5808) {
            return super.method_7836(level, player, usedHand);
        }
        class_2338 gamePos = ItemHandCards.getHandCardGamePos(player);
        if (gamePos != null && (class_25862 = level.method_8321(gamePos)) instanceof BlockEntityMinoTable) {
            BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)class_25862;
            if (tableEntity.game != null && tableEntity.getPlayersList().stream().anyMatch(p -> p.uuid.equals(player.method_7334().getId()))) {
                return class_1271.method_22431((Object)player.method_5998(usedHand));
            }
        }
        player.method_6122(usedHand, class_1799.field_8037);
        return class_1271.method_22428((Object)player.method_5998(usedHand));
    }

    public static CardPlayer getCardPlayer(class_1657 player) {
        return new CardPlayer(player);
    }

    public static class_2338 getHandCardGamePos(class_1657 player) {
        if (!player.method_6047().method_31574((class_1792)Mino.ITEM_HAND_CARDS.get())) {
            return null;
        }
        class_2487 tag = player.method_6047().method_7969();
        if (tag == null || !tag.method_10545(NBT_TABLE_POS)) {
            return null;
        }
        class_2338 tablePos = class_2512.method_10691((class_2487)tag.method_10562(NBT_TABLE_POS));
        class_2680 blockState = player.method_37908().method_8320(tablePos);
        if (!blockState.method_27852(Mino.BLOCK_MINO_TABLE.get())) {
            return null;
        }
        return BlockMinoTable.getCore(blockState, tablePos);
    }

    public static int getClientHandIndex(class_1657 player) {
        if (player.method_6047().method_31574((class_1792)Mino.ITEM_HAND_CARDS.get())) {
            class_2487 tag = player.method_6047().method_7969();
            return tag != null ? tag.method_10550(NBT_CLIENT_HAND_INDEX) : 0;
        }
        return 0;
    }

    public static void setCardGameBinding(class_1799 stack, class_2338 tablePos, UUID bearerId) {
        class_2487 tag = stack.method_7948();
        tag.method_10566(NBT_TABLE_POS, (class_2520)class_2512.method_10692((class_2338)tablePos));
        tag.method_25927(NBT_BEARER_ID, bearerId);
    }

    public static void setCardGameBinding(class_1799 stack, CardGameBinding binding) {
        ItemHandCards.setCardGameBinding(stack, binding.tablePos(), binding.bearerId());
    }

    public static void setClientHandIndex(class_1799 stack, int index) {
        class_2487 tag = stack.method_7948();
        tag.method_10569(NBT_CLIENT_HAND_INDEX, index);
    }

    public static int getClientHandIndex(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10550(NBT_CLIENT_HAND_INDEX);
    }

    public static CardGameBinding getCardGameBinding(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545(NBT_TABLE_POS) || !tag.method_10545(NBT_BEARER_ID)) {
            return null;
        }
        return new CardGameBinding(class_2512.method_10691((class_2487)tag.method_10562(NBT_TABLE_POS)), tag.method_25926(NBT_BEARER_ID));
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        CardGameBinding binding = ItemHandCards.getCardGameBinding(stack);
        if (binding != null) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)("Table: " + binding.tablePos().method_23854())));
            if (class_310.method_1551().field_1724 != null && binding.bearerId().equals(class_310.method_1551().field_1724.method_7334().getId())) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)"NOT YOUR CARD!").method_27692(class_124.field_1061));
            }
        }
        super.method_7851(stack, level, tooltipComponents, tooltipFlag);
    }

    public record CardGameBinding(class_2338 tablePos, UUID bearerId) {
    }
}

