/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.item;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemDataUtils {
    public static final String MINO_DATA = "minopp_data";
    public static final String CARD_GAME_BINDING_TABLE_POS = "card_game_binding_table_pos";
    public static final String CARD_GAME_BINDING_BEARER_ID = "card_game_binding_bearer_id";
    public static final String CLIENT_HAND_INDEX = "client_hand_index";

    @NotNull
    public static class_2487 getDataMap(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10573(MINO_DATA, 10)) {
            return tag.method_10562(MINO_DATA);
        }
        class_2487 dataMap = new class_2487();
        tag.method_10566(MINO_DATA, (class_2520)dataMap);
        return dataMap;
    }

    @Nullable
    public static class_2487 getDataMapIfPresent(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573(MINO_DATA, 10)) {
            return tag.method_10562(MINO_DATA);
        }
        return null;
    }

    public static boolean hasData(class_1799 stack, String key, int type) {
        class_2487 dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        return dataMap != null && dataMap.method_10573(key, type);
    }

    public static void removeData(class_1799 stack, String key) {
        class_2487 dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        if (dataMap != null) {
            dataMap.method_10551(key);
            if (dataMap.method_33133()) {
                stack.method_7983(MINO_DATA);
            }
        }
    }

    public static int getHandIndex(class_1799 stack) {
        class_2487 dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        return dataMap == null ? 0 : dataMap.method_10550(CLIENT_HAND_INDEX);
    }

    public static class_2338 getBlockPos(class_1799 stack) {
        class_2487 dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        return dataMap == null ? null : class_2338.method_10092((long)dataMap.method_10537(CARD_GAME_BINDING_TABLE_POS));
    }

    @Nullable
    public static UUID getBearerId(class_1799 stack) {
        class_2487 dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        if (dataMap != null && dataMap.method_25928(CARD_GAME_BINDING_BEARER_ID)) {
            return dataMap.method_25926(CARD_GAME_BINDING_BEARER_ID);
        }
        return null;
    }

    public static void setHandIndex(class_1799 stack, int index) {
        ItemDataUtils.getDataMap(stack).method_10569(CLIENT_HAND_INDEX, index);
    }

    public static void setBlockPos(class_1799 stack, class_2338 blockPos) {
        ItemDataUtils.getDataMap(stack).method_10544(CARD_GAME_BINDING_TABLE_POS, blockPos.method_10063());
    }

    public static void setBearerId(class_1799 stack, @Nullable UUID uuid) {
        if (uuid == null) {
            ItemDataUtils.removeData(stack, CARD_GAME_BINDING_BEARER_ID);
        } else {
            ItemDataUtils.getDataMap(stack).method_25927(CARD_GAME_BINDING_BEARER_ID, uuid);
        }
    }

    public static void setCardGameBinding(class_1799 stack, class_2338 blockPos, UUID uuid) {
        ItemDataUtils.setBlockPos(stack, blockPos);
        ItemDataUtils.setBearerId(stack, uuid);
    }
}

