/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.gui;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.MinoClient;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.ActionMessage;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.gui.TurnDeadMan;
import cn.zbx1425.minopp.item.ItemHandCards;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2FloatArrayMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class GameOverlayLayer {
    private double zoomAnimationProgress = 0.0;
    private double zoomAnimationTarget = 0.0;
    private final Long2FloatArrayMap handCardCurrentXOff = new Long2FloatArrayMap();
    private static final class_2960 ATLAS_LOCATION = Mino.id("textures/gui/deck.png");
    public static final GameOverlayLayer INSTANCE = new GameOverlayLayer();

    public void render(class_332 guiGraphics, float partialTick) {
        class_2338 gamePos;
        class_746 player = class_310.method_1551().field_1724;
        class_2338 handCardGamePos = ItemHandCards.getHandCardGamePos((class_1657)player);
        class_638 level = class_310.method_1551().field_1687;
        class_2338 hitResultGamePos = BlockMinoTable.Client.getCursorPickedGame();
        class_2338 class_23382 = gamePos = handCardGamePos != null ? handCardGamePos : hitResultGamePos;
        if (gamePos == null) {
            TurnDeadMan.setOutsideGame();
            MinoClient.handCardOverlayActive = false;
            this.handCardCurrentXOff.clear();
            return;
        }
        BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)level.method_8321(gamePos);
        if (tableEntity == null) {
            TurnDeadMan.setOutsideGame();
            MinoClient.handCardOverlayActive = false;
            this.handCardCurrentXOff.clear();
            return;
        }
        if (tableEntity.game == null) {
            this.renderGameInactive(guiGraphics, partialTick, tableEntity);
            TurnDeadMan.setOutsideGame();
            this.zoomAnimationTarget = 0.0;
            this.zoomAnimationProgress = 0.0;
        } else {
            TurnDeadMan.tick(tableEntity.game, partialTick);
            if (handCardGamePos == null || hitResultGamePos == null || Objects.equals(handCardGamePos, hitResultGamePos)) {
                this.renderGameActive(guiGraphics, partialTick, tableEntity);
            } else {
                this.zoomAnimationTarget = 0.0;
            }
        }
        this.performZoomAnimation(partialTick, tableEntity);
        MinoClient.handCardOverlayActive = this.renderHandCards(guiGraphics, partialTick);
    }

    private void renderGameInactive(class_332 guiGraphics, float partialTick, BlockEntityMinoTable tableEntity) {
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        int x = 20;
        int y = 60;
        class_327 font = class_310.method_1551().field_1772;
        for (String part : tableEntity.state.message().getString().split("\n")) {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)class_2561.method_43470((String)part), x, y, -1);
            Objects.requireNonNull(font);
            y += 9;
        }
        Objects.requireNonNull(font);
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)class_2561.method_43471((String)"gui.minopp.play.start_hint"), x, y += 9, -16720555);
    }

    private void renderGameActive(class_332 guiGraphics, float partialTick, BlockEntityMinoTable tableEntity) {
        class_2338 hitPos;
        class_2680 hitState;
        class_746 player = class_310.method_1551().field_1724;
        CardPlayer cardPlayer = ItemHandCards.getCardPlayer((class_1657)player);
        CardPlayer currentPlayer = tableEntity.game.players.get(tableEntity.game.currentPlayerIndex);
        if (currentPlayer.equals(cardPlayer)) {
            if (tableEntity.game.currentPlayerPhase == CardGame.PlayerActionPhase.DISCARD_HAND) {
                this.zoomAnimationTarget = 1.0;
            } else if (this.zoomAnimationTarget < 1.01) {
                this.zoomAnimationTarget = 1.5;
            } else if (this.zoomAnimationProgress >= 1.5) {
                this.zoomAnimationTarget = 1.05;
            }
        } else {
            this.zoomAnimationTarget = 0.0;
        }
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        int x = 20;
        int y = 60;
        class_327 font = class_310.method_1551().field_1772;
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)class_2561.method_43471((String)"gui.minopp.play.game_active").method_27693(" \u00a9 Zbx1425"), x, y, -9400065);
        Objects.requireNonNull(font);
        y += 9;
        if (currentPlayer.equals(cardPlayer)) {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)class_2561.method_43471((String)("gui.minopp.play." + tableEntity.game.currentPlayerPhase.name().toLowerCase())), x, y, System.currentTimeMillis() % 400L < 200L ? -1 : -256);
        } else {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)class_2561.method_43469((String)"gui.minopp.play.turn_other", (Object[])new Object[]{currentPlayer.name}), x, y, -5592406);
        }
        Objects.requireNonNull(font);
        y += 9;
        class_5250 auxInfo = class_2561.method_43471((String)("gui.minopp.play.direction." + (tableEntity.game.isAntiClockwise ? "ccw" : "cw")));
        if (tableEntity.game.drawCount > 0) {
            auxInfo = auxInfo.method_27693(", ").method_10852((class_2561)class_2561.method_43469((String)"gui.minopp.play.draw_accumulate", (Object[])new Object[]{tableEntity.game.drawCount}));
        }
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)auxInfo, x, y, -5592406);
        Objects.requireNonNull(font);
        y += 9 * 2;
        class_5250 topCardInfo = class_2561.method_43469((String)"gui.minopp.play.top_card", (Object[])new Object[]{tableEntity.game.topCard.getDisplayName().getString()});
        if (tableEntity.game.topCard.suit == Card.Suit.WILD) {
            topCardInfo.method_27693(", ").method_10852((class_2561)class_2561.method_43469((String)"gui.minopp.play.top_card_wild_color", (Object[])new Object[]{class_2561.method_43471((String)("game.minopp.card.suit." + tableEntity.game.topCard.getEquivSuit().name().toLowerCase()))}));
        }
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)topCardInfo, x, y, -35);
        Objects.requireNonNull(font);
        y += 9 * 2;
        for (String part : tableEntity.state.message().getString().split("\n")) {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (class_2561)class_2561.method_43470((String)part), x, y, -1);
            Objects.requireNonNull(font);
            y += 9;
        }
        ListIterator<Pair<ActionMessage, Long>> it = tableEntity.clientMessageList.listIterator(tableEntity.clientMessageList.size());
        while (it.hasPrevious()) {
            int n = class_310.method_1551().method_22683().method_4502();
            Objects.requireNonNull(font);
            if (y > n - 9 - 40) break;
            Pair<ActionMessage, Long> entry = it.previous();
            long currentTime = System.currentTimeMillis();
            if ((Long)entry.getSecond() - 200L < currentTime) {
                it.remove();
                continue;
            }
            int color = ((ActionMessage)entry.getFirst()).type().isEphemeral() ? 0xFF0000 : 0xAAAAAA;
            int alpha = class_3532.method_15340((int)0, (int)255, (int)((int)(255L * ((Long)entry.getSecond() - currentTime) / 1000L)));
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, ((ActionMessage)entry.getFirst()).message(), x, y, alpha << 24 | color);
            Objects.requireNonNull(font);
            y += 9;
        }
        if (class_310.method_1551().field_1765.method_17783() == class_239.class_240.field_1332 && (hitState = class_310.method_1551().field_1687.method_8320(hitPos = ((class_3965)class_310.method_1551().field_1765).method_17777())).method_27852(Mino.BLOCK_MINO_TABLE.get())) {
            boolean isPass = BlockMinoTable.Client.isCursorHittingPile();
            if (currentPlayer.equals(cardPlayer)) {
                int n;
                class_5250 cursorMessage = switch (tableEntity.game.currentPlayerPhase) {
                    default -> throw new IncompatibleClassChangeError();
                    case CardGame.PlayerActionPhase.DISCARD_HAND -> {
                        if (isPass) {
                            yield class_2561.method_43471((String)"gui.minopp.play.cursor.pass_draw");
                        }
                        yield class_2561.method_43471((String)"gui.minopp.play.cursor.play");
                    }
                    case CardGame.PlayerActionPhase.DISCARD_DRAWN -> isPass ? class_2561.method_43471((String)"gui.minopp.play.cursor.pass") : class_2561.method_43471((String)"gui.minopp.play.cursor.play");
                };
                class_5250 shoutMessage = class_2561.method_43471((String)"gui.minopp.play.cursor.shout");
                boolean isShouting = !isPass && BlockMinoTable.Client.isShoutModifierHeld();
                int width = class_310.method_1551().method_22683().method_4486();
                int height = class_310.method_1551().method_22683().method_4502();
                boolean highlight = class_310.method_1551().field_1687.method_8510() % 3L < 2L && isPass;
                int msgWidth = Math.max(font.method_27525((class_5348)cursorMessage), isShouting ? font.method_27525((class_5348)shoutMessage) : 0);
                if (isShouting) {
                    Objects.requireNonNull(font);
                    n = 9 * 2;
                } else {
                    Objects.requireNonNull(font);
                    n = 9;
                }
                int msgHeight = n;
                guiGraphics.method_25294(width / 2 + 8, height / 2 - msgHeight / 2 - 2, width / 2 + msgWidth + 16, height / 2 + msgHeight / 2 + 3, highlight ? -2136298906 : Integer.MIN_VALUE);
                guiGraphics.method_27535(font, (class_2561)cursorMessage, width / 2 + 12, height / 2 - msgHeight / 2, highlight ? -14540254 : -35);
                if (isShouting) {
                    int n2 = width / 2 + 12;
                    int n3 = height / 2 - msgHeight / 2;
                    Objects.requireNonNull(font);
                    guiGraphics.method_27535(font, (class_2561)shoutMessage, n2, n3 + 9, highlight ? -14540254 : -35);
                }
            }
        }
        if (TurnDeadMan.isAlarmActive()) {
            class_5250 deadManMessage = class_2561.method_43471((String)"gui.minopp.play.cursor.dead_man");
            int width = class_310.method_1551().method_22683().method_4486();
            int height = class_310.method_1551().method_22683().method_4502();
            boolean highlight = class_310.method_1551().field_1687.method_8510() % 3L < 2L;
            int msgWidth = font.method_27525((class_5348)deadManMessage);
            Objects.requireNonNull(font);
            int msgHeight = 9;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)(width / 2), (float)(height / 2 + 12), 0.0f);
            guiGraphics.method_51448().method_22905(1.5f, 1.5f, 1.0f);
            guiGraphics.method_25294(-msgWidth / 2 - 4, 0, msgWidth / 2 + 4, msgHeight + 4, highlight ? -2136298906 : Integer.MIN_VALUE);
            guiGraphics.method_27535(font, (class_2561)deadManMessage, -msgWidth / 2, 2, highlight ? -14540254 : -35);
            guiGraphics.method_51448().method_22909();
        }
    }

    private static void drawStringWithBackdrop(class_332 guiGraphics, class_327 font, class_2561 component, int x, int y, int color) {
        int i = 0x66000000;
        int var10001 = x - 2;
        int var10002 = y;
        int var10003 = x + font.method_27525((class_5348)component) + 2;
        Objects.requireNonNull(font);
        guiGraphics.method_25294(var10001, var10002, var10003, y + 9, class_5253.class_5254.method_27763((int)i, (int)color));
        guiGraphics.method_51439(font, component, x, y, color, true);
    }

    private boolean renderHandCards(class_332 guiGraphics, float partialTick) {
        if (class_310.method_1551().field_1690.field_1842) {
            return false;
        }
        class_327 font = class_310.method_1551().field_1772;
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        class_2338 gamePos = ItemHandCards.getHandCardGamePos((class_1657)player);
        if (gamePos == null) {
            return false;
        }
        BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)level.method_8321(gamePos);
        CardPlayer playerWithoutHand = ItemHandCards.getCardPlayer((class_1657)player);
        int CARD_V_SPACING = 20;
        int CARD_WIDTH = (int)(100.0 * class_3532.method_16436((double)this.zoomAnimationProgress, (double)0.93, (double)1.0));
        int CARD_HEIGHT = (int)((double)CARD_WIDTH * 8.9 / 5.6);
        if (tableEntity.game == null) {
            return false;
        }
        CardPlayer realPlayer = tableEntity.game.players.stream().filter(p -> p.equals(playerWithoutHand)).findFirst().orElse(null);
        if (realPlayer == null) {
            return false;
        }
        int clientHandIndex = class_3532.method_15340((int)ItemHandCards.getClientHandIndex((class_1657)player), (int)0, (int)(realPlayer.hand.size() - 1));
        realPlayer.hand.sort(Card::compareTo);
        LongArrayList handCardHashes = new LongArrayList();
        for (Card card : realPlayer.hand) {
            if (!handCardHashes.isEmpty() && (long)card.hashCode() == (handCardHashes.getLong(handCardHashes.size() - 1) & 0xFFFFFFFFL)) {
                handCardHashes.add(handCardHashes.getLong(handCardHashes.size() - 1) + 0x100000000L);
                continue;
            }
            handCardHashes.add((long)card.hashCode());
        }
        this.handCardCurrentXOff.keySet().removeIf(hash -> !handCardHashes.contains(hash));
        RenderSystem.enableBlend();
        int width = class_310.method_1551().method_22683().method_4486();
        int height = class_310.method_1551().method_22683().method_4502();
        int handSize = realPlayer.hand.size();
        int selectedCardYRaw = height - (CARD_HEIGHT / 2 + 20 * (handSize - clientHandIndex));
        int cardDrawOffset = selectedCardYRaw < 20 ? 20 - selectedCardYRaw : 0;
        Random cardRandom = new Random(handSize);
        for (int i = 0; i < handSize; ++i) {
            Card card;
            int targetXOff = (i == clientHandIndex ? -30 : 0) + cardRandom.nextInt(-3, 4);
            float currentXOff = this.handCardCurrentXOff.computeIfAbsent(handCardHashes.getLong(i), ignored -> CARD_WIDTH + 10);
            int x = width - 10 - CARD_WIDTH + (int)currentXOff;
            this.handCardCurrentXOff.put(handCardHashes.getLong(i), (float)class_3532.method_16436((double)(0.4 * (double)partialTick), (double)currentXOff, (double)targetXOff));
            int y = height - (CARD_HEIGHT / 2 + 20 * (handSize - i)) + cardDrawOffset;
            if (i == clientHandIndex) {
                card = realPlayer.hand.get(i);
                class_2561 cardName = card.getDisplayName();
                guiGraphics.method_27535(font, cardName, x - font.method_27525((class_5348)cardName) - 10, y + 10, -35);
            }
            guiGraphics.method_25294(x, y, x + CARD_WIDTH, y + CARD_HEIGHT, -14540254);
            guiGraphics.method_25294(x + 1, y + 1, x + CARD_WIDTH - 1, y + CARD_HEIGHT - 1, -2236963);
            card = realPlayer.hand.get(i);
            float cardU = switch (card.family) {
                default -> throw new IncompatibleClassChangeError();
                case Card.Family.NUMBER -> Math.abs(card.number) * 16;
                case Card.Family.SKIP -> 160.0f;
                case Card.Family.DRAW -> 176.0f;
                case Card.Family.REVERSE -> 192.0f;
            };
            float cardV = card.suit.ordinal() * 25;
            int cardUW = 16;
            int cardVH = 25;
            float shadowAlpha = (float)Math.max(class_3532.method_16436((double)this.zoomAnimationProgress, (double)0.5, (double)0.0), 0.0);
            guiGraphics.method_25293(ATLAS_LOCATION, x + 5, y + 5, CARD_WIDTH - 10, CARD_HEIGHT - 10, cardU + 1.0f, cardV + 1.0f, cardUW - 2, cardVH - 2, 256, 128);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)(x + 7), (float)(y + 7), 0.0f);
            guiGraphics.method_51448().method_22905(1.5f, 1.5f, 1.0f);
            if (card.family == Card.Family.REVERSE) {
                guiGraphics.method_25290(ATLAS_LOCATION, 0, 0, 208.0f, 0.0f, 10, 10, 256, 128);
            } else if (card.family == Card.Family.SKIP) {
                guiGraphics.method_25290(ATLAS_LOCATION, 0, 0, 218.0f, 0.0f, 10, 10, 256, 128);
            } else if (card.suit == Card.Suit.WILD && card.family == Card.Family.NUMBER) {
                guiGraphics.method_25290(ATLAS_LOCATION, 0, 0, 228.0f, 0.0f, 10, 10, 256, 128);
            } else {
                class_5250 cardName = card.getCardFaceName().method_27661().method_27696(class_2583.field_24360.method_27704(new class_2960("include/default")));
                int colorA = (int)(34.0f * shadowAlpha + 255.0f * (1.0f - shadowAlpha));
                guiGraphics.method_27535(font, (class_2561)cardName, 0, 0, -16777216 + colorA * 65793);
            }
            guiGraphics.method_51448().method_22909();
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_25294(x, y, x + CARD_WIDTH, y + CARD_HEIGHT, 0x222222 | (int)(255.0f * shadowAlpha) << 24);
            guiGraphics.method_51448().method_22909();
        }
        RenderSystem.disableBlend();
        return true;
    }

    private void performZoomAnimation(float partialTick, BlockEntityMinoTable tableEntity) {
        this.zoomAnimationProgress = Math.abs(this.zoomAnimationTarget - this.zoomAnimationProgress) < 0.01 ? this.zoomAnimationTarget : (this.zoomAnimationProgress += (this.zoomAnimationTarget - this.zoomAnimationProgress) * 8.0 * 0.05 * (double)partialTick);
        MinoClient.globalFovModifier = class_3532.method_16436((double)class_3532.method_15350((double)this.zoomAnimationProgress, (double)0.0, (double)1.0), (double)1.0, (double)0.97);
    }
}

