/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.game;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class Card
implements Comparable<Card> {
    public Family family;
    public Suit suit;
    public int number;
    public Card equivCard;

    public Card(Family family, Suit suit, int number) {
        this.family = family;
        this.suit = suit;
        this.number = number;
    }

    private Card(Family family, Suit suit, int number, Card equivCard) {
        this(family, suit, number);
        this.equivCard = equivCard;
    }

    public static List<Card> createDeck() {
        int i;
        ArrayList<Card> deck = new ArrayList<Card>();
        for (Suit suit : Suit.values()) {
            if (suit == Suit.WILD) continue;
            for (i = 0; i <= 9; ++i) {
                deck.add(new Card(Family.NUMBER, suit, i));
            }
            for (i = 1; i <= 9; ++i) {
                deck.add(new Card(Family.NUMBER, suit, i));
            }
        }
        for (Suit suit : Suit.values()) {
            if (suit == Suit.WILD) continue;
            for (i = 0; i < 2; ++i) {
                deck.add(new Card(Family.SKIP, suit, -101));
                deck.add(new Card(Family.REVERSE, suit, -102));
                deck.add(new Card(Family.DRAW, suit, -2));
            }
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            deck.add(new Card(Family.NUMBER, Suit.WILD, -1));
            deck.add(new Card(Family.DRAW, Suit.WILD, -4));
        }
        return deck;
    }

    public boolean canPlayOn(Card topCard) {
        if (this.equivCard != null) {
            return this.equivCard.canPlayOn(topCard);
        }
        if (topCard.equivCard != null) {
            return this.canPlayOn(topCard.equivCard);
        }
        if (topCard.family == Family.DRAW) {
            return this.family == topCard.family && this.number == topCard.number;
        }
        if (this.suit == Suit.WILD) {
            return true;
        }
        return this.suit == topCard.suit || this.number == topCard.number;
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)("game.minopp.card.suit." + this.suit.name().toLowerCase())).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)("game.minopp.card.family." + this.family.name().toLowerCase()), (Object[])new Object[]{this.family == Family.DRAW ? Integer.valueOf(-this.number) : (this.suit == Suit.WILD ? "" : Integer.valueOf(this.number))}));
    }

    public class_2561 getCardFaceName() {
        return class_2561.method_43469((String)("game.minopp.card.family." + this.family.name().toLowerCase()), (Object[])new Object[]{this.family == Family.DRAW ? Integer.valueOf(-this.number) : (this.suit == Suit.WILD ? "" : Integer.valueOf(this.number))});
    }

    public Card withEquivFamily(Family equivFamily) {
        return new Card(this.family, this.suit, this.number, new Card(equivFamily, this.getEquivSuit(), this.number));
    }

    public Card withEquivSuit(Suit equivSuit) {
        return new Card(this.family, this.suit, this.number, new Card(this.getEquivFamily(), equivSuit, this.number));
    }

    public Family getEquivFamily() {
        return this.equivCard == null ? this.family : this.equivCard.family;
    }

    public Suit getEquivSuit() {
        return this.equivCard == null ? this.suit : this.equivCard.suit;
    }

    public Card eraseEquiv() {
        return new Card(this.family, this.suit, this.number);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return this.number == card.number && this.family == card.family && this.suit == card.suit;
    }

    public int hashCode() {
        return this.suit.ordinal() << 16 | this.family.ordinal() << 8 | this.number + 128;
    }

    @Override
    public int compareTo(@NotNull Card o) {
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    public Card(class_2487 tag) {
        this(Family.valueOf(tag.method_10558("family")), Suit.valueOf(tag.method_10558("suit")), tag.method_10550("number"), tag.method_10545("actualCard") ? new Card(tag.method_10562("actualCard")) : null);
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("family", this.family.name());
        tag.method_10582("suit", this.suit.name());
        tag.method_10569("number", this.number);
        if (this.equivCard != null) {
            tag.method_10566("actualCard", (class_2520)this.equivCard.toTag());
        }
        return tag;
    }

    public static enum Family {
        NUMBER,
        SKIP,
        REVERSE,
        DRAW;

    }

    public static enum Suit {
        RED(-4322304),
        YELLOW(-1585148),
        GREEN(-13465072),
        BLUE(-15575893),
        WILD(-14804455);

        public final int color;

        private Suit(int color) {
            this.color = color;
        }
    }
}

