/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.game;

import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import java.util.Random;
import net.minecraft.class_2487;
import net.minecraft.server.MinecraftServer;

public class AutoPlayer {
    public boolean aiNoWin = false;
    public boolean aiNoPlayerDraw = false;
    public float aiForgetChance = 0.2f;
    public byte aiNoDelay = 0;
    public boolean aiStartGame = false;

    public ActionReport playAtGame(CardGame game, CardPlayer realPlayer, MinecraftServer server) {
        ActionReport result;
        boolean canPlayDrawCard;
        Card topCard = game.topCard;
        boolean forgetsMino = new Random().nextFloat() < this.aiForgetChance;
        boolean shoutsMino = !forgetsMino && realPlayer.hand.size() <= 2;
        CardPlayer nextPlayer = game.players.get((game.currentPlayerIndex + (game.isAntiClockwise ? -1 : 1) + game.players.size()) % game.players.size());
        boolean bl = canPlayDrawCard = !this.aiNoPlayerDraw || server.method_3760().method_14602(nextPlayer.uuid) == null;
        if (this.aiNoWin && realPlayer.hand.size() <= 1) {
            return game.playNoCard(realPlayer);
        }
        for (Card card : realPlayer.hand) {
            if (card.number != topCard.number || card.suit == topCard.getEquivSuit() || card.suit == Card.Suit.WILD || !canPlayDrawCard && card.family == Card.Family.DRAW) continue;
            result = game.playCard(realPlayer, card, null, shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        for (Card card : realPlayer.hand) {
            if (card.suit != Card.Suit.WILD || card.family == Card.Family.DRAW) continue;
            result = game.playCard(realPlayer, card, this.getMostCommonSuit(realPlayer), shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        for (Card card : realPlayer.hand) {
            if (card.suit != topCard.getEquivSuit() || card.suit == Card.Suit.WILD || !canPlayDrawCard && card.family == Card.Family.DRAW) continue;
            result = game.playCard(realPlayer, card, null, shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        for (Card card : realPlayer.hand) {
            if (!canPlayDrawCard && card.family == Card.Family.DRAW || !card.canPlayOn(topCard)) continue;
            if (card.suit == Card.Suit.WILD) {
                result = game.playCard(realPlayer, card, this.getMostCommonSuit(realPlayer), shoutsMino);
                if (result.isFail) continue;
                return result;
            }
            result = game.playCard(realPlayer, card, null, shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        return game.playNoCard(realPlayer);
    }

    private Card.Suit getMostCommonSuit(CardPlayer realPlayer) {
        int[] suitCount = new int[4];
        for (Card handCard : realPlayer.hand) {
            if (handCard.suit == Card.Suit.WILD) continue;
            int n = handCard.suit.ordinal();
            suitCount[n] = suitCount[n] + 1;
        }
        Card.Suit mostCommonSuit = Card.Suit.values()[new Random().nextInt(0, 4)];
        for (int i = 1; i < 4; ++i) {
            if (suitCount[i] <= suitCount[mostCommonSuit.ordinal()]) continue;
            mostCommonSuit = Card.Suit.values()[i];
        }
        return mostCommonSuit;
    }

    public void useConfigNbt(class_2487 aiConfig) {
        this.aiNoWin = aiConfig.method_10577("NoWin");
        this.aiNoPlayerDraw = aiConfig.method_10577("NoPlayerDraw");
        this.aiForgetChance = aiConfig.method_10573("ForgetChance", 5) ? aiConfig.method_10583("ForgetChance") : 0.2f;
        this.aiNoDelay = aiConfig.method_10571("NoDelay");
        this.aiStartGame = aiConfig.method_10577("StartGame");
    }

    public class_2487 toConfigNbt() {
        class_2487 aiConfig = new class_2487();
        aiConfig.method_10556("NoWin", this.aiNoWin);
        aiConfig.method_10556("NoPlayerDraw", this.aiNoPlayerDraw);
        aiConfig.method_10548("ForgetChance", this.aiForgetChance);
        aiConfig.method_10567("NoDelay", this.aiNoDelay);
        aiConfig.method_10556("StartGame", this.aiStartGame);
        return aiConfig;
    }
}

