/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.game;

import cn.zbx1425.minopp.effect.EffectEvent;
import cn.zbx1425.minopp.effect.SoundEffectEvent;
import cn.zbx1425.minopp.game.ActionMessage;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5250;

public class ActionReport {
    private CardGame game;
    private CardPlayer initiator;
    public ActionMessage state;
    public List<ActionMessage> messages = new ArrayList<ActionMessage>();
    public List<EffectEvent> effects = new ArrayList<EffectEvent>();
    public boolean shouldDestroyGame = false;
    public boolean isFail = false;
    private static final int SOUND_RANGE = 16;
    public static final ActionReport NO_GAME = ActionReport.builder().state((class_2561)class_2561.method_43471((String)"game.minopp.play.no_game"));

    private ActionReport(CardGame game, CardPlayer player) {
        this.initiator = player;
        this.game = game;
    }

    public static ActionReport builder(CardGame game, CardPlayer player) {
        return new ActionReport(game, player);
    }

    public static ActionReport builder(CardGame game) {
        return ActionReport.builder(game, null);
    }

    public static ActionReport builder(CardPlayer player) {
        return ActionReport.builder(null, player);
    }

    public static ActionReport builder() {
        return ActionReport.builder(null, null);
    }

    public ActionReport state(class_2561 message) {
        this.state = new ActionMessage(ActionMessage.Type.STATE, message);
        return this;
    }

    public ActionReport fail(class_2561 message) {
        this.isFail = true;
        this.messages.add(new ActionMessage(ActionMessage.Type.FAIL, message));
        return this;
    }

    public ActionReport messageAll(class_2561 message) {
        this.messages.add(new ActionMessage(ActionMessage.Type.MESSAGE_ALL, message));
        return this;
    }

    public ActionReport combineWith(ActionReport other) {
        if (other == null) {
            return this;
        }
        if (this.state == null) {
            this.state = other.state;
        }
        this.messages.addAll(other.messages);
        this.shouldDestroyGame |= other.shouldDestroyGame;
        this.effects.addAll(other.effects);
        return this;
    }

    public ActionReport sound(class_2960 sound, int timeOffset, CardPlayer target) {
        this.effects.add(new SoundEffectEvent(timeOffset, Optional.of(target.uuid), class_3414.method_47909((class_2960)sound, (float)16.0f)));
        return this;
    }

    public ActionReport sound(class_2960 sound, int timeOffset) {
        this.effects.add(new SoundEffectEvent(timeOffset, Optional.empty(), class_3414.method_47909((class_2960)sound, (float)16.0f)));
        return this;
    }

    public ActionReport effect(EffectEvent event) {
        this.effects.add(event);
        return this;
    }

    public ActionReport played() {
        return this.state((class_2561)class_2561.method_43469((String)"game.minopp.play.played", (Object[])new Object[]{this.initiator.name, this.game.topCard.getDisplayName()}));
    }

    public ActionReport cut() {
        return this.state((class_2561)class_2561.method_43469((String)"game.minopp.play.cut", (Object[])new Object[]{this.initiator.name, this.game.topCard.getDisplayName()}));
    }

    public ActionReport drew(int drawCount) {
        return this.state((class_2561)class_2561.method_43469((String)"game.minopp.play.drew", (Object[])new Object[]{this.initiator.name, drawCount}));
    }

    public ActionReport playedNoCard(boolean drawn) {
        if (drawn) {
            return this.state((class_2561)class_2561.method_43469((String)"game.minopp.play.played_no_drawn_card", (Object[])new Object[]{this.initiator.name}));
        }
        return this.state((class_2561)class_2561.method_43469((String)"game.minopp.play.played_no_card", (Object[])new Object[]{this.initiator.name}));
    }

    public ActionReport gameDestroyed() {
        return this.state((class_2561)class_2561.method_43469((String)"game.minopp.play.game_destroyed", (Object[])new Object[]{this.initiator.name}));
    }

    public ActionReport gameStarted() {
        return this.state((class_2561)class_2561.method_43469((String)"game.minopp.play.game_started", (Object[])new Object[]{this.initiator.name}));
    }

    public ActionReport gameWon() {
        this.shouldDestroyGame = true;
        class_5250 result = class_2561.method_43469((String)"game.minopp.play.game_won", (Object[])new Object[]{this.initiator.name});
        for (CardPlayer player : this.game.players) {
            if (player.equals(this.initiator)) continue;
            result = result.method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"game.minopp.play.game_nearly_won", (Object[])new Object[]{player.name, player.hand.size()}));
        }
        return this.state((class_2561)result);
    }

    public ActionReport panic(class_2561 message) {
        this.shouldDestroyGame = true;
        return this.state(message);
    }
}

