/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.entity;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.AutoPlayer;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.gui.AutoPlayerScreen;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.network.S2CAutoPlayerScreenPacket;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;

public class EntityAutoPlayer
extends class_1309 {
    private final class_2371<class_1799> armorItems = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public CardPlayer cardPlayer;
    public class_2338 tablePos = null;
    private boolean noPush;
    private long lastTickGameTime = 0L;
    private boolean isThinking = false;
    private long thinkingFinishTime = 0L;
    private long gameEndTime = 0L;
    public final AutoPlayer autoPlayer = new AutoPlayer();
    public Optional<GameProfile> clientSkinGameProfile = Optional.empty();
    public String clientSkinGameProfileValidFor = "";
    private static final class_2940<class_1799> HAND_STACK = class_2945.method_12791(EntityAutoPlayer.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> ACTIVE = class_2945.method_12791(EntityAutoPlayer.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> SKIN = class_2945.method_12791(EntityAutoPlayer.class, (class_2941)class_2943.field_13326);

    public EntityAutoPlayer(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (!this.clientSkinGameProfileValidFor.equals(this.field_6011.method_12789(SKIN))) {
                this.clientSkinGameProfileValidFor = (String)this.field_6011.method_12789(SKIN);
                if (this.clientSkinGameProfileValidFor.isEmpty()) {
                    this.clientSkinGameProfile = Optional.empty();
                    return;
                }
                try {
                    UUID skinAsUUID = UUID.fromString(this.clientSkinGameProfileValidFor);
                    GameProfile profile = new GameProfile(skinAsUUID, null);
                    class_2631.method_11335((GameProfile)profile, profileNew -> {
                        this.clientSkinGameProfile = Optional.of(profileNew);
                    });
                }
                catch (IllegalArgumentException e) {
                    GameProfile profile = new GameProfile(null, this.clientSkinGameProfileValidFor);
                    class_2631.method_11335((GameProfile)profile, profileNew -> {
                        this.clientSkinGameProfile = Optional.of(profileNew);
                    });
                }
            }
            return;
        }
        if (!this.getActive()) {
            this.tablePos = null;
            this.method_6025(10.0f);
            return;
        }
        if (this.autoPlayer.aiNoDelay < 2 && this.method_37908().method_8510() - this.lastTickGameTime < 10L) {
            return;
        }
        this.lastTickGameTime = this.method_37908().method_8510();
        if (this.tablePos == null) {
            boolean tableFound = false;
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        class_2338 tobeTablePos = this.method_24515().method_10069(dx, 0, dz);
                        class_2680 tobeTableState = this.method_37908().method_8320(tobeTablePos);
                        if (!tobeTableState.method_27852(Mino.BLOCK_MINO_TABLE.get())) continue;
                        class_2338 corePos = BlockMinoTable.getCore(tobeTableState, tobeTablePos);
                        class_2586 blockEntity = this.method_37908().method_8321(corePos);
                        if (!(blockEntity instanceof BlockEntityMinoTable)) continue;
                        BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
                        if (tableEntity.game != null) continue;
                        String playerName = this.method_16914() ? this.method_5797().getString() : "MinoBot #" + new Random().nextInt(100, 1000);
                        this.cardPlayer = new CardPlayer(this.field_6021, playerName);
                        tableEntity.joinPlayerToTable(this.cardPlayer, this.method_19538());
                        this.tablePos = corePos;
                        tableFound = true;
                        class_1799 handStack = new class_1799((class_1935)Mino.ITEM_HAND_CARDS.get());
                        ItemHandCards.setCardGameBinding(handStack, this.tablePos, this.cardPlayer.uuid);
                        this.field_6011.method_12778(HAND_STACK, (Object)handStack);
                        break;
                    }
                    if (tableFound) break;
                }
                if (tableFound) break;
            }
            if (!tableFound) {
                this.setActive(false);
                return;
            }
        }
        this.method_5702(class_2183.class_2184.field_9851, class_243.method_49273((class_2382)this.tablePos, (double)1.0, (double)1.0, (double)1.0));
        class_2586 blockEntity = this.method_37908().method_8321(this.tablePos);
        if (blockEntity instanceof BlockEntityMinoTable) {
            BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
            if (tableEntity.game != null) {
                this.method_6025(10.0f);
                if (tableEntity.game.players.get(tableEntity.game.currentPlayerIndex).equals(this.cardPlayer)) {
                    if (this.autoPlayer.aiNoDelay > 0) {
                        this.isThinking = false;
                    } else {
                        if (!this.isThinking) {
                            this.thinkingFinishTime = tableEntity.game.currentPlayerPhase == CardGame.PlayerActionPhase.DISCARD_DRAWN ? this.method_37908().method_8510() + (long)new Random().nextInt(10, 20) : this.method_37908().method_8510() + (long)new Random().nextInt(10, 50);
                            this.isThinking = true;
                            return;
                        }
                        if (this.method_37908().method_8510() >= this.thinkingFinishTime) {
                            this.isThinking = false;
                        } else {
                            return;
                        }
                    }
                    CardPlayer realPlayer = tableEntity.game.deAmputate(this.cardPlayer);
                    ActionReport result = this.autoPlayer.playAtGame(tableEntity.game, realPlayer, this.method_5682());
                    tableEntity.handleActionResult(result, realPlayer, null);
                    this.gameEndTime = -1L;
                } else {
                    this.isThinking = false;
                }
            } else {
                if (this.gameEndTime == -1L) {
                    this.gameEndTime = this.method_37908().method_8510() + 100L;
                } else if (this.method_37908().method_8510() - this.gameEndTime <= 60L) {
                    if (this.method_24828()) {
                        this.method_6043();
                    }
                } else if (this.autoPlayer.aiStartGame && tableEntity.getPlayersList().size() >= 2) {
                    tableEntity.startGame(this.cardPlayer);
                }
                if (!tableEntity.getPlayersList().stream().anyMatch(p -> p.equals(this.cardPlayer))) {
                    this.cardPlayer = null;
                    this.field_6011.method_12778(HAND_STACK, (Object)class_1799.field_8037);
                    this.tablePos = null;
                }
            }
        } else {
            this.cardPlayer = null;
            this.field_6011.method_12778(HAND_STACK, (Object)class_1799.field_8037);
            this.tablePos = null;
        }
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.method_37908().field_9236) {
            if (player.method_5687(2) && player.method_5715()) {
                return class_1269.field_5812;
            }
            if (this.getActive() && !player.method_5715()) {
                return class_1269.field_5812;
            }
        } else {
            if (player.method_5687(2) && player.method_5715()) {
                S2CAutoPlayerScreenPacket.sendS2C((class_3222)player, this);
                return class_1269.field_5812;
            }
            if (!this.getActive() && !player.method_5715()) {
                this.setActive(true);
                return class_1269.field_5812;
            }
        }
        return super.method_5688(player, hand);
    }

    @NotNull
    public Iterable<class_1799> method_5661() {
        return this.armorItems;
    }

    @NotNull
    public Iterable<class_1799> method_5877() {
        return List.of((class_1799)this.field_6011.method_12789(HAND_STACK), class_1799.field_8037);
    }

    @NotNull
    public class_1799 method_6118(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return (class_1799)this.field_6011.method_12789(HAND_STACK);
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    @NotNull
    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public boolean method_5655() {
        return true;
    }

    public boolean method_5679(class_1282 source) {
        return this.method_31481() || !source.method_48789(class_8103.field_42242);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.tablePos != null) {
            compound.method_10544("TablePos", this.tablePos.method_10063());
        }
        if (this.cardPlayer != null) {
            compound.method_10566("CardPlayer", (class_2520)this.cardPlayer.toTag());
        }
        if (!((class_1799)this.field_6011.method_12789(HAND_STACK)).method_7960()) {
            compound.method_10566("HandStack", (class_2520)((class_1799)this.field_6011.method_12789(HAND_STACK)).method_7953(new class_2487()));
        }
        this.writeConfigToTag(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.tablePos = compound.method_10573("TablePos", 4) ? class_2338.method_10092((long)compound.method_10537("TablePos")) : null;
        this.cardPlayer = compound.method_10573("CardPlayer", 10) ? new CardPlayer(compound.method_10562("CardPlayer")) : null;
        this.readConfigFromTag(compound);
        if (this.tablePos != null && this.cardPlayer != null) {
            class_1799 handStack = new class_1799((class_1935)Mino.ITEM_HAND_CARDS.get());
            ItemHandCards.setCardGameBinding(handStack, this.tablePos, this.cardPlayer.uuid);
            this.field_6011.method_12778(HAND_STACK, (Object)handStack);
        } else {
            this.field_6011.method_12778(HAND_STACK, (Object)class_1799.field_8037);
        }
    }

    public boolean method_5810() {
        return !this.noPush;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HAND_STACK, (Object)class_1799.field_8037);
        this.field_6011.method_12784(ACTIVE, (Object)false);
        this.field_6011.method_12784(SKIN, (Object)"");
    }

    public static class_5132 createAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23718, 1.0).method_26866();
    }

    public boolean getActive() {
        return (Boolean)this.field_6011.method_12789(ACTIVE);
    }

    public void setActive(boolean active) {
        this.field_6011.method_12778(ACTIVE, (Object)active);
    }

    public boolean getNoPush() {
        return this.noPush;
    }

    public void setNoPush(boolean noPush) {
        this.noPush = noPush;
    }

    public String getSkin() {
        return (String)this.field_6011.method_12789(SKIN);
    }

    public void setSkin(String skin) {
        this.field_6011.method_12778(SKIN, (Object)skin);
    }

    public class_2487 writeConfigToTag() {
        class_2487 tag = new class_2487();
        this.writeConfigToTag(tag);
        return tag;
    }

    public void writeConfigToTag(class_2487 tag) {
        tag.method_10556("Active", this.getActive());
        tag.method_10556("NoPush", this.getNoPush());
        tag.method_10582("Skin", this.getSkin());
        tag.method_10566("AI", (class_2520)this.autoPlayer.toConfigNbt());
        class_2561 component = this.method_5797();
        if (component != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)component));
        }
    }

    public void readConfigFromTag(class_2487 tag) {
        this.setActive(tag.method_10577("Active"));
        this.setNoPush(tag.method_10577("NoPush"));
        this.setSkin(tag.method_10558("Skin"));
        this.autoPlayer.useConfigNbt(tag.method_10562("AI"));
        if (tag.method_10573("CustomName", 8)) {
            try {
                this.method_5665((class_2561)class_2561.class_2562.method_10877((String)tag.method_10558("CustomName")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class Client {
        private Client() {
        }

        public static void openAutoPlayerScreen(EntityAutoPlayer autoPlayer) {
            class_310.method_1551().method_1507(AutoPlayerScreen.create(autoPlayer, class_310.method_1551().field_1755));
        }
    }
}

