/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.block;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.MinoClient;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.gui.SeatControlScreen;
import cn.zbx1425.minopp.gui.TurnDeadMan;
import cn.zbx1425.minopp.gui.WildSelectionScreen;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.mixin.KeyMappingAccessor;
import cn.zbx1425.minopp.network.C2SPlayCardPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3675;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockMinoTable
extends class_2248
implements class_2343 {
    public static final class_2754<TablePartType> PART = class_2754.method_11850((String)"part", TablePartType.class);
    private static final class_265 VOXEL_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.9, (double)16.0);

    public BlockMinoTable() {
        super(class_4970.class_2251.method_9637().method_9632(2.0f).method_22488());
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hitResult) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7960()) {
            return this.useWithoutItem(blockState, level, blockPos, player, hitResult);
        }
        if (level.field_9236 && itemStack.method_31574((class_1792)Mino.ITEM_HAND_CARDS.get())) {
            class_2338 corePos = BlockMinoTable.getCore(blockState, blockPos);
            ItemHandCards.CardGameBinding gameBinding = ItemHandCards.getCardGameBinding(itemStack);
            int handIndex = ItemHandCards.getClientHandIndex(itemStack);
            CardPlayer playerWithoutHand = ItemHandCards.getCardPlayer(player);
            class_2586 blockEntity = level.method_8321(corePos);
            if (blockEntity instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
                if (tableEntity.game != null) {
                    if (gameBinding == null || !gameBinding.tablePos().equals((Object)corePos)) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"game.minopp.play.no_player"), true);
                        return class_1269.field_5814;
                    }
                    TurnDeadMan.pedal();
                    CardPlayer realPlayer = tableEntity.game.deAmputate(playerWithoutHand);
                    if (realPlayer == null) {
                        return class_1269.field_5814;
                    }
                    if (Client.isCursorHittingPile()) {
                        C2SPlayCardPacket.Client.sendPlayNoCardC2S(corePos, playerWithoutHand);
                    } else {
                        Card selectedCard = realPlayer.hand.get(class_3532.method_15340((int)handIndex, (int)0, (int)(realPlayer.hand.size() - 1)));
                        if (selectedCard.suit == Card.Suit.WILD) {
                            Client.openWildSelectionScreen(corePos, playerWithoutHand, selectedCard, Client.isShoutModifierHeld());
                        } else {
                            C2SPlayCardPacket.Client.sendPlayCardC2S(corePos, playerWithoutHand, selectedCard, null, Client.isShoutModifierHeld());
                        }
                    }
                    return class_1269.field_5812;
                }
            }
        }
        return super.method_9534(blockState, level, blockPos, player, hand, hitResult);
    }

    @NotNull
    protected class_1269 useWithoutItem(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        class_2338 corePos = BlockMinoTable.getCore(blockState, blockPos);
        class_2586 blockEntity = level.method_8321(corePos);
        if (blockEntity instanceof BlockEntityMinoTable) {
            BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
            CardPlayer cardPlayer = ItemHandCards.getCardPlayer(player);
            if (tableEntity.demo) {
                player.method_7353((class_2561)class_2561.method_43471((String)"game.minopp.play.table_in_demo"), true);
                return class_1269.field_5814;
            }
            if (level.field_9236) {
                Client.openSeatControlScreen(corePos);
                return class_1269.field_5812;
            }
            if (tableEntity.game == null && !player.method_21823()) {
                tableEntity.joinPlayerToTable(cardPlayer, player.method_19538());
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_2338 firstPartPos = blockPlaceContext.method_8037();
        class_1937 level = blockPlaceContext.method_8045();
        for (int i = 0; i < 4; ++i) {
            boolean isPlaceable;
            TablePartType part = TablePartType.values()[i];
            class_2338 thisPartPos = firstPartPos.method_10069(part.xOff, 0, part.zOff);
            boolean bl = isPlaceable = level.method_8320(thisPartPos).method_26166(blockPlaceContext) && level.method_8621().method_11952(thisPartPos);
            if (isPlaceable) continue;
            return null;
        }
        return (class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)TablePartType.X_LESS_Z_LESS));
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 livingEntity, class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        if (!level.field_9236) {
            for (int i = 1; i < 4; ++i) {
                TablePartType thisPart = TablePartType.values()[i];
                class_2338 thisPartPos = blockPos.method_10069(thisPart.xOff, 0, thisPart.zOff);
                level.method_8652(thisPartPos, (class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)thisPart)), 19);
            }
        }
    }

    @NotNull
    public class_2680 method_9559(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        class_2338 firstPartPos = BlockMinoTable.getCore(blockState, blockPos);
        for (int i = 0; i < 4; ++i) {
            TablePartType thisPart = TablePartType.values()[i];
            class_2338 thisPartPos = firstPartPos.method_10069(thisPart.xOff, 0, thisPart.zOff);
            if (levelAccessor.method_8320(thisPartPos).method_27852((class_2248)this)) continue;
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void method_9576(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        if (!level.field_9236 && player.method_7337()) {
            class_2338 firstPartPos = BlockMinoTable.getCore(blockState, blockPos);
            for (int i = 0; i < 4; ++i) {
                TablePartType thisPart = TablePartType.values()[i];
                class_2338 thisPartPos = firstPartPos.method_10069(thisPart.xOff, 0, thisPart.zOff);
                level.method_8652(thisPartPos, class_2246.field_10124.method_9564(), 35);
            }
        }
        super.method_9576(level, blockPos, blockState, player);
    }

    public static class_2338 getCore(class_2680 blockState, class_2338 blockPos) {
        if (!blockState.method_27852(Mino.BLOCK_MINO_TABLE.get())) {
            return blockPos;
        }
        TablePartType part = (TablePartType)((Object)blockState.method_11654(PART));
        return blockPos.method_10069(-part.xOff, 0, -part.zOff);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART});
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        if (blockState.method_11654(PART) != TablePartType.X_LESS_Z_LESS) {
            return null;
        }
        return new BlockEntityMinoTable(blockPos, blockState);
    }

    public float method_9575(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return 1.0f;
    }

    public boolean method_9579(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return true;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return VOXEL_SHAPE;
    }

    public static class Client {
        public static void openWildSelectionScreen(class_2338 corePos, CardPlayer player, Card selectedCard, boolean shout) {
            class_310.method_1551().method_1507((class_437)new WildSelectionScreen(corePos, player, selectedCard, shout));
        }

        public static void openSeatControlScreen(class_2338 corePos) {
            class_310.method_1551().method_1507((class_437)new SeatControlScreen(corePos));
        }

        public static boolean isShoutModifierHeld() {
            class_3675.class_306 boundKey = ((KeyMappingAccessor)MinoClient.KEY_SHOUT_MODIFIER.get()).getKey();
            return boundKey.method_1442() == class_3675.class_307.field_1668 && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)boundKey.method_1444());
        }

        @Nullable
        public static class_2338 getCursorPickedGame() {
            class_2338 potentialTablePos;
            class_239 hitResult = class_310.method_1551().field_1765;
            class_638 level = class_310.method_1551().field_1687;
            if (hitResult.method_17783() == class_239.class_240.field_1332 && level.method_8320(potentialTablePos = ((class_3965)hitResult).method_17777()).method_27852(Mino.BLOCK_MINO_TABLE.get())) {
                return BlockMinoTable.getCore(level.method_8320(potentialTablePos), potentialTablePos);
            }
            return null;
        }

        public static boolean isCursorHittingPile() {
            class_2338 gamePos = Client.getCursorPickedGame();
            if (gamePos == null) {
                return false;
            }
            class_638 level = class_310.method_1551().field_1687;
            class_2586 class_25862 = level.method_8321(gamePos);
            if (class_25862 instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)class_25862;
                if (tableEntity.game == null) {
                    return false;
                }
                class_238 pileAabb = Client.getPileAabb(tableEntity);
                class_1297 cameraEntity = class_310.method_1551().method_1560();
                float partialTicks = class_310.method_1551().method_1488();
                float hitDistance = 20.0f;
                class_243 rayBegin = cameraEntity.method_5836(partialTicks);
                class_243 rayDir = cameraEntity.method_5828(partialTicks);
                class_243 rayEnd = rayBegin.method_1031(rayDir.field_1352 * (double)hitDistance, rayDir.field_1351 * (double)hitDistance, rayDir.field_1350 * (double)hitDistance);
                return pileAabb.method_996(gamePos).method_992(rayBegin, rayEnd).isPresent();
            }
            return true;
        }

        public static class_238 getPileAabb(BlockEntityMinoTable tableEntity) {
            if (tableEntity.game == null) {
                return new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            return class_238.method_30048((class_243)new class_243(0.5, 0.94, 0.5), (double)0.3, (double)0.0625, (double)0.5).method_1012(0.0, Math.ceil((float)tableEntity.game.deck.size() / 5.0f) * 0.0625 * (double)0.3f, 0.0);
        }
    }

    public static enum TablePartType implements class_3542
    {
        X_LESS_Z_LESS,
        X_LESS_Z_MORE,
        X_MORE_Z_LESS,
        X_MORE_Z_MORE;

        public final int xOff = this.ordinal() / 2;
        public final int zOff = this.ordinal() % 2;

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase();
        }
    }
}

