/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.block;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.effect.EffectEvent;
import cn.zbx1425.minopp.effect.SeatActionTakenEffectEvent;
import cn.zbx1425.minopp.game.ActionMessage;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.network.S2CActionEphemeralPacket;
import cn.zbx1425.minopp.network.S2CEffectListPacket;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityMinoTable
extends class_2586 {
    public Map<class_2350, CardPlayer> players = new HashMap<class_2350, CardPlayer>();
    public CardGame game = null;
    public ActionMessage state = ActionMessage.NO_GAME;
    public List<Pair<ActionMessage, Long>> clientMessageList = new ArrayList<Pair<ActionMessage, Long>>();
    public class_1799 award = class_1799.field_8037;
    public boolean demo = false;
    public static final List<class_2350> PLAYER_ORDER = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039);
    private static final int PLAYER_RANGE = 20;

    public BlockEntityMinoTable(class_2338 blockPos, class_2680 blockState) {
        super(Mino.BLOCK_ENTITY_TYPE_MINO_TABLE.get(), blockPos, blockState);
        for (class_2350 direction : PLAYER_ORDER) {
            this.players.put(direction, null);
        }
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        class_2487 playersTag = new class_2487();
        for (Map.Entry<class_2350, CardPlayer> entry : this.players.entrySet()) {
            if (entry.getValue() == null) continue;
            playersTag.method_10566(entry.getKey().method_15434(), (class_2520)entry.getValue().toTag());
        }
        compoundTag.method_10566("players", (class_2520)playersTag);
        if (this.game != null) {
            compoundTag.method_10566("game", (class_2520)this.game.toTag());
        }
        compoundTag.method_10566("state", (class_2520)this.state.toTag());
        if (!this.award.method_7960()) {
            compoundTag.method_10566("award", (class_2520)this.award.method_7953(new class_2487()));
        }
        compoundTag.method_10556("demo", this.demo);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        class_2487 playersTag = compoundTag.method_10562("players");
        for (class_2350 direction : PLAYER_ORDER) {
            if (playersTag.method_10545(direction.method_15434())) {
                this.players.put(direction, new CardPlayer(playersTag.method_10562(direction.method_15434())));
                continue;
            }
            this.players.put(direction, null);
        }
        CardGame previousGame = this.game;
        this.game = compoundTag.method_10545("game") ? new CardGame(compoundTag.method_10562("game")) : null;
        ActionMessage newState = new ActionMessage(compoundTag.method_10562("state"));
        if (!newState.equals(this.state)) {
            if (previousGame == null && this.game != null) {
                this.clientMessageList.clear();
            } else {
                this.clientMessageList.add((Pair<ActionMessage, Long>)new Pair((Object)this.state, (Object)(System.currentTimeMillis() + 16000L)));
            }
            this.state = newState;
            this.clientMessageList.removeIf(entry -> ((ActionMessage)entry.getFirst()).type() == ActionMessage.Type.FAIL);
        }
        this.award = compoundTag.method_10573("award", 10) ? class_1799.method_7915((class_2487)compoundTag.method_10562("award")) : class_1799.field_8037;
        this.demo = compoundTag.method_10577("demo");
    }

    public List<CardPlayer> getPlayersList() {
        ArrayList<CardPlayer> playersList = new ArrayList<CardPlayer>();
        for (class_2350 direction : PLAYER_ORDER) {
            if (this.players.get(direction) == null) continue;
            playersList.add(this.players.get(direction));
        }
        return playersList;
    }

    public List<class_2350> getEmptyDirections() {
        ArrayList<class_2350> emptyDirections = new ArrayList<class_2350>();
        for (class_2350 direction : PLAYER_ORDER) {
            if (this.players.get(direction) != null) continue;
            emptyDirections.add(direction);
        }
        return emptyDirections;
    }

    public void joinPlayerToTable(CardPlayer cardPlayer, class_243 playerPos) {
        if (this.game != null) {
            return;
        }
        class_2338 centerPos = this.method_11016().method_10069(1, 0, 1);
        class_243 playerOffset = playerPos.method_1023((double)centerPos.method_10263(), (double)centerPos.method_10264(), (double)centerPos.method_10260());
        class_2350 playerDirection = class_2350.method_10150((double)(class_3532.method_15349((double)playerOffset.field_1350, (double)playerOffset.field_1352) * 180.0 / Math.PI - 90.0));
        for (class_2350 checkDir : this.players.keySet()) {
            if (!cardPlayer.equals(this.players.get(checkDir))) continue;
            this.players.put(checkDir, null);
        }
        this.players.put(playerDirection, cardPlayer);
        this.sync();
    }

    public void startGame(CardPlayer initiator) {
        if (this.game != null) {
            return;
        }
        List<CardPlayer> playerList = this.getPlayersList();
        if (playerList.size() < 2) {
            return;
        }
        class_238 searchArea = class_238.method_30048((class_243)class_243.method_49273((class_2382)this.method_11016(), (double)1.0, (double)1.0, (double)1.0), (double)20.0, (double)20.0, (double)20.0);
        for (CardPlayer cardPlayer : playerList) {
            boolean playerFound = false;
            for (class_1297 entity : this.field_11863.method_8335(null, searchArea)) {
                if (entity instanceof class_1657) {
                    class_1657 mcPlayer = (class_1657)entity;
                    if (cardPlayer.uuid.equals(mcPlayer.method_7334().getId())) {
                        class_1799 handCard = new class_1799((class_1935)Mino.ITEM_HAND_CARDS.get());
                        ItemHandCards.setCardGameBinding(handCard, this.method_11016(), cardPlayer.uuid);
                        if (class_1661.method_7380((int)mcPlayer.method_31548().field_7545) && mcPlayer.method_31548().method_7391().method_7960()) {
                            mcPlayer.method_31548().method_5447(mcPlayer.method_31548().field_7545, handCard);
                            playerFound = true;
                        } else {
                            class_1542 itemEntity;
                            boolean addSuccessful = mcPlayer.method_31548().method_7394(handCard);
                            if (!addSuccessful && (itemEntity = mcPlayer.method_7328(handCard, false)) != null) {
                                itemEntity.method_6975();
                                itemEntity.method_48349(mcPlayer.method_5667());
                            }
                            mcPlayer.method_7353((class_2561)class_2561.method_43471((String)"game.minopp.play.hand_card_in_inventory"), false);
                            playerFound = true;
                        }
                    }
                } else if (cardPlayer.uuid.equals(entity.method_5667())) {
                    playerFound = true;
                }
                if (!playerFound) continue;
                break;
            }
            if (playerFound) continue;
            this.destroyGame(initiator);
            this.state = ActionReport.builder((CardPlayer)initiator).panic((class_2561)class_2561.method_43469((String)"game.minopp.play.player_unavailable", (Object[])new Object[]{cardPlayer.name})).state;
            return;
        }
        this.players.values().forEach(p -> {
            if (p != null) {
                p.hand.clear();
                p.hasShoutedMino = false;
            }
        });
        this.game = new CardGame(this.getPlayersList());
        this.state = this.game.initiate((CardPlayer)initiator, (int)7).state;
        this.sendSeatActionTakenToAll();
        this.sync();
    }

    public void destroyGame(CardPlayer initiator) {
        if (this.game != null) {
            this.sendSeatActionTakenToAll();
        }
        this.game = null;
        for (class_1657 mcPlayer : this.field_11863.method_18456()) {
            for (class_1799 invItem : mcPlayer.method_31548().field_7547) {
                ItemHandCards.CardGameBinding binding;
                if (!invItem.method_31574((class_1792)Mino.ITEM_HAND_CARDS.get()) || (binding = ItemHandCards.getCardGameBinding(invItem)) == null || !binding.tablePos().equals((Object)this.method_11016())) continue;
                mcPlayer.method_31548().method_7378(invItem);
            }
        }
        for (CardPlayer cardPlayer : this.players.values()) {
            class_1297 entity;
            if (cardPlayer == null || !((entity = ((class_3218)this.field_11863).method_14190(cardPlayer.uuid)) instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            for (class_1268 hand : class_1268.values()) {
                class_1799 stack = livingEntity.method_5998(hand);
                if (!stack.method_31574((class_1792)Mino.ITEM_HAND_CARDS.get())) continue;
                livingEntity.method_6122(hand, class_1799.field_8037);
            }
        }
        this.players.values().forEach(p -> {
            if (p != null) {
                p.hand.clear();
                p.hasShoutedMino = false;
            }
        });
        this.state = ActionReport.builder((CardPlayer)initiator).gameDestroyed().state;
        this.sync();
    }

    public void resetSeats(CardPlayer initiator) {
        this.sendSeatActionTakenToAll();
        this.players.replaceAll((d, v) -> null);
        this.state = ActionReport.builder((CardPlayer)initiator).panic((class_2561)class_2561.method_43469((String)"game.minopp.play.seats_reset", (Object[])new Object[]{initiator.name})).state;
        this.sync();
    }

    public void handleActionResult(ActionReport result, CardPlayer cardPlayer, class_3222 player) {
        if (result != null) {
            if (result.shouldDestroyGame) {
                this.destroyGame(cardPlayer);
            }
            if (result.state != null) {
                this.state = result.state;
            }
            for (ActionMessage message : result.messages) {
                switch (message.type()) {
                    case FAIL: {
                        if (player == null) break;
                        S2CActionEphemeralPacket.sendS2C(player, this.method_11016(), message);
                        break;
                    }
                    case MESSAGE_ALL: {
                        this.sendMessageToAll(message);
                    }
                }
            }
            if (!result.effects.isEmpty()) {
                MinecraftServer server = ((class_3218)this.field_11863).method_8503();
                class_2338 tableCenterPos = this.method_11016().method_10069(1, 0, 1);
                for (EffectEvent effect : result.effects) {
                    effect.summonServer((class_3218)this.field_11863, tableCenterPos, this);
                }
                for (class_3222 serverPlayer : server.method_3760().method_14571()) {
                    if (serverPlayer.method_37908().method_27983() != this.field_11863.method_27983() || !(serverPlayer.method_19538().method_1025(class_243.method_24953((class_2382)tableCenterPos)) <= 256.0)) continue;
                    boolean playerPartOfGame = this.getPlayersList().stream().anyMatch(p -> p.uuid.equals(serverPlayer.method_7334().getId()));
                    S2CEffectListPacket.sendS2C(serverPlayer, result.effects, tableCenterPos, playerPartOfGame);
                }
            }
            this.sync();
        }
    }

    private void sendMessageToAll(ActionMessage message) {
        for (CardPlayer player : this.getPlayersList()) {
            class_1657 mcPlayer = this.field_11863.method_18470(player.uuid);
            if (mcPlayer == null) continue;
            S2CActionEphemeralPacket.sendS2C((class_3222)mcPlayer, this.method_11016(), message);
        }
    }

    private void sendSeatActionTakenToAll() {
        for (CardPlayer player : this.getPlayersList()) {
            class_1657 mcPlayer = this.field_11863.method_18470(player.uuid);
            class_2338 tableCenterPos = this.method_11016().method_10069(1, 0, 1);
            List<EffectEvent> events = List.of(new SeatActionTakenEffectEvent(player.uuid));
            if (mcPlayer == null) continue;
            S2CEffectListPacket.sendS2C((class_3222)mcPlayer, events, tableCenterPos, true);
        }
    }

    public void sync() {
        this.method_5431();
        class_2680 blockState = this.field_11863.method_8320(this.method_11016());
        this.field_11863.method_8413(this.method_11016(), blockState, blockState, 2);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

