/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp;

import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.entity.EntityAutoPlayer;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.item.ItemCoupon;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.network.C2SAutoPlayerConfigPacket;
import cn.zbx1425.minopp.network.C2SPlayCardPacket;
import cn.zbx1425.minopp.network.C2SSeatControlPacket;
import cn.zbx1425.minopp.network.S2CActionEphemeralPacket;
import cn.zbx1425.minopp.network.S2CAutoPlayerScreenPacket;
import cn.zbx1425.minopp.network.S2CEffectListPacket;
import cn.zbx1425.minopp.platform.GroupedItem;
import cn.zbx1425.minopp.platform.RegistriesWrapper;
import cn.zbx1425.minopp.platform.RegistryObject;
import cn.zbx1425.minopp.platform.ServerPlatform;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mino {
    public static final String MOD_ID = "minopp";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mino++");
    public static final RegistryObject<class_2248> BLOCK_MINO_TABLE = new RegistryObject<class_2248>(BlockMinoTable::new);
    public static final RegistryObject<class_2591<BlockEntityMinoTable>> BLOCK_ENTITY_TYPE_MINO_TABLE = new RegistryObject<class_2591>(() -> ServerPlatform.createBlockEntityType(BlockEntityMinoTable::new, BLOCK_MINO_TABLE.get()));
    public static final RegistryObject<GroupedItem> ITEM_HAND_CARDS = new RegistryObject<GroupedItem>(ItemHandCards::new);
    public static final RegistryObject<GroupedItem> ITEM_COUPON = new RegistryObject<GroupedItem>(ItemCoupon::new);
    public static final RegistryObject<class_1299<EntityAutoPlayer>> ENTITY_AUTO_PLAYER = new RegistryObject<class_1299>(() -> class_1299.class_1300.method_5903(EntityAutoPlayer::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 1.8f).method_5905("mino_auto_player"));
    public static final RegistryObject<GroupedItem> ITEM_HAND_CARDS_MODEL_PLACEHOLDER = new RegistryObject<GroupedItem>(ItemHandCards::new);

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static void init(RegistriesWrapper registries) {
        class_5321 FUNCTIONAL_BLOCKS = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960("functional_blocks"));
        registries.registerBlockAndItem("mino_table", BLOCK_MINO_TABLE, (class_5321<class_1761>)FUNCTIONAL_BLOCKS);
        registries.registerBlockEntityType("mino_table", BLOCK_ENTITY_TYPE_MINO_TABLE);
        registries.registerItem("hand_cards", ITEM_HAND_CARDS);
        registries.registerItem("hand_cards_model_placeholder", ITEM_HAND_CARDS_MODEL_PLACEHOLDER);
        registries.registerItem("coupon", ITEM_COUPON);
        registries.registerEntityType("mino_auto_player", ENTITY_AUTO_PLAYER);
        ServerPlatform.registerPacket(S2CActionEphemeralPacket.ID);
        ServerPlatform.registerPacket(S2CEffectListPacket.ID);
        ServerPlatform.registerPacket(S2CAutoPlayerScreenPacket.ID);
        ServerPlatform.registerNetworkReceiver(C2SPlayCardPacket.ID, C2SPlayCardPacket::handleC2S);
        ServerPlatform.registerNetworkReceiver(C2SSeatControlPacket.ID, C2SSeatControlPacket::handleC2S);
        ServerPlatform.registerNetworkReceiver(C2SAutoPlayerConfigPacket.ID, C2SAutoPlayerConfigPacket::handleC2S);
    }

    public static boolean onServerChatMessage(String rawText, class_3222 sender) {
        String normalized = rawText.toLowerCase().replace(" ", "").replace("!", "").replace("\uff01", "");
        if (normalized.equals("mino") || normalized.equals("uno") || normalized.equals(MOD_ID)) {
            class_2338 gamePos = ItemHandCards.getHandCardGamePos((class_1657)sender);
            if (gamePos == null) {
                return false;
            }
            class_2586 class_25862 = sender.method_37908().method_8321(gamePos);
            if (class_25862 instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)class_25862;
                if (tableEntity.game == null) {
                    return false;
                }
                CardPlayer cardPlayer = tableEntity.game.deAmputate(ItemHandCards.getCardPlayer((class_1657)sender));
                if (cardPlayer == null) {
                    return false;
                }
                ActionReport result = tableEntity.game.shoutMino(cardPlayer);
                tableEntity.handleActionResult(result, cardPlayer, sender);
                return true;
            }
        }
        return false;
    }

    public static void onPlayerAttackEntity(class_1297 targetMaybePlayer, class_1657 srcPlayer) {
        if (!srcPlayer.method_37908().field_9236) {
            return;
        }
        class_2338 gamePos = ItemHandCards.getHandCardGamePos(srcPlayer);
        if (gamePos == null) {
            return;
        }
        class_2586 class_25862 = srcPlayer.method_37908().method_8321(gamePos);
        if (class_25862 instanceof BlockEntityMinoTable) {
            UUID targetId;
            BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)class_25862;
            if (tableEntity.game == null) {
                return;
            }
            if (targetMaybePlayer instanceof class_1657) {
                class_1657 targetPlayer = (class_1657)targetMaybePlayer;
                targetId = ItemHandCards.getCardPlayer((class_1657)targetPlayer).uuid;
            } else {
                targetId = targetMaybePlayer.method_5667();
            }
            C2SPlayCardPacket.Client.sendDoubtMinoC2S(gamePos, ItemHandCards.getCardPlayer(srcPlayer), targetId);
        }
    }
}

