/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled.item;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.mini_scaled.ScaleBoxGeneration;
import qouteall.mini_scaled.ScaleBoxManipulation;
import qouteall.mini_scaled.ScaleBoxRecord;

public class ScaleBoxEntranceItem
extends class_1792 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScaleBoxEntranceItem.class);
    public static final ScaleBoxEntranceItem instance = new ScaleBoxEntranceItem(new class_1792.class_1793());
    private static final class_2561 spaceText = class_2561.method_43470((String)" ");

    public static void init() {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("mini_scaled:scale_box_item"), (Object)((Object)instance));
    }

    public ScaleBoxEntranceItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        return ScaleBoxManipulation.onRightClickUsingEntrance(context);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        ItemInfo itemInfo = new ItemInfo(stack.method_7948());
        tooltip.add((class_2561)class_2561.method_43471((String)"mini_scaled.color").method_10852((class_2561)ScaleBoxEntranceItem.getColorText(itemInfo.color).method_27692(class_124.field_1065)));
        tooltip.add((class_2561)class_2561.method_43471((String)"mini_scaled.scale").method_10852((class_2561)class_2561.method_43470((String)Integer.toString(itemInfo.scale)).method_27692(class_124.field_1075)));
        if (itemInfo.ownerNameCache != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"mini_scaled.owner").method_10852((class_2561)class_2561.method_43470((String)itemInfo.ownerNameCache).method_27692(class_124.field_1054)));
        }
    }

    public static void registerCreativeInventory(Consumer<class_1799> func) {
        for (int scale : ScaleBoxGeneration.supportedScales) {
            for (class_1767 dyeColor : class_1767.values()) {
                class_1799 itemStack = new class_1799((class_1935)instance);
                ItemInfo itemInfo = new ItemInfo(scale, dyeColor);
                itemInfo.writeToTag(itemStack.method_7948());
                func.accept(itemStack);
            }
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        ItemInfo itemInfo = new ItemInfo(stack.method_7948());
        class_1767 color = itemInfo.color;
        class_5250 result = class_2561.method_43471((String)"item.mini_scaled.scale_box_item").method_10852(spaceText).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(itemInfo.scale)));
        if (itemInfo.ownerNameCache != null) {
            result = result.method_10852(spaceText).method_10852((class_2561)class_2561.method_43471((String)"mini_scaled.owner")).method_10852((class_2561)class_2561.method_43470((String)itemInfo.ownerNameCache));
        }
        return result;
    }

    public static class_5250 getColorText(class_1767 color) {
        return class_2561.method_43471((String)("color.minecraft." + color.method_7792()));
    }

    @Nullable
    public static class_1799 boxIdToItem(int boxId) {
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.get().getEntryById(boxId);
        if (entry == null) {
            LOGGER.info("invalid boxId for item {}", (Object)boxId);
            return null;
        }
        class_1799 itemStack = new class_1799((class_1935)instance);
        new ItemInfo(entry.scale, entry.color, entry.ownerId, entry.ownerNameCache).writeToTag(itemStack.method_7948());
        return itemStack;
    }

    public static int getRenderingColor(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return 0;
        }
        String colorText = nbt.method_10558("color");
        class_1767 dyeColor = class_1767.method_7793((String)colorText, (class_1767)class_1767.field_7963);
        return dyeColor.method_7790();
    }

    public static class ItemInfo {
        public int scale;
        public class_1767 color;
        @Nullable
        public UUID ownerId;
        @Nullable
        public String ownerNameCache;

        public ItemInfo(int scale, class_1767 color) {
            this.scale = scale;
            this.color = color;
        }

        public ItemInfo(int size, class_1767 color, @NotNull UUID ownerId, @NotNull String ownerNameCache) {
            this.scale = size;
            this.color = color;
            this.ownerId = ownerId;
            this.ownerNameCache = ownerNameCache;
        }

        public ItemInfo(class_2487 tag) {
            this.scale = tag.method_10550("size");
            this.color = class_1767.method_7793((String)tag.method_10558("color"), (class_1767)class_1767.field_7963);
            if (tag.method_10545("ownerId")) {
                this.ownerId = tag.method_25926("ownerId");
                this.ownerNameCache = tag.method_10558("ownerNameCache");
            }
        }

        public void writeToTag(class_2487 compoundTag) {
            compoundTag.method_10569("size", this.scale);
            compoundTag.method_10582("color", this.color.method_7792());
            if (this.ownerId != null) {
                compoundTag.method_25927("ownerId", this.ownerId);
                compoundTag.method_10582("ownerNameCache", this.ownerNameCache);
            }
        }
    }
}

