/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.mini_scaled.ScaleBoxGeneration;
import qouteall.mini_scaled.ScaleBoxManipulation;
import qouteall.mini_scaled.ScaleBoxRecord;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlockEntity;
import qouteall.mini_scaled.item.ScaleBoxEntranceItem;
import qouteall.mini_scaled.util.MSUtil;

public class ManipulationWandItem
extends class_1792 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManipulationWandItem.class);
    public static final ManipulationWandItem instance = new ManipulationWandItem(new class_1792.class_1793());

    public static void init() {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("mini_scaled:manipulation_wand"), (Object)((Object)instance));
    }

    public ManipulationWandItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static Mode getModeFromNbt(@Nullable class_2487 tag) {
        if (tag == null) {
            return Mode.none;
        }
        return Mode.valueOf(tag.method_10558("mode"));
    }

    public static class_2487 modeToNbt(Mode mode) {
        class_2487 tag = new class_2487();
        tag.method_10582("mode", mode.name());
        return tag;
    }

    public static void registerCreativeInventory(Consumer<class_1799> func) {
        class_1799 itemStack = new class_1799((class_1935)instance);
        itemStack.method_7980(ManipulationWandItem.modeToNbt(Mode.none));
        func.accept(itemStack);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        if (level.method_8608()) {
            return new class_1271(class_1269.field_5812, (Object)itemStack);
        }
        Mode mode = ManipulationWandItem.getModeFromNbt(itemStack.method_7969());
        Mode nextMode = mode.next();
        itemStack.method_7980(ManipulationWandItem.modeToNbt(nextMode));
        return new class_1271(class_1269.field_5812, (Object)itemStack);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8045().method_8608()) {
            return class_1269.field_5812;
        }
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_3218 world = (class_3218)context.method_8045();
        class_1799 itemInHand = context.method_8041();
        Mode mode = ManipulationWandItem.getModeFromNbt(itemInHand.method_7969());
        if (mode == Mode.none) {
            player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.manipulation_wand.tip"), true);
            return class_1269.field_5812;
        }
        class_2338 clickedPos = context.method_8037();
        class_2680 blockState = world.method_8320(clickedPos);
        if (blockState.method_26204() != ScaleBoxPlaceholderBlock.instance) {
            player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.manipulation_wand.use_on_scale_box"), true);
            return class_1269.field_5814;
        }
        class_2586 blockEntity = world.method_8321(clickedPos);
        if (!(blockEntity instanceof ScaleBoxPlaceholderBlockEntity)) {
            LOGGER.error("Scale box block entity not found");
            return class_1269.field_5814;
        }
        ScaleBoxPlaceholderBlockEntity placeholderBlockEntity = (ScaleBoxPlaceholderBlockEntity)blockEntity;
        int boxId = placeholderBlockEntity.boxId;
        ScaleBoxRecord scaleBoxRecord = ScaleBoxRecord.get();
        ScaleBoxRecord.Entry entry = scaleBoxRecord.getEntryById(boxId);
        if (entry == null) {
            LOGGER.error("Cannot find scale box record entry {}", (Object)boxId);
            return class_1269.field_5814;
        }
        if (entry.accessControl && !Objects.equals(entry.ownerId, player.method_5667())) {
            ScaleBoxManipulation.showScaleBoxAccessDeniedMessage(player);
            return class_1269.field_5814;
        }
        class_2350 outerSide = context.method_8038();
        switch (mode) {
            case expand: {
                return ScaleBoxManipulation.tryToExpandScaleBox(player, world, entry, outerSide, requiredEntranceItemNum -> {
                    if (player.method_7337()) {
                        return true;
                    }
                    class_1661 inventory = player.method_31548();
                    boolean has = MSUtil.removeIfHas((class_1263)inventory, s -> {
                        class_1792 item = s.method_7909();
                        if (item != ScaleBoxEntranceItem.instance) {
                            return false;
                        }
                        ScaleBoxEntranceItem.ItemInfo itemInfo = new ScaleBoxEntranceItem.ItemInfo(s.method_7948());
                        return itemInfo.color == entry.color && itemInfo.scale == entry.scale && (Objects.equals(itemInfo.ownerId, entry.ownerId) || itemInfo.ownerId == null);
                    }, requiredEntranceItemNum);
                    if (!has) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"mini_scaled.cannot_expand_not_enough", (Object[])new Object[]{requiredEntranceItemNum}), false);
                    }
                    return has;
                });
            }
            case shrink: {
                return ScaleBoxManipulation.tryToShrinkScaleBox(player, world, entry, outerSide);
            }
            case toggleScaleChange: {
                entry.teleportChangesScale = !entry.teleportChangesScale;
                ScaleBoxGeneration.updateScaleBoxPortals(entry, (class_3222)player);
                player.method_7353((class_2561)class_2561.method_43471((String)(entry.teleportChangesScale ? "mini_scaled.manipulation_wand.scale_change.enabled" : "mini_scaled.manipulation_wand.scale_change.disabled")), true);
                return class_1269.field_5812;
            }
            case toggleGravityChange: {
                entry.teleportChangesGravity = !entry.teleportChangesGravity;
                ScaleBoxGeneration.updateScaleBoxPortals(entry, (class_3222)player);
                player.method_7353((class_2561)class_2561.method_43471((String)(entry.teleportChangesGravity ? "mini_scaled.manipulation_wand.gravity_change.enabled" : "mini_scaled.manipulation_wand.gravity_change.disabled")), true);
                return class_1269.field_5812;
            }
            case toggleAccessControl: {
                if (!Objects.equals(entry.ownerId, player.method_5667())) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.access_denied"), true);
                    return class_1269.field_5814;
                }
                entry.accessControl = !entry.accessControl;
                ScaleBoxGeneration.updateScaleBoxPortals(entry, (class_3222)player);
                player.method_7353((class_2561)class_2561.method_43471((String)(entry.accessControl ? "mini_scaled.manipulation_wand.access_control.enabled" : "mini_scaled.manipulation_wand.access_control.disabled")), true);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        Mode mode = ManipulationWandItem.getModeFromNbt(stack.method_7969());
        tooltip.add((class_2561)class_2561.method_43471((String)"mini_scaled.manipulation_wand.tip"));
    }

    public class_2561 method_7864(class_1799 stack) {
        Mode mode = ManipulationWandItem.getModeFromNbt(stack.method_7969());
        class_5250 baseText = class_2561.method_43471((String)"item.mini_scaled.manipulation_wand");
        if (mode == Mode.none) {
            return baseText;
        }
        return baseText.method_10852((class_2561)class_2561.method_43470((String)" : ")).method_10852((class_2561)mode.getText().method_27692(class_124.field_1065));
    }

    public static enum Mode {
        none,
        expand,
        shrink,
        toggleScaleChange,
        toggleGravityChange,
        toggleAccessControl;


        public Mode next() {
            Mode[] values = Mode.values();
            return values[(this.ordinal() + 1) % values.length];
        }

        public class_5250 getText() {
            return class_2561.method_43471((String)("mini_scaled.manipulation_wand.mode." + this.name()));
        }
    }
}

