/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled.block;

import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.mini_scaled.ScaleBoxGeneration;
import qouteall.mini_scaled.ScaleBoxRecord;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.item.ScaleBoxEntranceItem;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.IntBox;

public class ScaleBoxPlaceholderBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogManager.getLogger(ScaleBoxPlaceholderBlockEntity.class);
    public static class_2591<ScaleBoxPlaceholderBlockEntity> blockEntityType;
    public int boxId;
    public boolean isBasePos = true;

    public static void init() {
        blockEntityType = (class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)"mini_scaled:placeholder_block_entity", (Object)FabricBlockEntityTypeBuilder.create(ScaleBoxPlaceholderBlockEntity::new, (class_2248[])new class_2248[]{ScaleBoxPlaceholderBlock.instance}).build());
    }

    public ScaleBoxPlaceholderBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.boxId = tag.method_10550("boxId");
        if (tag.method_10545("isBasePos")) {
            this.isBasePos = tag.method_10577("isBasePos");
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("boxId", this.boxId);
        tag.method_10556("isBasePos", this.isBasePos);
    }

    public void doTick() {
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.field_11863.method_8510() % 7L != 2L) {
            return;
        }
        this.checkValidity();
    }

    public static void staticTick(class_1937 world, class_2338 pos, class_2680 state, ScaleBoxPlaceholderBlockEntity blockEntity) {
        blockEntity.doTick();
    }

    public void checkValidity() {
        boolean dimEquals;
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.get().getEntryById(this.boxId);
        if (entry == null) {
            LOGGER.info("invalid box with id {}", (Object)this.boxId);
            this.destroyBlockAndBlockEntity();
            return;
        }
        IntBox scaleBoxOuterArea = entry.getOuterAreaBox();
        boolean posEquals = scaleBoxOuterArea.contains(this.method_11016());
        if (!posEquals) {
            LOGGER.info("invalid box entrance position {} {} {}", (Object)this.boxId, (Object)this.method_11016(), (Object)entry.currentEntrancePos);
            this.destroyBlockAndBlockEntity();
            return;
        }
        boolean bl = dimEquals = entry.currentEntranceDim == this.field_11863.method_27983();
        if (!dimEquals) {
            LOGGER.info("invalid box dim {} {} {}", (Object)this.boxId, (Object)this.field_11863.method_27983(), entry.currentEntranceDim);
            this.destroyBlockAndBlockEntity();
            return;
        }
    }

    private void destroyBlockAndBlockEntity() {
        Validate.isTrue((!this.field_11863.method_8608() ? 1 : 0) != 0);
        LOGGER.info("destroy scale box {}", (Object)this.boxId);
        this.field_11863.method_8501(this.method_11016(), class_2246.field_10124.method_9564());
        this.method_11012();
        this.dropItemIfNecessary();
    }

    public void dropItemIfNecessary() {
        if (this.isBasePos) {
            class_1799 itemToDrop = ScaleBoxEntranceItem.boxIdToItem(this.boxId);
            if (itemToDrop != null) {
                class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.method_11016().method_10263() + 0.5), (double)((double)this.method_11016().method_10264() + 0.5), (double)((double)this.method_11016().method_10260() + 0.5), (class_1799)itemToDrop);
            }
            this.isBasePos = false;
        }
    }

    private static void notifyPortalBreak(int boxId) {
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.get().getEntryById(boxId);
        if (entry != null) {
            ++entry.generation;
            ScaleBoxRecord.get().method_78(true);
        }
    }

    public static void checkShouldRemovePortals(int boxId, class_3218 world, class_2338 pos) {
        ScaleBoxRecord record = ScaleBoxRecord.get();
        ScaleBoxRecord.Entry entry = record.getEntryById(boxId);
        if (entry == null) {
            return;
        }
        class_5321<class_1937> currentEntranceDim = entry.currentEntranceDim;
        if (currentEntranceDim == null) {
            ScaleBoxPlaceholderBlockEntity.notifyPortalBreak(boxId);
            return;
        }
        class_3218 entranceWorld = MiscHelper.getServer().method_3847(currentEntranceDim);
        if (entranceWorld == null) {
            LOGGER.info("invalid entrance dim {}", currentEntranceDim);
            entry.currentEntranceDim = class_1937.field_25179;
            return;
        }
        boolean chunkLoaded = entranceWorld.method_22340(entry.currentEntrancePos);
        if (!chunkLoaded) {
            return;
        }
        boolean blocksValid = entry.getOuterAreaBox().stream().allMatch(blockPos -> entranceWorld.method_8320(blockPos).method_26204() == ScaleBoxPlaceholderBlock.instance);
        if (!blocksValid) {
            entry.currentEntranceDim = null;
            record.method_78(true);
            ScaleBoxPlaceholderBlockEntity.notifyPortalBreak(boxId);
            ScaleBoxGeneration.createInnerPortalsPointingToVoidUnderneath(entry);
        }
    }
}

