/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.IntBox;

public class ScaleBoxRecord
extends class_18 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScaleBoxRecord.class);
    private List<Entry> entries = new ArrayList<Entry>();
    @Nullable
    private Int2ObjectOpenHashMap<Entry> cache;

    public static ScaleBoxRecord get() {
        class_3218 overworld = MiscHelper.getServer().method_30002();
        return (ScaleBoxRecord)overworld.method_17983().method_17924(nbt -> {
            ScaleBoxRecord record = new ScaleBoxRecord();
            record.readFromNbt((class_2487)nbt);
            return record;
        }, () -> {
            Helper.log((Object)"Scale box record initialized ");
            return new ScaleBoxRecord();
        }, "scale_box_record");
    }

    @Nullable
    public Entry getEntryById(int boxId) {
        if (this.cache == null) {
            this.cache = new Int2ObjectOpenHashMap();
            for (Entry entry : this.entries) {
                this.cache.put(entry.id, (Object)entry);
            }
        }
        return (Entry)this.cache.get(boxId);
    }

    @Nullable
    public Entry getEntryByPredicate(Predicate<Entry> predicate) {
        return this.entries.stream().filter(predicate).findFirst().orElse(null);
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
        this.cache = null;
    }

    public int allocateId() {
        return this.entries.stream().mapToInt(e -> e.id).max().orElse(0) + 1;
    }

    private void readFromNbt(class_2487 compoundTag) {
        class_2499 list = compoundTag.method_10554("entries", (int)compoundTag.method_10711());
        this.entries = list.stream().map(tag -> {
            Entry entry = new Entry();
            entry.readFromNbt((class_2487)tag);
            return entry;
        }).collect(Collectors.toList());
        this.cache = null;
    }

    private void writeToNbt(class_2487 compoundTag) {
        class_2499 listTag = new class_2499();
        for (Entry entry : this.entries) {
            class_2487 tag = new class_2487();
            entry.writeToNbt(tag);
            listTag.add((Object)tag);
        }
        compoundTag.method_10566("entries", (class_2520)listTag);
    }

    public void fromTag(class_2487 tag) {
        this.readFromNbt(tag);
    }

    public class_2487 method_75(class_2487 tag) {
        this.writeToNbt(tag);
        return tag;
    }

    public static class Entry {
        public int id;
        public class_2338 innerBoxPos;
        public int scale;
        public class_1767 color;
        public UUID ownerId;
        public String ownerNameCache;
        @Nullable
        public class_5321<class_1937> currentEntranceDim;
        public class_2338 currentEntrancePos;
        public class_2338 currentEntranceSize;
        public int generation;
        @Nullable
        public AARotation entranceRotation;
        public boolean teleportChangesScale = false;
        public boolean teleportChangesGravity = false;
        public boolean accessControl = false;

        public IntBox getOuterAreaBox() {
            AARotation rot = this.getEntranceRotation();
            class_2338 actualEntranceSize = rot.transform((class_2382)this.currentEntranceSize);
            return IntBox.getBoxByPosAndSignedSize((class_2338)this.currentEntrancePos, (class_2338)actualEntranceSize);
        }

        public IntBox getInnerAreaBox() {
            return IntBox.fromBasePointAndSize((class_2338)this.innerBoxPos, (class_2338)new class_2338(this.scale * this.currentEntranceSize.method_10263(), this.scale * this.currentEntranceSize.method_10264(), this.scale * this.currentEntranceSize.method_10260()));
        }

        public IntBox getInnerUnitBox(class_2338 outerOffset) {
            return IntBox.fromBasePointAndSize((class_2338)this.innerBoxPos.method_10081((class_2382)outerOffset.method_35830(this.scale)), (class_2338)new class_2338(this.scale, this.scale, this.scale));
        }

        public class_2338 unitRegionOffsetToBlockOffset(class_2338 unitRegionOffset) {
            return unitRegionOffset.method_35830(this.scale);
        }

        public class_2338 blockOffsetToUnitRegionOffset(class_2338 blockOffset) {
            return new class_2338(Math.floorDiv(blockOffset.method_10263(), this.scale), Math.floorDiv(blockOffset.method_10264(), this.scale), Math.floorDiv(blockOffset.method_10260(), this.scale));
        }

        public IntBox getInnerAreaLocalBox() {
            return IntBox.fromBasePointAndSize((class_2338)class_2338.field_10980, (class_2338)new class_2338(this.scale * this.currentEntranceSize.method_10263(), this.scale * this.currentEntranceSize.method_10264(), this.scale * this.currentEntranceSize.method_10260()));
        }

        public AARotation getEntranceRotation() {
            if (this.entranceRotation == null) {
                return AARotation.IDENTITY;
            }
            return this.entranceRotation;
        }

        public AARotation getRotationToInner() {
            return this.getEntranceRotation().getInverse();
        }

        void readFromNbt(class_2487 tag) {
            this.id = tag.method_10550("id");
            this.innerBoxPos = Helper.getVec3i((class_2487)tag, (String)"innerBoxPos");
            this.scale = tag.method_10550("size");
            this.color = class_1767.method_7793((String)tag.method_10558("color"), (class_1767)class_1767.field_7963);
            this.ownerId = tag.method_25926("ownerId");
            this.ownerNameCache = tag.method_10558("ownerNameCache");
            this.currentEntranceDim = tag.method_10545("currentEntranceDim") ? class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(tag.method_10558("currentEntranceDim"))) : null;
            this.currentEntrancePos = Helper.getVec3i((class_2487)tag, (String)"currentEntrancePos");
            if (tag.method_10545("currentEntranceSizeX")) {
                this.currentEntranceSize = Helper.getVec3i((class_2487)tag, (String)"currentEntranceSize");
                if (this.currentEntranceSize.method_10263() == 0 || this.currentEntranceSize.method_10264() == 0 || this.currentEntranceSize.method_10260() == 0) {
                    LOGGER.error("Invalid entrance size in {}", (Object)tag);
                    this.currentEntranceSize = new class_2338(1, 1, 1);
                }
            } else {
                this.currentEntranceSize = new class_2338(1, 1, 1);
            }
            this.generation = tag.method_10550("generation");
            this.entranceRotation = tag.method_10545("entranceRotation") ? AARotation.values()[tag.method_10550("entranceRotation")] : null;
            this.teleportChangesScale = tag.method_10545("teleportChangesScale") ? tag.method_10577("teleportChangesScale") : false;
            this.teleportChangesGravity = tag.method_10545("teleportChangesGravity") ? tag.method_10577("teleportChangesGravity") : false;
            this.accessControl = tag.method_10545("accessControl") ? tag.method_10577("accessControl") : false;
        }

        void writeToNbt(class_2487 tag) {
            tag.method_10569("id", this.id);
            Helper.putVec3i((class_2487)tag, (String)"innerBoxPos", (class_2382)this.innerBoxPos);
            tag.method_10569("size", this.scale);
            tag.method_10582("color", this.color.method_7792());
            tag.method_25927("ownerId", this.ownerId);
            tag.method_10582("ownerNameCache", this.ownerNameCache);
            if (this.currentEntranceDim != null) {
                tag.method_10582("currentEntranceDim", this.currentEntranceDim.method_29177().method_12832());
            }
            Helper.putVec3i((class_2487)tag, (String)"currentEntrancePos", (class_2382)this.currentEntrancePos);
            Helper.putVec3i((class_2487)tag, (String)"currentEntranceSize", (class_2382)this.currentEntranceSize);
            tag.method_10569("generation", this.generation);
            if (this.entranceRotation != null) {
                tag.method_10569("entranceRotation", this.entranceRotation.ordinal());
            }
            tag.method_10556("teleportChangesScale", this.teleportChangesScale);
            tag.method_10556("teleportChangesGravity", this.teleportChangesGravity);
            tag.method_10556("accessControl", this.accessControl);
        }
    }
}

