/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.apache.commons.lang3.Validate;
import qouteall.mini_scaled.ScaleBoxEntranceCreation;
import qouteall.mini_scaled.ScaleBoxGeneration;
import qouteall.mini_scaled.ScaleBoxRecord;
import qouteall.mini_scaled.VoidDimension;
import qouteall.mini_scaled.block.BoxBarrierBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlockEntity;
import qouteall.mini_scaled.item.ScaleBoxEntranceItem;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.IntBox;

public class ScaleBoxManipulation {
    private static AARotation getEntranceRotationForPlacing(class_1838 context) {
        Validate.isTrue((context.method_8036() != null ? 1 : 0) != 0);
        class_2350 placingSide = context.method_8038();
        class_2350[] otherDirs = Helper.getAnotherFourDirections((class_2350.class_2351)placingSide.method_10166());
        class_243 hitPosToEye = context.method_8036().method_33571().method_1020(context.method_17698());
        class_2350 directionPointingToPlayer = Arrays.stream(otherDirs).max(Comparator.comparingDouble(dir -> {
            class_243 vec = class_243.method_24954((class_2382)dir.method_10163());
            return vec.method_1026(hitPosToEye);
        })).orElseThrow();
        return AARotation.getAARotationFromYZ((class_2350)placingSide, (class_2350)directionPointingToPlayer);
    }

    public static class_1269 onRightClickUsingEntrance(class_1838 context) {
        class_2338 entranceSize;
        class_1937 world = context.method_8045();
        if (world.method_8608()) {
            return class_1269.field_5814;
        }
        if (context.method_8036() == null) {
            return class_1269.field_5814;
        }
        class_2338 pointedBlockPos = context.method_8037();
        class_2338 placementPos = pointedBlockPos.method_10093(context.method_8038());
        if (!world.method_22347(placementPos)) {
            return class_1269.field_5814;
        }
        if (world.method_8320(pointedBlockPos).method_26204() == ScaleBoxPlaceholderBlock.instance) {
            return class_1269.field_5811;
        }
        class_1799 stack = context.method_8041();
        ScaleBoxEntranceItem.ItemInfo itemInfo = new ScaleBoxEntranceItem.ItemInfo(stack.method_7948());
        class_3222 player = (class_3222)context.method_8036();
        int scale = itemInfo.scale;
        if (!ScaleBoxGeneration.isValidScale(scale)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"invalid scale"), false);
            return class_1269.field_5814;
        }
        UUID ownerId = itemInfo.ownerId;
        String ownerNameCache = itemInfo.ownerNameCache;
        if (ownerId == null) {
            ownerId = player.method_5667();
        }
        if (ownerNameCache == null) {
            ownerNameCache = player.method_5477().getString();
        }
        class_1767 color = itemInfo.color;
        ScaleBoxRecord record = ScaleBoxRecord.get();
        ScaleBoxRecord.Entry entry = ScaleBoxGeneration.getOrCreateEntry(ownerId, ownerNameCache, scale, color, record);
        AARotation entranceRotation = ScaleBoxManipulation.getEntranceRotationForPlacing(context);
        class_2338 transformedEntranceSize = entranceRotation.transform((class_2382)(entranceSize = entry.currentEntranceSize));
        class_2338 realPlacementPos = IntBox.getBoxByPosAndSignedSize((class_2338)class_2338.field_10980, (class_2338)transformedEntranceSize).stream().map(offsetFromBasePosToPlacementPos -> placementPos.method_10059((class_2382)offsetFromBasePosToPlacementPos)).filter(basePosCandidate -> IntBox.getBoxByPosAndSignedSize((class_2338)basePosCandidate, (class_2338)transformedEntranceSize).stream().allMatch(blockPos -> world.method_8320(blockPos).method_26215() && !blockPos.equals((Object)player.method_24515()))).findFirst().orElse(null);
        if (realPlacementPos != null) {
            ScaleBoxGeneration.putScaleBoxIntoWorld(entry, (class_3218)world, realPlacementPos, entranceRotation, player);
            stack.method_7934(1);
            return class_1269.field_5812;
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"mini_scaled.no_enough_space_to_place_scale_box", (Object[])new Object[]{String.format("(%d, %d, %d)", entranceSize.method_10263(), entranceSize.method_10264(), entranceSize.method_10260())}), false);
        return class_1269.field_5814;
    }

    public static class_1269 onHandRightClickEntrance(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        class_2338 pointedBlockPos = hitResult.method_17777();
        class_2586 be = world.method_8321(pointedBlockPos);
        if (!(be instanceof ScaleBoxPlaceholderBlockEntity)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Error no block entity"), false);
            return class_1269.field_5814;
        }
        ScaleBoxPlaceholderBlockEntity placeholderBlockEntity = (ScaleBoxPlaceholderBlockEntity)be;
        int boxId = placeholderBlockEntity.boxId;
        ScaleBoxRecord.Entry entry = ScaleBoxRecord.get().getEntryById(boxId);
        if (entry == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Error invalid box id"), false);
            return class_1269.field_5814;
        }
        class_2350 outerSide = hitResult.method_17780();
        if (item == ScaleBoxEntranceItem.instance) {
            ScaleBoxEntranceItem.ItemInfo itemInfo = new ScaleBoxEntranceItem.ItemInfo(stack.method_7948());
            UUID ownerId = itemInfo.ownerId;
            if (ownerId == null) {
                ownerId = player.method_5667();
            }
            if (!Objects.equals(entry.ownerId, ownerId) || entry.color != itemInfo.color || entry.scale != itemInfo.scale) {
                player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.cannot_expand_mismatch"), false);
                return class_1269.field_5814;
            }
            return ScaleBoxManipulation.tryToExpandScaleBox(player, (class_3218)world, entry, outerSide, requiredEntranceItemNum -> {
                if (player.method_7337()) {
                    return true;
                }
                if (stack.method_7947() < requiredEntranceItemNum) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"mini_scaled.cannot_expand_not_enough", (Object[])new Object[]{requiredEntranceItemNum}), false);
                    return false;
                }
                stack.method_7934(requiredEntranceItemNum.intValue());
                return true;
            });
        }
        if (stack.method_7960()) {
            return ScaleBoxManipulation.tryToShrinkScaleBox(player, (class_3218)world, entry, outerSide);
        }
        return class_1269.field_5811;
    }

    public static class_1269 tryToShrinkScaleBox(class_1657 player, class_3218 world, ScaleBoxRecord.Entry entry, class_2350 outerSide) {
        if (entry.accessControl && !Objects.equals(entry.ownerId, player.method_5667())) {
            ScaleBoxManipulation.showScaleBoxAccessDeniedMessage(player);
            return class_1269.field_5814;
        }
        class_2350 innerSide = entry.getRotationToInner().transformDirection(outerSide);
        if (innerSide.method_10171() != class_2350.class_2352.field_11056) {
            player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.cannot_shrink_direction"), false);
            return class_1269.field_5814;
        }
        class_2338 oldEntranceSize = entry.currentEntranceSize;
        int lenOnDirection = Helper.getCoordinate((class_2382)oldEntranceSize, (class_2350.class_2351)innerSide.method_10166());
        if (lenOnDirection == 1) {
            return class_1269.field_5814;
        }
        class_2338 newEntranceSize = Helper.putCoordinate((class_2382)oldEntranceSize, (class_2350.class_2351)innerSide.method_10166(), (int)(lenOnDirection - 1));
        IntBox oldInnerOffsets = IntBox.fromBasePointAndSize((class_2338)class_2338.field_10980, (class_2338)oldEntranceSize);
        IntBox newInnerOffsets = IntBox.fromBasePointAndSize((class_2338)class_2338.field_10980, (class_2338)newEntranceSize);
        class_2248 glassBlock = ScaleBoxGeneration.getGlassBlock(entry.color);
        boolean hasRemainingBlocks = oldInnerOffsets.stream().anyMatch(offset -> {
            if (newInnerOffsets.contains(offset)) {
                return false;
            }
            IntBox innerUnitBox = entry.getInnerUnitBox((class_2338)offset);
            class_3218 voidWorld = VoidDimension.getVoidWorld();
            return !innerUnitBox.stream().allMatch(blockPos -> {
                class_2680 blockState = voidWorld.method_8320(blockPos);
                return blockState.method_26204() == BoxBarrierBlock.instance || blockState.method_26215() || blockState.method_26204() == glassBlock;
            });
        });
        if (hasRemainingBlocks) {
            player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.cannot_shrink_has_blocks"), false);
            return class_1269.field_5814;
        }
        entry.currentEntranceSize = newEntranceSize;
        ScaleBoxRecord.get().method_78(true);
        ScaleBoxGeneration.putScaleBoxIntoWorld(entry, world, entry.currentEntrancePos, entry.getEntranceRotation(), (class_3222)player);
        ScaleBoxGeneration.initializeInnerBoxBlocks(oldEntranceSize, entry);
        if (!player.method_7337()) {
            int compensateNetheriteNum = ScaleBoxManipulation.getVolume(oldEntranceSize) - ScaleBoxManipulation.getVolume(newEntranceSize);
            player.method_7270(new class_1799((class_1935)ScaleBoxEntranceCreation.creationItem, compensateNetheriteNum));
        }
        return class_1269.field_5812;
    }

    private static int getVolume(class_2338 entranceSize) {
        return entranceSize.method_10263() * entranceSize.method_10264() * entranceSize.method_10260();
    }

    public static class_1269 tryToExpandScaleBox(class_1657 player, class_3218 world, ScaleBoxRecord.Entry entry, class_2350 outerSide, Function<Integer, Boolean> itemConsumptionFunc) {
        if (entry.accessControl && !Objects.equals(entry.ownerId, player.method_5667())) {
            ScaleBoxManipulation.showScaleBoxAccessDeniedMessage(player);
            return class_1269.field_5814;
        }
        class_2350 innerSide = entry.getRotationToInner().transformDirection(outerSide);
        if (innerSide.method_10171() != class_2350.class_2352.field_11056) {
            player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.cannot_expand_direction"), false);
            return class_1269.field_5814;
        }
        class_2338 oldEntranceSize = entry.currentEntranceSize;
        int volume = ScaleBoxManipulation.getVolume(oldEntranceSize);
        int lenOnDirection = Helper.getCoordinate((class_2382)oldEntranceSize, (class_2350.class_2351)innerSide.method_10166());
        class_2338 newEntranceSize = Helper.putCoordinate((class_2382)oldEntranceSize, (class_2350.class_2351)innerSide.method_10166(), (int)(lenOnDirection + 1));
        class_2338 transformedNewEntranceSize = entry.getEntranceRotation().transform((class_2382)newEntranceSize);
        boolean areaClear = IntBox.getBoxByPosAndSignedSize((class_2338)entry.currentEntrancePos, (class_2338)transformedNewEntranceSize).fastStream().allMatch(blockPos -> {
            class_2680 blockState = world.method_8320(blockPos);
            return blockState.method_26215() || blockState.method_26204() == ScaleBoxPlaceholderBlock.instance;
        });
        if (!areaClear) {
            return class_1269.field_5814;
        }
        int requiredEntranceItemNum = ScaleBoxManipulation.getVolume(newEntranceSize) - ScaleBoxManipulation.getVolume(oldEntranceSize);
        if ((lenOnDirection + 1) * entry.scale > 64) {
            player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.cannot_expand_size_limit"), false);
            return class_1269.field_5814;
        }
        boolean succ = itemConsumptionFunc.apply(requiredEntranceItemNum);
        if (!succ) {
            return class_1269.field_5814;
        }
        entry.currentEntranceSize = newEntranceSize;
        ScaleBoxRecord.get().method_78(true);
        ScaleBoxGeneration.putScaleBoxIntoWorld(entry, world, entry.currentEntrancePos, entry.getEntranceRotation(), (class_3222)player);
        ScaleBoxGeneration.initializeInnerBoxBlocks(oldEntranceSize, entry);
        return class_1269.field_5812;
    }

    public static void showScaleBoxAccessDeniedMessage(class_1657 player) {
        player.method_7353((class_2561)class_2561.method_43471((String)"mini_scaled.access_denied"), false);
    }
}

