/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.mini_scaled.MiniScaledPortal;
import qouteall.mini_scaled.ScaleBoxManipulation;
import qouteall.mini_scaled.ScaleBoxRecord;
import qouteall.mini_scaled.VoidDimension;
import qouteall.mini_scaled.block.BoxBarrierBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlockEntity;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class ScaleBoxGeneration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScaleBoxGeneration.class);
    public static final int[] supportedScales = new int[]{4, 8, 16, 32};

    public static void putScaleBoxIntoWorld(ScaleBoxRecord.Entry entry, class_3218 world, class_2338 outerBoxBasePos, AARotation rotation, class_3222 player) {
        if (entry.accessControl && !Objects.equals(entry.ownerId, player.method_5667())) {
            ScaleBoxManipulation.showScaleBoxAccessDeniedMessage((class_1657)player);
            return;
        }
        entry.currentEntranceDim = world.method_27983();
        entry.currentEntrancePos = outerBoxBasePos;
        entry.entranceRotation = rotation;
        ++entry.generation;
        ScaleBoxRecord.get().method_78(true);
        class_3218 voidWorld = VoidDimension.getVoidWorld();
        ScaleBoxGeneration.createScaleBoxPortals(voidWorld, world, entry);
        entry.getOuterAreaBox().stream().forEach(outerPos -> {
            world.method_8501(outerPos, ScaleBoxPlaceholderBlock.instance.method_9564());
            class_2586 blockEntity = world.method_8321(outerPos);
            if (blockEntity == null) {
                LOGGER.info("cannot find block entity for scale box");
            } else {
                ScaleBoxPlaceholderBlockEntity be = (ScaleBoxPlaceholderBlockEntity)blockEntity;
                be.boxId = entry.id;
                be.isBasePos = outerPos.equals((Object)entry.currentEntrancePos);
            }
        });
    }

    private static void createScaleBoxPortals(class_3218 innerWorld, class_3218 outerWorld, ScaleBoxRecord.Entry entry) {
        AARotation entranceRotation = entry.getEntranceRotation();
        AARotation toInnerRotation = entranceRotation.getInverse();
        class_238 outerAreaBox = entry.getOuterAreaBox().toRealNumberBox();
        class_238 innerAreaBox = entry.getInnerAreaBox().toRealNumberBox();
        class_2338 outerAreaBoxSize = entry.getOuterAreaBox().getSize();
        int scale = entry.scale;
        DQuaternion quaternion = toInnerRotation.matrix.toQuaternion();
        int boxId = entry.id;
        int generation = entry.generation;
        for (class_2350 outerDirection : class_2350.values()) {
            MiniScaledPortal portal = (MiniScaledPortal)MiniScaledPortal.entityType.method_5883((class_1937)outerWorld);
            Validate.notNull((Object)((Object)portal));
            portal.setDestinationDimension(innerWorld.method_27983());
            class_2350 innerDirection = toInnerRotation.transformDirection(outerDirection);
            portal.setOriginPos(Helper.getBoxSurface((class_238)outerAreaBox, (class_2350)outerDirection).method_1005());
            portal.setDestination(Helper.getBoxSurface((class_238)innerAreaBox, (class_2350)innerDirection).method_1005());
            class_3545 perpendicularDirections = Helper.getPerpendicularDirections((class_2350)outerDirection);
            class_2350 pd1 = (class_2350)perpendicularDirections.method_15442();
            class_2350 pd2 = (class_2350)perpendicularDirections.method_15441();
            portal.setOrientation(class_243.method_24954((class_2382)pd1.method_10163()), class_243.method_24954((class_2382)pd2.method_10163()));
            portal.setWidth(Helper.getCoordinate((class_2382)outerAreaBoxSize, (class_2350.class_2351)pd1.method_10166()));
            portal.setHeight(Helper.getCoordinate((class_2382)outerAreaBoxSize, (class_2350.class_2351)pd2.method_10166()));
            portal.setRotation(quaternion);
            portal.scaling = scale;
            portal.teleportChangesScale = entry.teleportChangesScale;
            portal.setTeleportChangesGravity(entry.teleportChangesGravity);
            portal.fuseView = true;
            portal.renderingMergable = true;
            portal.hasCrossPortalCollision = true;
            portal.portalTag = "mini_scaled:scaled_box";
            PortalExtension.get((Portal)portal).adjustPositionAfterTeleport = true;
            portal.setInteractable(true);
            portal.boxId = boxId;
            portal.generation = generation;
            portal.recordEntry = entry;
            McHelper.spawnServerEntity((class_1297)portal);
            MiniScaledPortal reversePortal = (MiniScaledPortal)PortalManipulation.createReversePortal((Portal)portal, MiniScaledPortal.entityType);
            reversePortal.fuseView = false;
            reversePortal.renderingMergable = true;
            reversePortal.hasCrossPortalCollision = true;
            reversePortal.setInteractable(true);
            reversePortal.boxId = boxId;
            reversePortal.generation = generation;
            reversePortal.recordEntry = entry;
            McHelper.spawnServerEntity((class_1297)reversePortal);
        }
    }

    public static ScaleBoxRecord.Entry getOrCreateEntry(UUID playerId, String playerName, int scale, class_1767 color, ScaleBoxRecord record) {
        Validate.notNull((Object)playerId);
        ScaleBoxRecord.Entry entry = record.getEntryByPredicate(e -> e.ownerId.equals(playerId) && e.color == color && e.scale == scale);
        if (entry == null) {
            int newId = ScaleBoxGeneration.allocateId(record);
            ScaleBoxRecord.Entry newEntry = new ScaleBoxRecord.Entry();
            newEntry.id = newId;
            newEntry.color = color;
            newEntry.ownerId = playerId;
            newEntry.ownerNameCache = playerName;
            newEntry.scale = scale;
            newEntry.generation = 0;
            newEntry.innerBoxPos = ScaleBoxGeneration.allocateInnerBoxPos(newId);
            newEntry.currentEntranceSize = new class_2338(1, 1, 1);
            record.addEntry(newEntry);
            record.method_78(true);
            ScaleBoxGeneration.initializeInnerBoxBlocks(null, newEntry);
            entry = newEntry;
        }
        return entry;
    }

    private static int allocateId(ScaleBoxRecord record) {
        return record.allocateId();
    }

    private static class_2338 allocateInnerBoxPos(int boxId) {
        int xIndex = boxId % 256;
        int zIndex = class_3532.method_48116((int)boxId, (int)256);
        return new class_2338(xIndex * 16 * 32, 64, zIndex * 16 * 32);
    }

    public static class_2338 getNearestPosInScaleBoxToTeleportTo(class_2338 pos) {
        double gridLen = 512.0;
        return class_2338.method_49637((double)((double)Math.round((double)pos.method_10263() / gridLen) * gridLen + 2.0), (double)66.0, (double)((double)Math.round((double)pos.method_10260() / gridLen) * gridLen + 2.0));
    }

    public static void initializeInnerBoxBlocks(@Nullable class_2338 oldEntranceSize, ScaleBoxRecord.Entry entry) {
        IntBox innerAreaBox = entry.getInnerAreaBox();
        class_3218 voidWorld = VoidDimension.getVoidWorld();
        ChunkLoader chunkLoader = new ChunkLoader(new DimensionalChunkPos(voidWorld.method_27983(), new class_1923(innerAreaBox.getCenter())), Math.max(innerAreaBox.getSize().method_10263(), innerAreaBox.getSize().method_10260()) / 16 + 2);
        class_2248 glassBlock = ScaleBoxGeneration.getGlassBlock(entry.color);
        class_2680 frameBlock = glassBlock.method_9564();
        chunkLoader.loadChunksAndDo(() -> {
            IntBox newEntranceOffsets = IntBox.fromBasePointAndSize((class_2338)class_2338.field_10980, (class_2338)entry.currentEntranceSize);
            IntBox oldEntranceOffsets = oldEntranceSize != null ? IntBox.fromBasePointAndSize((class_2338)class_2338.field_10980, (class_2338)oldEntranceSize) : null;
            newEntranceOffsets.stream().forEach(offset -> {
                if (oldEntranceOffsets != null && oldEntranceOffsets.contains(offset)) {
                    return;
                }
                entry.getInnerUnitBox((class_2338)offset).fastStream().forEach(blockPos -> voidWorld.method_8501(blockPos, class_2246.field_10124.method_9564()));
            });
            if (oldEntranceOffsets != null) {
                oldEntranceOffsets.stream().forEach(offset -> {
                    if (newEntranceOffsets.contains(offset)) {
                        return;
                    }
                    IntBox innerUnitBox = entry.getInnerUnitBox((class_2338)offset);
                    innerUnitBox.fastStream().forEach(blockPos -> voidWorld.method_8501(blockPos, class_2246.field_10124.method_9564()));
                });
            }
            IntBox expanded = innerAreaBox.getAdjusted(-1, -1, -1, 1, 1, 1);
            for (class_2350 direction : class_2350.values()) {
                expanded.getSurfaceLayer(direction).fastStream().forEach(blockPos -> voidWorld.method_8501(blockPos, BoxBarrierBlock.instance.method_9564()));
            }
            Set<class_2338> untouchedRegionOffsets = newEntranceOffsets.stream().filter(offset -> ScaleBoxGeneration.isUnitRegionUntouched(entry, offset, voidWorld, frameBlock)).map(class_2338::method_10062).collect(Collectors.toSet());
            untouchedRegionOffsets.forEach(offset -> {
                IntBox innerUnitBox = entry.getInnerUnitBox((class_2338)offset);
                innerUnitBox.fastStream().forEach(blockPos -> voidWorld.method_8501(blockPos, class_2246.field_10124.method_9564()));
            });
            for (IntBox edge : entry.getInnerAreaLocalBox().get12Edges()) {
                edge.fastStream().forEach(blockOffset -> {
                    class_2338 unitRegionOffset = entry.blockOffsetToUnitRegionOffset((class_2338)blockOffset);
                    if (untouchedRegionOffsets.contains(unitRegionOffset)) {
                        class_2338 blockPos = entry.innerBoxPos.method_10081((class_2382)blockOffset);
                        voidWorld.method_8501(blockPos, frameBlock);
                    }
                });
            }
        });
    }

    private static boolean isUnitRegionUntouched(ScaleBoxRecord.Entry entry, class_2338 regionOffset, class_3218 voidWorld, class_2680 frameBlock) {
        IntBox innerUnitBox = entry.getInnerUnitBox(regionOffset);
        return innerUnitBox.fastStream().allMatch(blockPos -> {
            class_2680 blockState = voidWorld.method_8320(blockPos);
            if (innerUnitBox.isOnEdge(blockPos)) {
                return blockState.method_26215() || blockState == frameBlock;
            }
            return blockState.method_26215();
        });
    }

    public static class_2248 getGlassBlock(class_1767 color) {
        return (class_2248)class_7923.field_41175.method_10223(new class_2960("minecraft:" + color.method_7792() + "_stained_glass"));
    }

    public static boolean isValidScale(int size) {
        return Arrays.stream(supportedScales).anyMatch(s -> s == size);
    }

    public static void updateScaleBoxPortals(ScaleBoxRecord.Entry entry, class_3222 player) {
        class_5321<class_1937> currentEntranceDim = entry.currentEntranceDim;
        if (currentEntranceDim == null) {
            LOGGER.error("Updating a scale box that has no entrance");
            return;
        }
        ScaleBoxGeneration.putScaleBoxIntoWorld(entry, McHelper.getServerWorld(currentEntranceDim), entry.currentEntrancePos, entry.getEntranceRotation(), player);
    }

    public static void createInnerPortalsPointingToVoidUnderneath(ScaleBoxRecord.Entry entry) {
        class_3218 voidWorld = VoidDimension.getVoidWorld();
        class_238 innerAreaBox = entry.getInnerAreaBox().toRealNumberBox();
        class_243 innerAreaBoxSize = Helper.getBoxSize((class_238)innerAreaBox);
        int boxId = entry.id;
        int generation = entry.generation;
        for (class_2350 innerDirection : class_2350.values()) {
            MiniScaledPortal portal = (MiniScaledPortal)MiniScaledPortal.entityType.method_5883((class_1937)voidWorld);
            Validate.notNull((Object)((Object)portal));
            portal.setOriginPos(Helper.getBoxSurface((class_238)innerAreaBox, (class_2350)innerDirection).method_1005());
            portal.setDestination(portal.getOriginPos().method_1031(0.0, -1000.0, 0.0));
            portal.setDestinationDimension(voidWorld.method_27983());
            class_3545 perpendicularDirections = Helper.getPerpendicularDirections((class_2350)innerDirection.method_10153());
            class_2350 pd1 = (class_2350)perpendicularDirections.method_15442();
            class_2350 pd2 = (class_2350)perpendicularDirections.method_15441();
            portal.setOrientation(class_243.method_24954((class_2382)pd1.method_10163()), class_243.method_24954((class_2382)pd2.method_10163()));
            portal.setWidth(Helper.getCoordinate((class_243)innerAreaBoxSize, (class_2350.class_2351)pd1.method_10166()));
            portal.setHeight(Helper.getCoordinate((class_243)innerAreaBoxSize, (class_2350.class_2351)pd2.method_10166()));
            portal.renderingMergable = true;
            portal.portalTag = "mini_scaled:scaled_box_inner_wrapping";
            portal.boxId = boxId;
            portal.generation = generation;
            McHelper.spawnServerEntity((class_1297)portal);
        }
    }
}

