/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2506;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import qouteall.mini_scaled.ScaleBoxGeneration;
import qouteall.mini_scaled.item.ManipulationWandItem;
import qouteall.mini_scaled.item.ScaleBoxEntranceItem;
import qouteall.q_misc_util.my_util.IntBox;

public class ScaleBoxEntranceCreation {
    public static class_1792 creationItem;
    private static final List<BoxFrameMatcher> boxFrameMatchers;

    public static void init() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (creationItem == null) {
                return class_1269.field_5811;
            }
            class_1799 stackInHand = player.method_5998(hand);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (stackInHand.method_7909() == creationItem) {
                    boolean succeeded = ScaleBoxEntranceCreation.onRightClickBoxFrameUsingNetherite(serverPlayer, hitResult.method_17777());
                    if (succeeded) {
                        stackInHand.method_7934(1);
                        return class_1269.field_21466;
                    }
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
    }

    private static boolean onRightClickBoxFrameUsingNetherite(class_3222 player, class_2338 pos) {
        class_3218 world = (class_3218)player.method_37908();
        class_2680 originBlockState = world.method_8320(pos);
        class_2248 class_22482 = originBlockState.method_26204();
        if (!(class_22482 instanceof class_2506)) {
            return false;
        }
        class_2506 stainedGlassBlock = (class_2506)class_22482;
        IntBox box = ScaleBoxEntranceCreation.detectBoxFrameOfAllowedSize(world, pos, originBlockState);
        if (box == null) {
            IntBox roughBox = ScaleBoxEntranceCreation.detectBoxSizeForErrorFeedback(world, pos, originBlockState);
            class_2338 size = roughBox.getSize();
            Predicate<class_2338> blockPredicate = p -> world.method_8320(p) == originBlockState;
            boolean roughBoxFrameComplete = Arrays.stream(roughBox.get12Edges()).allMatch(edge -> edge.fastStream().allMatch(blockPredicate));
            if (roughBoxFrameComplete) {
                player.method_7353((class_2561)class_2561.method_43469((String)"mini_scaled.invalid_box_size", (Object[])new Object[]{String.format("(%d,%d,%d)", size.method_10263(), size.method_10264(), size.method_10260())}), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"mini_scaled.glass_frame_incomplete", (Object[])new Object[]{String.format("(%d,%d,%d)", size.method_10263(), size.method_10264(), size.method_10260())}), false);
            }
            return false;
        }
        int boxLen = box.getSize().method_10263();
        class_1767 color = stainedGlassBlock.method_10622();
        class_1799 itemStack = new class_1799((class_1935)ScaleBoxEntranceItem.instance);
        ScaleBoxEntranceItem.ItemInfo itemInfo = new ScaleBoxEntranceItem.ItemInfo(boxLen, color);
        itemInfo.writeToTag(itemStack.method_7948());
        player.method_7270(itemStack);
        player.method_7270(new class_1799((class_1935)ManipulationWandItem.instance));
        for (IntBox edge2 : box.get12Edges()) {
            edge2.fastStream().forEach(p -> world.method_8501(p, class_2246.field_10124.method_9564()));
        }
        return true;
    }

    @Nullable
    private static IntBox detectBoxFrameOfAllowedSize(class_3218 world, class_2338 pos, class_2680 blockState) {
        Predicate<class_2338> blockPredicate = p -> world.method_8320(p) == blockState;
        Function<class_2338, IntBox> matcher = vertexPos -> {
            for (BoxFrameMatcher boxFrameMatcher : boxFrameMatchers) {
                IntBox result = boxFrameMatcher.matchFromVertex((class_2338)vertexPos, blockPredicate);
                if (result == null) continue;
                return result;
            }
            return null;
        };
        IntBox result = null;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        mutableBlockPos.method_10101((class_2382)pos);
        result = ScaleBoxEntranceCreation.matchAlongPath(mutableBlockPos, class_2350.field_11033, blockPredicate, matcher);
        if (result != null) {
            return result;
        }
        result = ScaleBoxEntranceCreation.matchAlongPath(mutableBlockPos, class_2350.field_11043, blockPredicate, matcher);
        if (result != null) {
            return result;
        }
        result = ScaleBoxEntranceCreation.matchAlongPath(mutableBlockPos, class_2350.field_11039, blockPredicate, matcher);
        if (result != null) {
            return result;
        }
        return result;
    }

    @Nullable
    private static IntBox matchAlongPath(class_2338.class_2339 currentPos, class_2350 direction, Predicate<class_2338> pathPredicate, Function<class_2338, IntBox> matchingFunc) {
        for (int i = 0; i < 64; ++i) {
            IntBox box = matchingFunc.apply((class_2338)currentPos);
            if (box != null) {
                return box;
            }
            currentPos.method_10098(direction);
            if (pathPredicate.test((class_2338)currentPos)) continue;
            currentPos.method_10098(direction.method_10153());
            return null;
        }
        return null;
    }

    private static class_2338 getFurthest(class_2338 pos, class_2350 direction, Predicate<class_2338> predicate) {
        class_2338 current = pos;
        for (int i = 1; i < 64; ++i) {
            class_2338 newPos = pos.method_10081(direction.method_10163().method_35862(i));
            if (!predicate.test(newPos)) {
                return current;
            }
            current = newPos;
        }
        return current;
    }

    private static int getFurthestLen(class_2338 pos, class_2350 direction, Predicate<class_2338> predicate) {
        for (int i = 1; i < 64; ++i) {
            class_2338 newPos = pos.method_10081(direction.method_10163().method_35862(i));
            if (predicate.test(newPos)) continue;
            return i;
        }
        return 64;
    }

    private static IntBox detectBoxSizeForErrorFeedback(class_3218 world, class_2338 pos, class_2680 blockState) {
        Predicate<class_2338> blockPredicate = p -> world.method_8320(p) == blockState;
        class_2338 currPos = pos;
        currPos = ScaleBoxEntranceCreation.getFurthest(currPos, class_2350.field_11033, blockPredicate);
        currPos = ScaleBoxEntranceCreation.getFurthest(currPos, class_2350.field_11043, blockPredicate);
        currPos = ScaleBoxEntranceCreation.getFurthest(currPos, class_2350.field_11039, blockPredicate);
        currPos = ScaleBoxEntranceCreation.getFurthest(currPos, class_2350.field_11033, blockPredicate);
        currPos = ScaleBoxEntranceCreation.getFurthest(currPos, class_2350.field_11043, blockPredicate);
        currPos = ScaleBoxEntranceCreation.getFurthest(currPos, class_2350.field_11039, blockPredicate);
        class_2338 size = new class_2338(ScaleBoxEntranceCreation.getFurthestLen(currPos, class_2350.field_11034, blockPredicate), ScaleBoxEntranceCreation.getFurthestLen(currPos, class_2350.field_11036, blockPredicate), ScaleBoxEntranceCreation.getFurthestLen(currPos, class_2350.field_11035, blockPredicate));
        return IntBox.fromBasePointAndSize((class_2338)currPos, (class_2338)size);
    }

    static {
        boxFrameMatchers = Arrays.stream(ScaleBoxGeneration.supportedScales).mapToObj(s -> new BoxFrameMatcher(new class_2338(s, s, s))).collect(Collectors.toList());
    }

    public static class BoxFrameMatcher {
        private final class_2338 size;
        private final class_2338[] vertexOffsets;

        public BoxFrameMatcher(class_2338 size) {
            this.size = size;
            this.vertexOffsets = IntBox.fromBasePointAndSize((class_2338)class_2338.field_10980, (class_2338)size).getEightVertices();
        }

        public IntBox matchFromVertex(class_2338 pos, Predicate<class_2338> blockPredicate) {
            for (class_2338 vertexOffset : this.vertexOffsets) {
                IntBox box;
                boolean allGlasses;
                class_2338 basePos = pos.method_10059((class_2382)vertexOffset);
                if (!blockPredicate.test(basePos) || !(allGlasses = Arrays.stream((box = IntBox.fromBasePointAndSize((class_2338)basePos, (class_2338)this.size)).get12Edges()).allMatch(edge -> edge.fastStream().allMatch(blockPredicate)))) continue;
                return box;
            }
            return null;
        }
    }
}

