/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.mini_scaled.ClientScaleBoxInteractionControl;
import qouteall.mini_scaled.ScaleBoxRecord;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.util.MSUtil;

public class MiniScaledPortal
extends Portal {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static class_1299<MiniScaledPortal> entityType;
    public int boxId = 0;
    public int generation = 0;
    @Nullable
    public ScaleBoxRecord.Entry recordEntry;
    private static boolean messageShown;

    public MiniScaledPortal(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void method_5773() {
        super.method_5773();
        this.setInteractable(true);
        if (this.method_37908().method_8608()) {
            this.tickClient();
        } else {
            ScaleBoxRecord scaleBoxRecord = ScaleBoxRecord.get();
            if (this.recordEntry == null) {
                this.recordEntry = scaleBoxRecord.getEntryById(this.boxId);
                if (this.recordEntry == null) {
                    LOGGER.error("Missing record for boxId {}. Deleting {}", (Object)this.boxId, (Object)this);
                    this.method_5768();
                    return;
                }
            }
            if (this.method_37908().method_8510() % 2L == 0L) {
                this.method_37908().method_16107().method_15396("scale_box_portal_update");
                ScaleBoxRecord.Entry entry = scaleBoxRecord.getEntryById(this.boxId);
                if (entry == null) {
                    LOGGER.error("no scale box record {} {}", (Object)this.boxId, (Object)this);
                    this.method_5768();
                } else if (this.generation != entry.generation) {
                    this.method_5768();
                } else {
                    this.checkStatus(entry);
                }
                this.method_37908().method_16107().method_15407();
            }
        }
    }

    private void checkStatus(ScaleBoxRecord.Entry entry) {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0);
        if (this.isOuterPortal()) {
            if (entry.currentEntranceDim == null || entry.currentEntrancePos == null) {
                LOGGER.error("Invalid record entry {}. Removing portal {}", (Object)entry, (Object)this);
                this.method_5768();
            } else {
                MinecraftServer server = this.method_5682();
                Validate.notNull((Object)server);
                class_3218 entranceDim = server.method_3847(entry.currentEntranceDim);
                if (entranceDim == null) {
                    LOGGER.error("Cannot find entrance dim {}. Removing portal {}.", entry.currentEntranceDim, (Object)this);
                    this.method_5768();
                } else if (entranceDim.method_8320(entry.currentEntrancePos).method_26204() != ScaleBoxPlaceholderBlock.instance) {
                    LOGGER.error("Entrance block invalid. {}. Removing portal {}", (Object)entry, (Object)this);
                    this.method_5768();
                }
            }
        }
    }

    protected void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.generation = compoundTag.method_10550("generation");
        this.boxId = compoundTag.method_10550("boxId");
        if (compoundTag.method_10545("recordEntry")) {
            ScaleBoxRecord.Entry entry = new ScaleBoxRecord.Entry();
            entry.readFromNbt(compoundTag.method_10562("recordEntry"));
            this.recordEntry = entry;
        } else {
            this.recordEntry = this.method_37908().method_8608() ? null : ScaleBoxRecord.get().getEntryById(this.boxId);
        }
    }

    protected void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("generation", this.generation);
        compoundTag.method_10569("boxId", this.boxId);
        if (this.recordEntry != null) {
            class_2487 recordEntryTag = new class_2487();
            this.recordEntry.writeToNbt(recordEntryTag);
            compoundTag.method_10566("recordEntry", (class_2520)recordEntryTag);
        }
    }

    private static <T extends class_1297> void registerEntity(Consumer<class_1299<T>> setEntityType, Supplier<class_1299<T>> getEntityType, String id, class_1299.class_4049<T> constructor, class_2378<class_1299<?>> registry) {
        class_1299 entityType = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, constructor).dimensions(new class_4048(1.0f, 1.0f, true)).fireImmune().trackable(96, 20).build();
        setEntityType.accept(entityType);
        class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(id), (Object)entityType);
    }

    public static void init() {
        MiniScaledPortal.registerEntity(t -> {
            entityType = t;
        }, () -> entityType, "mini_scaled:portal", MiniScaledPortal::new, class_7923.field_41177);
    }

    public boolean isOuterPortal() {
        return this.getScale() > 1.0;
    }

    public double getDestAreaRadiusEstimation() {
        return 192.0;
    }

    public boolean allowOverlappedTeleport() {
        return true;
    }

    public void onCollidingWithEntity(class_1297 entity) {
        if (this.method_37908().method_8608()) {
            this.onCollidingWithEntityClientOnly(entity);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void onCollidingWithEntityClientOnly(class_1297 entity) {
        if (this.isOuterPortal() && entity instanceof class_746) {
            class_243 gravityVec = MSUtil.getGravityVec(entity);
            if (this.getNormal().method_1026(gravityVec) < -0.5) {
                this.showShiftDescendMessage();
                class_1657 player = (class_1657)entity;
                if (player.method_18376() == class_4050.field_18081) {
                    IPGlobal.clientTaskList.addTask(() -> {
                        if (player.method_37908() == this.method_37908()) {
                            class_243 posDelta = gravityVec.method_1021(0.01);
                            player.method_23327(player.method_23317() + posDelta.field_1352, player.method_23318() + posDelta.field_1351, player.method_23321() + posDelta.field_1350);
                            McHelper.updateBoundingBox((class_1297)player);
                        }
                        return true;
                    });
                }
            }
        }
    }

    public class_243 transformVelocityRelativeToPortal(class_243 v, class_1297 entity) {
        class_243 velocity = super.transformVelocityRelativeToPortal(v, entity);
        if (this.isOuterPortal()) {
            class_243 gravityVec = MSUtil.getGravityVec(entity);
            if (this.getNormal().method_1026(gravityVec) < -0.5) {
                return velocity.method_1021(0.5);
            }
        }
        return velocity;
    }

    @Environment(value=EnvType.CLIENT)
    private void tickClient() {
    }

    @Environment(value=EnvType.CLIENT)
    private void showShiftDescendMessage() {
        if (messageShown) {
            return;
        }
        messageShown = true;
        class_310 client = class_310.method_1551();
        client.field_1705.method_1758((class_2561)class_2561.method_43469((String)"mini_scaled.press_shift", (Object[])new Object[]{client.field_1690.field_1832.method_16007()}), false);
    }

    public boolean isInteractableBy(class_1657 player) {
        boolean idMatches;
        if (this.method_37908().method_8608()) {
            return ClientScaleBoxInteractionControl.canInteractInsideScaleBox();
        }
        if (this.recordEntry != null && this.recordEntry.accessControl && !(idMatches = Objects.equals(this.recordEntry.ownerId, player.method_5667()))) {
            return false;
        }
        return super.isInteractableBy(player);
    }

    public boolean canCollideWithEntity(class_1297 entity) {
        return true;
    }

    public boolean canTeleportEntity(class_1297 entity) {
        boolean idMatches;
        if (this.recordEntry != null && this.recordEntry.accessControl && !(idMatches = Objects.equals(this.recordEntry.ownerId, entity.method_5667()))) {
            return false;
        }
        return super.canTeleportEntity(entity);
    }

    static {
        messageShown = false;
    }
}

