/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.mini_scaled.FallenEntityTeleportaion;
import qouteall.mini_scaled.MSGlobal;
import qouteall.mini_scaled.MiniScaledPortal;
import qouteall.mini_scaled.ScaleBoxEntranceCreation;
import qouteall.mini_scaled.ScaleBoxManipulation;
import qouteall.mini_scaled.VoidDimension;
import qouteall.mini_scaled.block.BoxBarrierBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlock;
import qouteall.mini_scaled.block.ScaleBoxPlaceholderBlockEntity;
import qouteall.mini_scaled.config.MiniScaledConfig;
import qouteall.mini_scaled.item.ManipulationWandItem;
import qouteall.mini_scaled.item.ScaleBoxEntranceItem;
import qouteall.q_misc_util.LifecycleHack;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class MiniScaledModInitializer
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiniScaledModInitializer.class);
    private static final LimitedLogger LIMITED_LOGGER = new LimitedLogger(50);

    public void onInitialize() {
        DimensionAPI.serverDimensionsLoadEvent.register(VoidDimension::initializeVoidDimension);
        LifecycleHack.markNamespaceStable((String)"mini_scaled");
        ScaleBoxPlaceholderBlock.init();
        BoxBarrierBlock.init();
        ScaleBoxPlaceholderBlockEntity.init();
        MiniScaledPortal.init();
        ScaleBoxEntranceItem.init();
        ManipulationWandItem.init();
        ScaleBoxEntranceCreation.init();
        IPGlobal.enableDepthClampForPortalRendering = true;
        ServerTickEvents.END_SERVER_TICK.register(FallenEntityTeleportaion::teleportFallenEntities);
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2248 block = world.method_8320(hitResult.method_17777()).method_26204();
            if (block == ScaleBoxPlaceholderBlock.instance) {
                return ScaleBoxManipulation.onHandRightClickEntrance(player, world, hand, hitResult);
            }
            return class_1269.field_5811;
        });
        MSGlobal.config = AutoConfig.register(MiniScaledConfig.class, GsonConfigSerializer::new);
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            MiniScaledConfig config = (MiniScaledConfig)AutoConfig.getConfigHolder(MiniScaledConfig.class).getConfig();
            MiniScaledModInitializer.applyConfigServerSide(config);
        });
        AutoConfig.getConfigHolder(MiniScaledConfig.class).registerSaveListener((configHolder, config) -> {
            if (MiscHelper.getServer() != null) {
                MiniScaledModInitializer.applyConfigServerSide(config);
            }
            MiniScaledModInitializer.applyConfigClientSide(config);
            return class_1269.field_5811;
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> {
            ManipulationWandItem.registerCreativeInventory(arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0));
            ScaleBoxEntranceItem.registerCreativeInventory(arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0));
        });
        LOGGER.info("MiniScaled Mod Initializing");
    }

    public static void applyConfigServerSide(MiniScaledConfig miniScaledConfig) {
        try {
            class_2960 identifier = new class_2960(miniScaledConfig.creationItem);
            class_1792 creationItem = (class_1792)class_7923.field_41178.method_10223(identifier);
            if (creationItem != class_1802.field_8162) {
                ScaleBoxEntranceCreation.creationItem = creationItem;
            } else {
                LOGGER.error("Invalid scale box creation item {}", (Object)identifier);
                ScaleBoxEntranceCreation.creationItem = class_1802.field_22020;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void applyConfigClientSide(MiniScaledConfig miniScaledConfig) {
    }
}

