/*
 * Decompiled with CFR 0.152.
 */
package qouteall.mini_scaled;

import com.mojang.datafixers.util.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.mini_scaled.MSGlobal;
import qouteall.mini_scaled.MiniScaledPortal;
import qouteall.mini_scaled.config.MiniScaledConfig;
import qouteall.mini_scaled.config.ScaleBoxInteractionMode;
import qouteall.mini_scaled.item.ManipulationWandItem;

@Environment(value=EnvType.CLIENT)
public class ClientScaleBoxInteractionControl {
    public static final double innerInteractionDistance = 2.5;
    private static boolean canInteractInsideScaleBox = false;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> ClientScaleBoxInteractionControl.update());
    }

    public static boolean canInteractInsideScaleBox() {
        return canInteractInsideScaleBox;
    }

    private static void update() {
        canInteractInsideScaleBox = false;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (client.field_1724.method_6047().method_7909() == ManipulationWandItem.instance) {
            return;
        }
        ScaleBoxInteractionMode interactionMode = ((MiniScaledConfig)MSGlobal.config.getConfig()).interactionMode;
        switch (interactionMode) {
            case normal: {
                ClientScaleBoxInteractionControl.updateOnNormalMode(client);
                break;
            }
            case crouchForInside: {
                canInteractInsideScaleBox = client.field_1724.method_18376() == class_4050.field_18081;
                break;
            }
            case crouchForOutside: {
                canInteractInsideScaleBox = client.field_1724.method_18376() != class_4050.field_18081;
            }
        }
    }

    private static void updateOnNormalMode(class_310 client) {
        double distance;
        MiniScaledPortal miniScaledPortal;
        Portal portal;
        assert (client.field_1724 != null);
        class_243 cameraPos = client.field_1724.method_33571();
        Pair raytraceResult = PortalCommand.raytracePortals((class_1937)client.field_1724.method_37908(), (class_243)cameraPos, (class_243)cameraPos.method_1019(client.field_1724.method_5828(1.0f).method_1021(10.0)), (boolean)false).orElse(null);
        if (raytraceResult != null && (portal = (Portal)raytraceResult.getFirst()) instanceof MiniScaledPortal && (miniScaledPortal = (MiniScaledPortal)portal).isOuterPortal() && (distance = miniScaledPortal.getDistanceToNearestPointInPortal(cameraPos)) < 2.5) {
            canInteractInsideScaleBox = true;
        }
    }
}

