/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.utils;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3222;
import net.minecraft.class_6328;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IClientBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IClientInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.IClientProfessionManager;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IAreasClientManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IClientTasksHolder;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksInformationHolder;
import org.jetbrains.annotations.NotNull;
import org.minefortress.MineFortressMod;
import org.minefortress.interfaces.IFortressMinecraftClient;

@class_6328
public class ModUtils {
    public static boolean isFortressGamemode(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return serverPlayer.field_13974.method_14257() == MineFortressMod.FORTRESS;
        }
        if (player instanceof class_746) {
            return ModUtils.isClientInFortressGamemode();
        }
        return false;
    }

    public static boolean isFortressGamemode(class_1309 livingEntity) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            return ModUtils.isFortressGamemode(player);
        }
        return false;
    }

    public static boolean isFortressGamemode(class_1934 gameMode) {
        return gameMode == MineFortressMod.FORTRESS;
    }

    public static IFortressMinecraftClient getFortressClient() {
        return (IFortressMinecraftClient)class_310.method_1551();
    }

    private static IClientManagersProvider getClientManagersProvider() {
        return (IClientManagersProvider)class_310.method_1551();
    }

    public static boolean isClientInFortressGamemode() {
        class_636 interactionManager = class_310.method_1551().field_1761;
        return interactionManager != null && interactionManager.method_2920() == MineFortressMod.FORTRESS;
    }

    public static Path getBlueprintsFolder() {
        return FabricLoader.getInstance().getGameDir().resolve("minefortress-blueprints");
    }

    public static UUID getCurrentPlayerUUID() {
        return Optional.ofNullable(class_310.method_1551().field_1724).map(class_1297::method_5667).orElseThrow(() -> new IllegalStateException("Player is null"));
    }

    public static IClientFortressManager getFortressClientManager() {
        return ModUtils.getClientManagersProvider().get_ClientFortressManager();
    }

    public static IClientProfessionManager getProfessionManager() {
        return ModUtils.getFortressClientManager().getProfessionManager();
    }

    public static IClientBlueprintManager getBlueprintManager() {
        return ModUtils.getClientManagersProvider().get_BlueprintManager();
    }

    public static IClientInfluenceManager getInfluenceManager() {
        return ModUtils.getClientManagersProvider().get_InfluenceManager();
    }

    public static ISelectionManager getSelectionManager() {
        return ModUtils.getClientManagersProvider().get_SelectionManager();
    }

    public static Optional<ITasksInformationHolder> getFortressClientWorld() {
        return Optional.ofNullable(class_310.method_1551()).map(it -> it.field_1687).map(ITasksInformationHolder.class::cast);
    }

    public static Optional<IClientTasksHolder> getClientTasksHolder() {
        return ModUtils.getFortressClientWorld().map(ITasksInformationHolder::get_ClientTasksHolder);
    }

    @NotNull
    public static class_746 getClientPlayer() {
        return Objects.requireNonNull(class_310.method_1551().field_1724);
    }

    public static IAreasClientManager getAreasClientManager() {
        return ModUtils.getClientManagersProvider().get_AreasClientManager();
    }

    public static boolean shouldReleaseCamera() {
        class_310 client = class_310.method_1551();
        class_315 options = client.field_1690;
        IClientBlueprintManager blueprintManager = ModUtils.getBlueprintManager();
        ISelectionManager selectionManager = ModUtils.getSelectionManager();
        IAreasClientManager areasClientManager = ModUtils.getAreasClientManager();
        IClientInfluenceManager influenceManager = ModUtils.getInfluenceManager();
        boolean anyManagerSelecting = blueprintManager.isSelecting() || selectionManager.isSelecting() || areasClientManager.isSelecting() || influenceManager.isSelecting();
        return options.field_1871.method_1434() || options.field_1867.method_1434() && !anyManagerSelecting;
    }
}

