/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;

public class GuiUtils {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String formatSlotCount(long value) {
        if (value == Long.MIN_VALUE) {
            return GuiUtils.formatSlotCount(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + GuiUtils.formatSlotCount(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        return truncated / 10L + suffix;
    }

    public static List<class_2561> splitTextInWordsForLength(String text) {
        return GuiUtils.splitTextInWordsForLength(text, 150);
    }

    public static List<class_2561> splitTextInWordsForLength(String text, int maxWidth) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        ArrayList<class_5250> preparedTextParts = new ArrayList<class_5250>();
        for (String line : text.split("\n")) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String part : line.split(" ")) {
                stringBuilder.append(part).append(" ");
                int lastPartLength = part.length();
                if (textRenderer.method_1727(stringBuilder.toString()) <= maxWidth) continue;
                stringBuilder.delete(stringBuilder.length() - lastPartLength - 1, stringBuilder.length());
                preparedTextParts.add(class_2561.method_43470((String)stringBuilder.toString()));
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append(part).append(" ");
            }
            preparedTextParts.add(class_2561.method_43470((String)stringBuilder.toString()));
        }
        return Collections.unmodifiableList(preparedTextParts);
    }

    static {
        suffixes.put(1000L, "K");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

