/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1748;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.FortressBlockPlaceContext;
import org.minefortress.entity.ai.FortressUseOnContext;

public class BlockInfoUtils {
    public static boolean shouldBePlacedAsItem(class_1792 item) {
        if (item == class_1802.field_8705 || item == class_1802.field_8187) {
            return false;
        }
        if (item instanceof class_1765) {
            return true;
        }
        if (item instanceof class_1748) {
            return true;
        }
        if (!(item instanceof class_1747)) {
            return true;
        }
        class_1747 blockItem = (class_1747)item;
        class_2248 block = blockItem.method_7711();
        boolean solid = block.method_9564().method_51367();
        if (!solid) {
            return true;
        }
        return block instanceof class_2237;
    }

    public static class_2680 getBlockStateForPlacement(class_1792 item, class_239 hitResult, class_2350 direction, class_2338 pos, Colonist colonist) {
        class_2680 stateForPlacement;
        if (BlockInfoUtils.isItemBucket(item)) {
            stateForPlacement = BlockInfoUtils.getBlockStateForBucketItem(item);
        } else {
            class_1747 blockItem = (class_1747)item;
            class_2248 block = blockItem.method_7711();
            class_1750 blockPlaceContext = BlockInfoUtils.getBlockPlaceContext(hitResult, direction, item, pos, colonist);
            stateForPlacement = Optional.ofNullable(block.method_9605(blockPlaceContext)).orElse(block.method_9564());
        }
        return stateForPlacement;
    }

    private static class_2680 getBlockStateForBucketItem(class_1792 item) {
        if (item == class_1802.field_8705) {
            return class_3612.field_15910.method_15785().method_15759();
        }
        if (item == class_1802.field_8187) {
            return class_3612.field_15908.method_15785().method_15759();
        }
        return class_2246.field_10124.method_9564();
    }

    public static class_1838 getUseOnContext(class_239 hitResult, class_1792 placingItem, class_2338 goal, class_3218 world, Colonist colonist) {
        if (hitResult instanceof class_3965) {
            class_3222 masterPlayer = (class_3222)colonist.getMasterPlayer().or(() -> Optional.ofNullable(colonist.method_5682()).map(MinecraftServer::method_30002).map(class_3218::method_18779)).orElseThrow(() -> new IllegalStateException("Colonist has no master player"));
            class_3965 movedHitResult = BlockInfoUtils.moveHitResult((class_3965)hitResult, goal);
            return new FortressUseOnContext((class_1937)world, (class_1657)masterPlayer, class_1268.field_5808, new class_1799((class_1935)placingItem), movedHitResult);
        }
        return null;
    }

    private static boolean isItemBucket(class_1792 item) {
        return item == class_1802.field_8705 || item == class_1802.field_8187 || item instanceof class_1755;
    }

    private static class_1750 getBlockPlaceContext(class_239 hitResult, class_2350 horizontalDirection, class_1792 placingItem, class_2338 goal, Colonist colonist) {
        if (hitResult instanceof class_3965) {
            class_3222 randomPlayer = (class_3222)colonist.getMasterPlayer().or(() -> Optional.ofNullable(colonist.method_5682()).map(MinecraftServer::method_30002).map(class_3218::method_18779)).orElseThrow(() -> new IllegalStateException("Colonist has no master player"));
            class_3965 movedHitResult = BlockInfoUtils.moveHitResult((class_3965)hitResult, goal);
            if (horizontalDirection != null) {
                return new FortressBlockPlaceContext((class_1657)randomPlayer, class_1268.field_5808, new class_1799((class_1935)placingItem, 64), movedHitResult, horizontalDirection);
            }
            return new class_1750((class_1657)randomPlayer, class_1268.field_5808, new class_1799((class_1935)placingItem, 64), movedHitResult);
        }
        return null;
    }

    private static class_3965 moveHitResult(class_3965 blockHitResult, class_2338 goal) {
        class_2338 clickedPos = goal.method_10093(blockHitResult.method_17780().method_10153()).method_10062();
        return blockHitResult.method_29328(clickedPos);
    }

    @NotNull
    public static Map<class_1792, Long> convertBlockStatesMapItemsMap(Map<class_2338, class_2680> blocksToRepair) {
        Map<class_1792, Long> amountOfRequiredItems = blocksToRepair.entrySet().stream().collect(Collectors.groupingBy(it -> ((class_2680)it.getValue()).method_26204().method_8389(), Collectors.counting()));
        for (class_1792 item : Collections.unmodifiableSet(amountOfRequiredItems.keySet())) {
            class_1747 blockItem;
            class_2680 defaultBlockState;
            if (!(item instanceof class_1747) || !(defaultBlockState = (blockItem = (class_1747)item).method_7711().method_9564()).method_26164(class_3481.field_15495) && !defaultBlockState.method_26164(class_3481.field_16443)) continue;
            amountOfRequiredItems.put(item, amountOfRequiredItems.get(item) / 2L);
        }
        return amountOfRequiredItems;
    }
}

