/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.tasks;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.selections.ServerSelectionType;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskBlockInfo;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskPart;
import net.remmintan.mods.minefortress.core.utils.PathUtils;
import org.minefortress.entity.Colonist;
import org.minefortress.tasks.AbstractTask;
import org.minefortress.tasks.TaskPart;
import org.minefortress.tasks.block.info.BlockStateTaskBlockInfo;
import org.minefortress.tasks.block.info.DigTaskBlockInfo;
import org.minefortress.tasks.block.info.ItemTaskBlockInfo;
import org.minefortress.utils.BlockInfoUtils;

public class SimpleSelectionTask
extends AbstractTask {
    private final class_239 hitResult;
    private final class_2350 horizontalDirection;
    private final ServerSelectionType selectionType;
    private class_1792 placingItem;

    public SimpleSelectionTask(UUID id, TaskType taskType, class_2338 startingBlock, class_2338 endingBlock, class_239 hitResult, ServerSelectionType selectionType) {
        super(id, taskType, startingBlock, endingBlock);
        this.selectionType = selectionType;
        boolean shouldSwapStartAndEnd = this.isShouldSwapEnds(taskType, startingBlock, endingBlock, selectionType);
        if (shouldSwapStartAndEnd) {
            this.startingBlock = endingBlock;
            this.endingBlock = startingBlock;
        } else {
            this.startingBlock = startingBlock;
            this.endingBlock = endingBlock;
        }
        if (selectionType == ServerSelectionType.LADDER && hitResult instanceof class_3965) {
            this.horizontalDirection = startingBlock.method_10263() > endingBlock.method_10263() ? class_2350.field_11039 : class_2350.field_11034;
            this.hitResult = new class_3965(hitResult.method_17784(), class_2350.field_11036, ((class_3965)hitResult).method_17777(), ((class_3965)hitResult).method_17781());
        } else if (selectionType == ServerSelectionType.LADDER_Z_DIRECTION && hitResult instanceof class_3965) {
            this.horizontalDirection = startingBlock.method_10260() > endingBlock.method_10260() ? class_2350.field_11043 : class_2350.field_11035;
            this.hitResult = new class_3965(hitResult.method_17784(), class_2350.field_11036, ((class_3965)hitResult).method_17777(), ((class_3965)hitResult).method_17781());
        } else {
            this.hitResult = hitResult;
            this.horizontalDirection = null;
        }
    }

    private boolean isShouldSwapEnds(TaskType taskType, class_2338 startingBlock, class_2338 endingBlock, ServerSelectionType selectionType) {
        boolean removeFromBottomToTop = taskType == TaskType.REMOVE && endingBlock.method_10264() > startingBlock.method_10264();
        boolean buildFromTopToBottom = taskType == TaskType.BUILD && endingBlock.method_10264() < startingBlock.method_10264();
        boolean isLadder = selectionType == ServerSelectionType.LADDER || selectionType == ServerSelectionType.LADDER_Z_DIRECTION;
        return !isLadder && (removeFromBottomToTop || buildFromTopToBottom);
    }

    @Override
    public void prepareTask() {
        if (this.selectionType == ServerSelectionType.WALLS_EVERY_SECOND) {
            this.parts.add(Pair.of((Object)this.startingBlock, (Object)this.endingBlock));
            this.totalParts = 1;
        } else {
            super.prepareTask();
        }
    }

    public void setPlacingItem(class_1792 placingItem) {
        this.placingItem = placingItem;
    }

    public class_1792 getPlacingItem() {
        return this.placingItem;
    }

    @Override
    public ITaskPart getNextPart(class_3218 world, IWorkerPawn colonist) {
        Pair startAndEnd = (Pair)this.parts.poll();
        if (startAndEnd == null) {
            throw new IllegalStateException("Null part for task!");
        }
        List<ITaskBlockInfo> blocks = this.getPartBlocksInfo((Pair<class_2338, class_2338>)startAndEnd, world, colonist);
        return new TaskPart((Pair<class_2338, class_2338>)startAndEnd, blocks, this);
    }

    private List<ITaskBlockInfo> getPartBlocksInfo(Pair<class_2338, class_2338> startAndEnd, class_3218 world, IWorkerPawn colonist) {
        ArrayList<ITaskBlockInfo> blocksInfo = new ArrayList<ITaskBlockInfo>();
        this.getBlocksForPart(startAndEnd).spliterator().forEachRemaining(pos -> {
            pos = pos.method_10062();
            if (this.placingItem != null) {
                if (BlockInfoUtils.shouldBePlacedAsItem(this.placingItem)) {
                    class_1838 useOnContext = BlockInfoUtils.getUseOnContext(this.hitResult, this.placingItem, pos, world, (Colonist)colonist);
                    ItemTaskBlockInfo itemTaskBlockInfo = new ItemTaskBlockInfo(this.placingItem, (class_2338)pos, useOnContext);
                    blocksInfo.add(itemTaskBlockInfo);
                } else {
                    class_2680 blockStateForPlacement = BlockInfoUtils.getBlockStateForPlacement(this.placingItem, this.hitResult, this.horizontalDirection, pos, (Colonist)colonist);
                    BlockStateTaskBlockInfo blockStateTaskBlockInfo = new BlockStateTaskBlockInfo(this.placingItem, (class_2338)pos, blockStateForPlacement);
                    blocksInfo.add(blockStateTaskBlockInfo);
                }
            } else {
                blocksInfo.add(new DigTaskBlockInfo((class_2338)pos));
            }
        });
        return blocksInfo;
    }

    public Iterable<class_2338> getBlocksForPart(Pair<class_2338, class_2338> part) {
        if (this.selectionType == ServerSelectionType.LADDER) {
            return PathUtils.getLadderSelection(this.startingBlock, (class_2338)part.getFirst(), (class_2338)part.getSecond(), class_2350.class_2351.field_11048);
        }
        if (this.selectionType == ServerSelectionType.LADDER_Z_DIRECTION) {
            return PathUtils.getLadderSelection(this.startingBlock, (class_2338)part.getFirst(), (class_2338)part.getSecond(), class_2350.class_2351.field_11051);
        }
        return PathUtils.fromStartToEnd((class_2338)part.getFirst(), (class_2338)part.getSecond(), this.selectionType == ServerSelectionType.WALLS_EVERY_SECOND);
    }
}

