/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.tasks;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.selections.ServerSelectionType;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IServerTaskManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskPart;
import org.jetbrains.annotations.NotNull;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.tasks.CutTreesTask;
import org.minefortress.tasks.RoadsTask;
import org.minefortress.tasks.SimpleSelectionTask;

public class ServerTaskManager
implements IServerTaskManager {
    private static final Set<String> BUILDER_PROFESSIONS = Set.of("miner1", "miner2", "miner3", "colonist");
    private final Deque<ITask> tasks = new ArrayDeque<ITask>();
    private final Set<UUID> cancelledTasks = new HashSet<UUID>();

    @Override
    public void tick(IServerFortressManager manager, class_3218 world) {
        if (!this.hasTask()) {
            return;
        }
        ITask task = this.getTask();
        List<IWorkerPawn> freeColonists = manager.getFreeColonists();
        if (freeColonists.isEmpty()) {
            return;
        }
        TaskType taskType = task.getTaskType();
        if (taskType == TaskType.BUILD) {
            List<IWorkerPawn> completelyFreePawns = this.getCompletelyFreePawns(task, freeColonists);
            boolean fullyCompleted = this.setPawnsToTask(world, task, completelyFreePawns);
            if (fullyCompleted) {
                return;
            }
            List<IWorkerPawn> otherPawns = freeColonists.stream().filter(c -> ServerTaskManager.isBuilderProfession(c.getProfessionId())).filter(c -> c.getTaskControl().canStartTask(task)).filter(c -> c.getTaskControl().isDoingEverydayTasks()).collect(Collectors.toList());
            this.setPawnsToTask(world, task, otherPawns);
        } else {
            List<String> professions = this.getProfessionIdFromTask(task);
            List<IWorkerPawn> professionals = freeColonists.stream().filter(c -> professions.contains(c.getProfessionId())).filter(c -> c.getTaskControl().canStartTask(task)).collect(Collectors.toList());
            boolean fullyCompleted = this.setPawnsToTask(world, task, professionals);
            if (fullyCompleted) {
                return;
            }
            List<IWorkerPawn> completelyFreePawns = this.getCompletelyFreePawns(task, freeColonists);
            this.setPawnsToTask(world, task, completelyFreePawns);
        }
    }

    @Override
    public void addTask(ITask task, IServerManagersProvider provider, IServerFortressManager manager) {
        task.prepareTask();
        if (task.hasAvailableParts()) {
            if (task instanceof SimpleSelectionTask) {
                SimpleSelectionTask simpleSelectionTask = (SimpleSelectionTask)task;
                if (manager.isSurvival() && task.getTaskType() == TaskType.BUILD) {
                    Spliterator<class_2338> spliterator = simpleSelectionTask.getBlocksForPart((Pair<class_2338, class_2338>)Pair.of((Object)simpleSelectionTask.getStartingBlock(), (Object)simpleSelectionTask.getEndingBlock())).spliterator();
                    int blocksCount = (int)StreamSupport.stream(spliterator, false).count();
                    class_1792 placingItem = simpleSelectionTask.getPlacingItem();
                    ItemInfo info = new ItemInfo(placingItem, blocksCount);
                    provider.getResourceManager().reserveItems(task.getId(), Collections.singletonList(info));
                }
            }
            this.tasks.add(task);
        }
    }

    @Override
    public void cancelTask(UUID id, IServerManagersProvider provider, IServerFortressManager manager) {
        this.cancelledTasks.add(id);
        provider.getResourceManager().returnReservedItems(id);
        this.tasks.removeIf(task -> task.getId().equals(id));
    }

    @NotNull
    private List<IWorkerPawn> getCompletelyFreePawns(ITask task, List<IWorkerPawn> freeColonists) {
        return freeColonists.stream().filter(c -> ServerTaskManager.isBuilderProfession(c.getProfessionId())).filter(c -> c.getTaskControl().canStartTask(task)).filter(c -> !c.getTaskControl().isDoingEverydayTasks()).collect(Collectors.toList());
    }

    private List<String> getProfessionIdFromTask(ITask task) {
        if (task instanceof CutTreesTask) {
            return Arrays.asList("lumberjack1", "lumberjack2", "lumberjack3");
        }
        return Arrays.asList("miner1", "miner2", "miner3");
    }

    private static boolean isBuilderProfession(String professionId) {
        return BUILDER_PROFESSIONS.contains(professionId);
    }

    private boolean setPawnsToTask(class_3218 world, ITask task, List<IWorkerPawn> completelyFreePawns) {
        for (IWorkerPawn c : completelyFreePawns) {
            if (!task.hasAvailableParts()) break;
            c.getTaskControl().setTask(task, task.getNextPart(world, c), this::returnTaskPart, () -> this.isCancelled(task.getId()));
        }
        if (!task.hasAvailableParts()) {
            this.tasks.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTask() {
        return !this.tasks.isEmpty();
    }

    @Override
    public ITask createCutTreesTask(UUID uuid, List<class_2338> treeRoots) {
        return new CutTreesTask(uuid, treeRoots);
    }

    @Override
    public ITask createRoadsTask(UUID digUuid, TaskType type, UUID placeUuid, List<class_2338> blocks, class_1792 itemInHand, Runnable onComplete) {
        return new RoadsTask(placeUuid, type, blocks, itemInHand, onComplete);
    }

    @Override
    public ITask createSelectionTask(UUID id, TaskType taskType, class_2338 start, class_2338 end, ServerSelectionType selectionType, class_239 hitResult, class_3222 player) {
        SimpleSelectionTask simpleSelectionTask = new SimpleSelectionTask(id, taskType, start, end, hitResult, selectionType);
        if (simpleSelectionTask.getTaskType() == TaskType.BUILD) {
            class_1799 itemInHand = player.method_5998(class_1268.field_5808);
            if (itemInHand != class_1799.field_8037) {
                simpleSelectionTask.setPlacingItem(itemInHand.method_7909());
            } else {
                throw new IllegalStateException();
            }
        }
        return simpleSelectionTask;
    }

    private ITask getTask() {
        return this.tasks.element();
    }

    private void returnTaskPart(ITaskPart taskPart) {
        ITask task = taskPart.getTask();
        task.returnPart(taskPart.getStartAndEnd());
        if (!this.tasks.contains(task)) {
            this.tasks.addFirst(task);
        }
    }

    private boolean isCancelled(UUID id) {
        return this.cancelledTasks.contains(id);
    }
}

