/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.tasks;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskPart;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundTaskExecutedPacket;
import org.jetbrains.annotations.NotNull;
import org.minefortress.tasks.TaskPart;
import org.minefortress.tasks.block.info.BlockStateTaskBlockInfo;
import org.minefortress.tasks.block.info.DigTaskBlockInfo;
import org.minefortress.utils.BlockUtils;

public class RoadsTask
implements ITask {
    private final UUID id;
    private final TaskType taskType;
    private final class_1792 item;
    private final List<class_2338> blocks;
    private final Queue<ITaskPart> taskParts = new ArrayDeque<ITaskPart>();
    private final int totalParts;
    private int finishedParts = 0;
    private final Runnable onComplete;

    public RoadsTask(UUID id, TaskType taskType, List<class_2338> blocks, class_1792 item, Runnable onComplete) {
        this.id = id;
        this.taskType = taskType;
        this.onComplete = onComplete;
        this.blocks = blocks;
        this.item = item;
        this.totalParts = this.prepareParts();
    }

    private int prepareParts() {
        ArrayList<class_2338> partBlocks = new ArrayList<class_2338>();
        int partCounter = 0;
        for (class_2338 block : this.blocks) {
            partBlocks.add(block);
            if (partCounter++ <= 9) continue;
            ITaskPart taskPart = this.createTaskPart(partBlocks);
            this.taskParts.add(taskPart);
            partBlocks.clear();
            partCounter = 0;
        }
        if (!partBlocks.isEmpty()) {
            ITaskPart taskPart = this.createTaskPart(partBlocks);
            this.taskParts.add(taskPart);
        }
        return this.taskParts.size();
    }

    @NotNull
    private ITaskPart createTaskPart(List<class_2338> partBlocks) {
        class_2338 first = partBlocks.get(0);
        class_2338 last = partBlocks.get(partBlocks.size() - 1);
        Pair partStartAndEnd = Pair.of((Object)first, (Object)last);
        List blocks = partBlocks.stream().map(pos -> {
            if (Objects.isNull(this.item)) {
                return new DigTaskBlockInfo((class_2338)pos);
            }
            return new BlockStateTaskBlockInfo(this.item, (class_2338)pos, BlockUtils.getBlockStateFromItem(this.item));
        }).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        return new TaskPart((Pair<class_2338, class_2338>)partStartAndEnd, blocks, this);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public boolean hasAvailableParts() {
        return !this.taskParts.isEmpty();
    }

    @Override
    public ITaskPart getNextPart(class_3218 level, IWorkerPawn colonist) {
        return this.taskParts.poll();
    }

    @Override
    public void returnPart(Pair<class_2338, class_2338> partStartAndEnd) {
        class_2338 partStart = (class_2338)partStartAndEnd.getFirst();
        int i = this.blocks.indexOf(partStart);
        if (i != -1) {
            ArrayList<class_2338> partBlocks = new ArrayList<class_2338>();
            for (int j = i; j < this.blocks.size() && j - i <= 10; ++j) {
                partBlocks.add(this.blocks.get(j));
            }
            ITaskPart taskPart = this.createTaskPart(partBlocks);
            this.taskParts.add(taskPart);
        }
    }

    @Override
    public void finishPart(ITaskPart part, IWorkerPawn colonist) {
        class_3218 world = colonist.getServerWorld();
        ++this.finishedParts;
        if (this.taskParts.isEmpty() && this.finishedParts == this.totalParts) {
            world.method_18456().stream().findAny().ifPresent(player -> FortressServerNetworkHelper.send(player, "finish_task", new ClientboundTaskExecutedPacket(this.getId())));
            this.onComplete.run();
        }
    }
}

