/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.tasks;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.remmintan.gobi.helpers.TreeBlocks;
import net.remmintan.gobi.helpers.TreeHelper;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskPart;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundTaskExecutedPacket;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.controls.DigControl;
import org.minefortress.tasks.TaskPart;
import org.minefortress.tasks.block.info.DigTaskBlockInfo;

public class CutTreesTask
implements ITask {
    private final UUID uuid;
    private final Queue<class_2338> treeRoots;
    private final int totalRootCount;
    private int removedRoots = 0;

    public CutTreesTask(UUID uuid, List<class_2338> treeRoots) {
        this.uuid = uuid;
        this.treeRoots = new ArrayDeque<class_2338>(treeRoots);
        this.totalRootCount = treeRoots.size();
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.REMOVE;
    }

    @Override
    public boolean hasAvailableParts() {
        return !this.treeRoots.isEmpty();
    }

    @Override
    public ITaskPart getNextPart(class_3218 level, IWorkerPawn colonist) {
        if (!this.treeRoots.isEmpty()) {
            class_2338 root = this.treeRoots.remove();
            DigTaskBlockInfo rootBlockInfo = new DigTaskBlockInfo(root);
            return new TaskPart((Pair<class_2338, class_2338>)Pair.of((Object)root, (Object)root), Collections.singletonList(rootBlockInfo), this);
        }
        return null;
    }

    @Override
    public void returnPart(Pair<class_2338, class_2338> partStartAndEnd) {
        class_2338 root = (class_2338)partStartAndEnd.getFirst();
        this.treeRoots.add(root);
    }

    @Override
    public void finishPart(ITaskPart part, IWorkerPawn colonist) {
        class_2338 root;
        Optional<TreeBlocks> treeOpt;
        class_3218 world = colonist.getServerWorld();
        if (part != null && part.getStartAndEnd() != null && part.getStartAndEnd().getFirst() != null && (treeOpt = TreeHelper.getTreeBlocks((root = (class_2338)part.getStartAndEnd().getFirst()).method_10084(), (class_1937)world)).isPresent()) {
            TreeBlocks tree = treeOpt.get();
            tree.getTreeBlocks().forEach(blockPos -> {
                DigControl.addDropToTheResourceManager(world, blockPos, (Colonist)colonist);
                world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                world.method_33596((class_1297)colonist, class_5712.field_28165, blockPos);
            });
            tree.getLeavesBlocks().forEach(blockPos -> {
                DigControl.addDropToTheResourceManager(world, blockPos, (Colonist)colonist);
                world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                world.method_33596((class_1297)colonist, class_5712.field_28165, blockPos);
            });
        }
        ++this.removedRoots;
        if (this.treeRoots.isEmpty() && this.removedRoots <= this.totalRootCount) {
            world.method_18456().stream().findAny().ifPresent(player -> FortressServerNetworkHelper.send(player, "finish_task", new ClientboundTaskExecutedPacket(this.getId())));
        }
    }
}

