/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.tasks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.class_2338;
import net.remmintan.gobi.ClientSelection;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IClientTask;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IClientTasksHolder;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksModelBuilderInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksRenderInfoProvider;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundCancelTaskPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.joml.Vector4f;

public class ClientVisualTasksHolder
implements ITasksModelBuilderInfoProvider,
ITasksRenderInfoProvider,
IClientTasksHolder {
    private static final Vector4f DESTROY_COLOR = new Vector4f(0.6666667f, 0.0f, 0.0f, 1.0f);
    private static final Vector4f BUILD_COLOR = new Vector4f(0.0f, 0.6666667f, 0.0f, 1.0f);
    private final Map<UUID, UUID> subtasksMap = new HashMap<UUID, UUID>();
    private final Map<UUID, IClientTask> removeTasks = new HashMap<UUID, IClientTask>();
    private final Map<UUID, IClientTask> buildTasks = new HashMap<UUID, IClientTask>();
    private final Stack<UUID> tasksStack = new Stack();
    private boolean selectionHidden = false;
    private boolean needRebuild = false;

    @Override
    public void cancelTask() {
        if (this.tasksStack.empty()) {
            return;
        }
        UUID lastTaskId = this.tasksStack.pop();
        this.subtasksMap.entrySet().stream().filter(it -> ((UUID)it.getValue()).equals(lastTaskId)).map(Map.Entry::getKey).forEach(it -> {
            this.removeTask((UUID)it);
            FortressClientNetworkHelper.send("cancel_task", new ServerboundCancelTaskPacket((UUID)it));
        });
        this.removeTask(lastTaskId);
        FortressClientNetworkHelper.send("cancel_task", new ServerboundCancelTaskPacket(lastTaskId));
    }

    @Override
    public void cancelAllTasks() {
        while (!this.tasksStack.empty()) {
            this.cancelTask();
        }
    }

    @Override
    public void addRoadsSelectionTask(UUID digTaskId, UUID placeTaskId, List<class_2338> positions) {
        this.addTask(digTaskId, positions, TaskType.REMOVE);
        this.addTask(placeTaskId, positions, TaskType.BUILD);
    }

    @Override
    public void addTask(UUID uuid, Iterable<class_2338> blocks) {
        this.addTask(uuid, blocks, TaskType.BUILD);
    }

    @Override
    public void addTask(UUID uuid, Iterable<class_2338> blocks, TaskType type) {
        this.addTask(uuid, blocks, type, null);
    }

    @Override
    public void addTask(UUID uuid, Iterable<class_2338> blocks, TaskType type, UUID superTaskId) {
        ClientSelection newTask = new ClientSelection(blocks, type == TaskType.REMOVE ? DESTROY_COLOR : BUILD_COLOR, (w, p) -> type == TaskType.REMOVE ? BuildingHelper.canRemoveBlock(w, p) : BuildingHelper.canPlaceBlock(w, p));
        if (superTaskId != null) {
            this.subtasksMap.put(uuid, superTaskId);
        }
        if (type == TaskType.REMOVE) {
            this.removeTasks.put(uuid, newTask);
        } else {
            this.buildTasks.put(uuid, newTask);
        }
        this.tasksStack.push(uuid);
        this.setNeedRebuild(true);
    }

    @Override
    public Set<IClientTask> getAllSelections() {
        HashSet<IClientTask> clientSelections = new HashSet<IClientTask>(this.buildTasks.values());
        clientSelections.addAll(this.removeTasks.values());
        return clientSelections;
    }

    @Override
    public void removeTask(UUID uuid) {
        if (this.buildTasks.containsKey(uuid)) {
            this.buildTasks.remove(uuid);
        } else {
            this.removeTasks.remove(uuid);
        }
        this.subtasksMap.remove(uuid);
        this.tasksStack.remove(uuid);
        this.setNeedRebuild(true);
    }

    @Override
    public boolean isNeedRebuild() {
        return this.needRebuild;
    }

    @Override
    public void setNeedRebuild(boolean needRebuild) {
        this.needRebuild = needRebuild;
    }

    @Override
    public boolean shouldRender() {
        return !this.selectionHidden && (this.removeTasks.size() > 0 || this.buildTasks.size() > 0);
    }

    @Override
    public void toggleSelectionVisibility() {
        this.selectionHidden = !this.selectionHidden;
    }

    @Override
    public boolean isSelectionHidden() {
        return this.selectionHidden;
    }

    public boolean isEmpty() {
        return this.buildTasks.isEmpty() && this.removeTasks.isEmpty();
    }
}

