/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.tasks;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.buildings.IServerBuildingsManager;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IFortressAwareEntity;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskBlockInfo;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskPart;
import org.jetbrains.annotations.NotNull;
import org.minefortress.fortress.buildings.FortressBuilding;
import org.minefortress.fortress.resources.SimilarItemsHelper;
import org.minefortress.tasks.AbstractTask;
import org.minefortress.tasks.TaskPart;
import org.minefortress.tasks.block.info.BlockStateTaskBlockInfo;

public class BlueprintTask
extends AbstractTask {
    private final Map<class_2338, class_2680> blueprintData;
    private final Map<class_2338, class_2680> blueprintEntityData;
    private final Map<class_2338, class_2680> blueprintAutomaticData;
    private final int floorLevel;
    private final String requirementId;
    private final String blueprintId;

    public BlueprintTask(UUID id, class_2338 startingPos, class_2338 endingPos, Map<class_2338, class_2680> blueprintData, Map<class_2338, class_2680> blueprintEntityData, Map<class_2338, class_2680> blueprintAutomaticData, int floorLevel, String requirementId, @NotNull String blueprintId) {
        super(id, TaskType.BUILD, startingPos, endingPos);
        this.blueprintData = blueprintData;
        this.blueprintEntityData = blueprintEntityData;
        this.blueprintAutomaticData = blueprintAutomaticData;
        this.floorLevel = floorLevel;
        this.requirementId = requirementId;
        this.blueprintId = blueprintId;
    }

    @Override
    public ITaskPart getNextPart(class_3218 level, IWorkerPawn colonist) {
        Pair partStartAndEnd = (Pair)this.parts.poll();
        List<ITaskBlockInfo> blockInfos = this.getTaskBlockInfos((Pair<class_2338, class_2338>)partStartAndEnd);
        return new TaskPart((Pair<class_2338, class_2338>)partStartAndEnd, blockInfos, this);
    }

    @NotNull
    private List<ITaskBlockInfo> getTaskBlockInfos(Pair<class_2338, class_2338> partStartAndEnd) {
        class_2338 start = (class_2338)partStartAndEnd.getFirst();
        class_2338 delta = start.method_10059((class_2382)this.startingBlock);
        Iterable allPositionsInPart = class_2338.method_10097((class_2338)start, (class_2338)((class_2338)partStartAndEnd.getSecond()));
        ArrayList<ITaskBlockInfo> blockInfos = new ArrayList<ITaskBlockInfo>();
        for (class_2338 pos : allPositionsInPart) {
            class_2680 state = this.blueprintData.getOrDefault(pos.method_10059((class_2382)start).method_10081((class_2382)delta), pos.method_10059((class_2382)start).method_10081((class_2382)delta).method_10264() < this.floorLevel ? class_2246.field_10566.method_9564() : class_2246.field_10124.method_9564());
            if (state.method_26215()) continue;
            BlockStateTaskBlockInfo blockStateTaskBlockInfo = new BlockStateTaskBlockInfo(BlueprintTask.getItemFromState(state), pos.method_10062(), state);
            blockInfos.add(blockStateTaskBlockInfo);
        }
        return blockInfos;
    }

    @Override
    public void finishPart(ITaskPart part, IWorkerPawn colonist) {
        class_3218 world = colonist.getServerWorld();
        if (this.parts.isEmpty() && this.getCompletedParts() + 1 >= this.totalParts) {
            if (this.blueprintEntityData != null) {
                this.blueprintEntityData.forEach((pos, state) -> {
                    class_2338 realPos = pos.method_10081((class_2382)this.startingBlock);
                    world.method_8652(realPos, state, 3);
                    class_1792 item = state.method_26204().method_8389();
                    this.removeReservedItem(colonist, item);
                    this.addSpecialBlueprintBlock(colonist, state.method_26204(), realPos);
                });
            }
            if (this.blueprintAutomaticData != null) {
                this.blueprintAutomaticData.forEach((pos, state) -> {
                    class_2338 realpos = pos.method_10081((class_2382)this.startingBlock);
                    world.method_8652(realpos, state, 3);
                    this.addSpecialBlueprintBlock(colonist, state.method_26204(), realpos);
                    if (!state.method_26164(class_3481.field_16443) || state.method_11654((class_2769)class_2244.field_9967) != class_2742.field_12557) {
                        this.removeReservedItem(colonist, state.method_26204().method_8389());
                    }
                });
            }
            HashMap<class_2338, class_2680> mergeBlockData = new HashMap<class_2338, class_2680>(this.blueprintData);
            if (this.blueprintEntityData != null) {
                mergeBlockData.putAll(this.blueprintEntityData);
            }
            if (this.blueprintAutomaticData != null) {
                mergeBlockData.putAll(this.blueprintAutomaticData);
            }
            FortressBuilding fortressBuilding = new FortressBuilding(UUID.randomUUID(), this.startingBlock, this.endingBlock, this.requirementId, this.blueprintId, this.floorLevel, mergeBlockData);
            IServerFortressManager manager = colonist.getServerFortressManager().orElseThrow();
            manager.expandTheVillage(fortressBuilding.getStart());
            manager.expandTheVillage(fortressBuilding.getEnd());
            IServerManagersProvider provider = colonist.getManagersProvider().orElseThrow();
            IServerBuildingsManager buildingManager = provider.getBuildingsManager();
            buildingManager.addBuilding(fortressBuilding);
        }
        super.finishPart(part, colonist);
    }

    private void addSpecialBlueprintBlock(IWorkerPawn colonist, class_2248 block, class_2338 pos) {
        colonist.getServerFortressManager().orElseThrow().addSpecialBlocks(block, pos, true);
    }

    private void removeReservedItem(IFortressAwareEntity colonist, class_1792 item) {
        IServerManagersProvider provider = colonist.getManagersProvider().orElseThrow();
        IServerFortressManager manager = colonist.getServerFortressManager().orElseThrow();
        if (manager.isSurvival()) {
            IServerResourceManager resourceManager = provider.getResourceManager();
            if (SimilarItemsHelper.isIgnorable(item)) {
                resourceManager.removeItemIfExists(this.getId(), item);
            } else {
                resourceManager.removeReservedItem(this.getId(), item);
            }
        }
    }
}

