/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.tasks;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskPart;
import net.remmintan.mods.minefortress.core.utils.PathUtils;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundTaskExecutedPacket;

public abstract class AbstractTask
implements ITask {
    protected static final int PART_SIZE = 3;
    private final UUID id;
    private final TaskType taskType;
    protected class_2338 startingBlock;
    protected class_2338 endingBlock;
    protected final Queue<Pair<class_2338, class_2338>> parts = new ArrayDeque<Pair<class_2338, class_2338>>();
    protected int totalParts;
    private int completedParts;
    private final List<Runnable> taskFinishListeners = new ArrayList<Runnable>();

    protected AbstractTask(UUID id, TaskType taskType, class_2338 startingBlock, class_2338 endingBlock) {
        this.id = id;
        this.taskType = taskType;
        this.startingBlock = startingBlock;
        this.endingBlock = endingBlock;
    }

    public class_2338 getStartingBlock() {
        return this.startingBlock;
    }

    public class_2338 getEndingBlock() {
        return this.endingBlock;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public boolean hasAvailableParts() {
        return !this.parts.isEmpty();
    }

    @Override
    public void returnPart(Pair<class_2338, class_2338> part) {
        this.parts.add(part);
    }

    @Override
    public void prepareTask() {
        class_2338.class_2339 cursor = this.startingBlock.method_25503();
        class_2382 direction = PathUtils.getDirection(this.startingBlock, this.endingBlock);
        while (true) {
            class_2338 start = cursor.method_10062();
            class_2338 end = this.createPartEnd(start, direction);
            this.parts.add((Pair<class_2338, class_2338>)Pair.of((Object)start, (Object)end));
            if (end.method_10263() * direction.method_10263() >= this.endingBlock.method_10263() * direction.method_10263()) {
                if (end.method_10260() * direction.method_10260() >= this.endingBlock.method_10260() * direction.method_10260()) break;
                cursor.method_33097(this.startingBlock.method_10263());
                cursor.method_10100(0, 0, 3 * direction.method_10260());
                continue;
            }
            cursor.method_10100(direction.method_10263() * 3, 0, 0);
        }
        this.totalParts = this.parts.size();
    }

    @Override
    public void finishPart(ITaskPart part, IWorkerPawn colonsit) {
        ++this.completedParts;
        if (this.parts.isEmpty() && this.totalParts <= this.completedParts) {
            colonsit.getMasterPlayer().ifPresent(this::sendFinishTaskNotificationToPlayer);
            this.taskFinishListeners.forEach(Runnable::run);
        }
    }

    protected void sendFinishTaskNotificationToPlayer(class_3222 randomPlayer) {
        FortressServerNetworkHelper.send(randomPlayer, "finish_task", new ClientboundTaskExecutedPacket(this.getId()));
    }

    @Override
    public void addFinishListener(Runnable listener) {
        this.taskFinishListeners.add(listener);
    }

    protected int getCompletedParts() {
        return this.completedParts;
    }

    protected static class_1792 getItemFromState(class_2680 state) {
        class_2248 block = state.method_26204();
        return block.method_8389();
    }

    private class_2338 createPartEnd(class_2338 start, class_2382 direction) {
        class_2338.class_2339 cursor = start.method_25503();
        cursor.method_33098(this.endingBlock.method_10264());
        cursor.method_10100(2 * direction.method_10263(), 0, 2 * direction.method_10260());
        if (cursor.method_10263() * direction.method_10263() > this.endingBlock.method_10263() * direction.method_10263()) {
            cursor.method_33097(this.endingBlock.method_10263());
        }
        if (cursor.method_10260() * direction.method_10260() > this.endingBlock.method_10260() * direction.method_10260()) {
            cursor.method_33099(this.endingBlock.method_10260());
        }
        return cursor.method_10062();
    }
}

