/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.widget;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import org.minefortress.renderer.gui.hud.interfaces.IHudButton;
import org.minefortress.renderer.gui.hud.interfaces.IItemHudElement;

public class ItemButtonWidget
extends class_344
implements IHudButton,
IItemHudElement {
    protected static final class_2960 FORTRESS_BUTTON_TEXTURE = new class_2960("minefortress", "textures/gui/button.png");
    protected static final int FORTRESS_BUTTON_HEIGHT = 64;
    protected static final int FORTRESS_BUTTON_WIDTH = 32;
    private static final class_2960 ARROWS_TEXTURE = new class_2960("textures/gui/recipe_book.png");
    protected final class_1799 itemStack;
    private final int anchorX;
    private final int anchorY;
    public boolean checked = false;
    private final Function<ItemButtonWidget, Optional<String>> tooltipTextProvider;

    public ItemButtonWidget(int anchorX, int anchorY, class_1792 item, class_4185.class_4241 clickAction, String tooltipText) {
        super(0, 0, 20, 20, 0, 0, 20, FORTRESS_BUTTON_TEXTURE, 32, 64, clickAction);
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)tooltipText)));
        this.itemStack = new class_1799((class_1935)item);
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.tooltipTextProvider = null;
    }

    public ItemButtonWidget(int anchorX, int anchorY, class_1792 item, class_4185.class_4241 clickAction, Function<ItemButtonWidget, Optional<String>> optTooltip) {
        super(0, 0, 20, 20, 0, 0, 20, FORTRESS_BUTTON_TEXTURE, 32, 64, clickAction);
        this.itemStack = new class_1799((class_1935)item);
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.tooltipTextProvider = optTooltip;
    }

    @Override
    public final void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        if (!this.field_22764) {
            return;
        }
        this.renderItem(drawContext);
        if (this.checked) {
            this.method_48588(drawContext, ARROWS_TEXTURE, this.method_46426() - 15, this.method_46427() + 2, 12, 208, 0, 14, 18, 512, 512);
        }
        if (this.field_22762) {
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1772;
            class_7919 tooltip = this.constructTooltip();
            if (tooltip != null) {
                List lines = tooltip.method_47405(client);
                drawContext.method_51436(textRenderer, lines, this.method_47937(), mouseX, mouseY);
            }
        }
    }

    @Nullable
    private class_7919 constructTooltip() {
        if (this.tooltipTextProvider != null) {
            Optional<String> tooltipText = this.tooltipTextProvider.apply(this);
            if (tooltipText.isPresent()) {
                return class_7919.method_47407((class_2561)class_2561.method_30163((String)tooltipText.get()));
            }
        } else {
            return this.method_51254();
        }
        return null;
    }

    protected void renderItem(class_332 drawContext) {
        this.renderBareItem(drawContext);
    }

    protected final void renderBareItem(class_332 drawContext) {
        drawContext.method_51427(this.itemStack, this.method_46426() + 2, this.method_46427() + 2);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        if (!this.method_25367()) {
            return;
        }
        super.method_25348(mouseX, mouseY);
    }

    @Override
    public int getAnchorX() {
        return this.anchorX;
    }

    @Override
    public int getAnchorY() {
        return this.anchorY;
    }

    public boolean method_25367() {
        return super.method_25367();
    }

    @Override
    public void setPos(int x, int y) {
        this.method_46421(x);
        this.method_46419(y);
    }

    @Override
    public boolean method_49606() {
        return super.method_49606();
    }
}

