/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.renderer.gui.professions;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.professions.IClientProfessionManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfessionsManager;
import org.jetbrains.annotations.NotNull;
import org.minefortress.renderer.gui.professions.ProfessionWidget;
import org.minefortress.renderer.gui.professions.ProfessionsPositioner;

public class ProfessionsLayer {
    private static final class_2960 LAYER_BACKGROUND = new class_2960("textures/gui/advancements/backgrounds/stone.png");
    private int layerWidth = 234;
    private int layerHeight = 113;
    private final ProfessionWidget root;
    private final List<ProfessionWidget> widgets = new LinkedList<ProfessionWidget>();
    private int minPanX = Integer.MAX_VALUE;
    private int minPanY = Integer.MAX_VALUE;
    private int maxPanX = Integer.MIN_VALUE;
    private int maxPanY = Integer.MIN_VALUE;
    private double originX;
    private double originY;
    private boolean initialized = false;
    private float alpha;
    private final int panExpand = 100;

    public ProfessionsLayer(IClientManagersProvider client) {
        IClientProfessionManager professionManager = client.get_ClientFortressManager().getProfessionManager();
        ProfessionWidget root = this.createProfessionsTree(professionManager);
        ProfessionsPositioner.arrangeForTree(root);
        for (ProfessionWidget widget : this.widgets) {
            int x = widget.getX();
            int y = widget.getY();
            this.minPanX = Math.min(this.minPanX, x);
            this.maxPanX = Math.max(this.maxPanX, x + 64);
            this.minPanY = Math.min(this.minPanY, y);
            this.maxPanY = Math.max(this.maxPanY, y + 35);
        }
        this.maxPanX += 100;
        this.maxPanY += 100;
        this.root = root;
    }

    public void setLayerSizes(int width, int height) {
        this.layerWidth = width;
        this.layerHeight = height;
    }

    public void render(class_332 drawContext) {
        this.init();
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        int originX = class_3532.method_15357((double)this.originX);
        int originY = class_3532.method_15357((double)this.originY);
        int startX = originX % 16;
        int startY = originY % 16;
        for (int x = -1; x <= this.layerWidth / 16 + 1; ++x) {
            for (int y = -1; y <= this.layerHeight / 16 + 1; ++y) {
                drawContext.method_25290(LAYER_BACKGROUND, startX + 16 * x, startY + 16 * y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.root.renderLines(drawContext, originX, originY, true);
        this.root.renderLines(drawContext, originX, originY, false);
        this.root.renderWidgets(drawContext, originX, originY);
        matrices.method_22909();
    }

    public void move(double offsetX, double offsetY) {
        if (this.maxPanX - this.minPanX + 100 > this.layerWidth) {
            this.originX = class_3532.method_15350((double)(this.originX + offsetX), (double)(-(this.maxPanX - this.layerWidth)), (double)100.0);
        }
        if (this.maxPanY - this.minPanY + 100 > this.layerHeight) {
            this.originY = class_3532.method_15350((double)(this.originY + offsetY), (double)(-(this.maxPanY - this.layerHeight)), (double)100.0);
        }
    }

    private void init() {
        if (!this.initialized) {
            this.originX = (double)((float)this.layerWidth / 2.0f) - (double)(this.maxPanX + this.minPanX - 100) / 2.0;
            this.originY = (double)((float)this.layerHeight / 2.0f) - (double)(this.maxPanY + this.minPanY - 100) / 2.0;
            this.initialized = true;
        }
    }

    @NotNull
    private ProfessionWidget createProfessionsTree(IProfessionsManager professionManager) {
        IProfession rootProfession = professionManager.getRootProfession();
        ProfessionWidget rootWidget = new ProfessionWidget(rootProfession, professionManager);
        this.createTreeNode(rootWidget, rootProfession, professionManager);
        return rootWidget;
    }

    private void createTreeNode(ProfessionWidget parentWidget, IProfession parent, IProfessionsManager professionManager) {
        List<IProfession> children = parent.getChildren();
        this.widgets.add(parentWidget);
        for (IProfession child : children) {
            ProfessionWidget childWidget = new ProfessionWidget(child, professionManager);
            childWidget.setParent(parentWidget);
            parentWidget.addChild(childWidget);
            this.createTreeNode(childWidget, child, professionManager);
        }
    }

    public void drawWidgetTooltip(class_332 drawContext, int mouseX, int mouseY, int x, int screenWidth) {
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, -200.0);
        drawContext.method_25294(0, 0, this.layerWidth, this.layerHeight, class_3532.method_15375((float)(this.alpha * 255.0f)) << 24);
        int oX = class_3532.method_15357((double)this.originX);
        int oY = class_3532.method_15357((double)this.originY);
        boolean bl = false;
        if (mouseX > 0 && mouseX < this.layerWidth && mouseY > 0 && mouseY < this.layerHeight) {
            for (ProfessionWidget advancementWidget : this.widgets) {
                if (advancementWidget.shouldNotRender(oX, oY, mouseX, mouseY)) continue;
                bl = true;
                advancementWidget.drawTooltip(drawContext, oX, oY, x, screenWidth);
                break;
            }
        }
        matrices.method_22909();
        this.alpha = bl ? class_3532.method_15363((float)(this.alpha + 0.02f), (float)0.0f, (float)0.3f) : class_3532.method_15363((float)(this.alpha - 0.04f), (float)0.0f, (float)1.0f);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        int oX = class_3532.method_15357((double)this.originX);
        int oY = class_3532.method_15357((double)this.originY);
        if (mouseX > 0.0 && mouseX < (double)this.layerWidth && mouseY > 0.0 && mouseY < (double)this.layerHeight) {
            for (ProfessionWidget professionWidget : this.widgets) {
                if (professionWidget.shouldNotRender(oX, oY, (int)mouseX, (int)mouseY)) continue;
                professionWidget.onClick(button);
                break;
            }
        }
    }
}

